<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskRelatedTask StructType
 * @subpackage Structs
 */
class TaskRelatedTask extends Entity
{
    /**
     * The CompletedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CompletedAt;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $DueDate;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $RecordID;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subject;
    /**
     * Constructor method for TaskRelatedTask
     * @uses TaskRelatedTask::setCompletedAt()
     * @uses TaskRelatedTask::setDueDate()
     * @uses TaskRelatedTask::setRecordID()
     * @uses TaskRelatedTask::setStartDate()
     * @uses TaskRelatedTask::setStatus()
     * @uses TaskRelatedTask::setSubject()
     * @param \App\API\SOAP\StructType\DateTimeValue $completedAt
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @param \App\API\SOAP\StructType\IntValue $recordID
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $subject
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $completedAt = null, \App\API\SOAP\StructType\DateTimeValue $dueDate = null, \App\API\SOAP\StructType\IntValue $recordID = null, \App\API\SOAP\StructType\DateTimeValue $startDate = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $subject = null)
    {
        $this
            ->setCompletedAt($completedAt)
            ->setDueDate($dueDate)
            ->setRecordID($recordID)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSubject($subject);
    }
    /**
     * Get CompletedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCompletedAt()
    {
        return isset($this->CompletedAt) ? $this->CompletedAt : null;
    }
    /**
     * Set CompletedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $completedAt
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setCompletedAt(\App\API\SOAP\StructType\DateTimeValue $completedAt = null)
    {
        if (is_null($completedAt) || (is_array($completedAt) && empty($completedAt))) {
            unset($this->CompletedAt);
        } else {
            $this->CompletedAt = $completedAt;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setDueDate(\App\API\SOAP\StructType\DateTimeValue $dueDate = null)
    {
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get RecordID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getRecordID()
    {
        return isset($this->RecordID) ? $this->RecordID : null;
    }
    /**
     * Set RecordID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $recordID
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setRecordID(\App\API\SOAP\StructType\IntValue $recordID = null)
    {
        if (is_null($recordID) || (is_array($recordID) && empty($recordID))) {
            unset($this->RecordID);
        } else {
            $this->RecordID = $recordID;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setStartDate(\App\API\SOAP\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subject
     * @return \App\API\SOAP\StructType\TaskRelatedTask
     */
    public function setSubject(\App\API\SOAP\StructType\StringValue $subject = null)
    {
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
}
