<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubItems StructType
 * @subpackage Structs
 */
class SubItems extends AbstractStructBase
{
    /**
     * The SubItemStockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SubItemStockItem[]
     */
    public $SubItemStockItem;
    /**
     * Constructor method for SubItems
     * @uses SubItems::setSubItemStockItem()
     * @param \App\API\SOAP\StructType\SubItemStockItem[] $subItemStockItem
     */
    public function __construct(array $subItemStockItem = array())
    {
        $this
            ->setSubItemStockItem($subItemStockItem);
    }
    /**
     * Get SubItemStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SubItemStockItem[]|null
     */
    public function getSubItemStockItem()
    {
        return isset($this->SubItemStockItem) ? $this->SubItemStockItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubItemStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubItemStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubItemStockItemForArrayConstraintsFromSetSubItemStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subItemsSubItemStockItemItem) {
            // validation for constraint: itemType
            if (!$subItemsSubItemStockItemItem instanceof \App\API\SOAP\StructType\SubItemStockItem) {
                $invalidValues[] = is_object($subItemsSubItemStockItemItem) ? get_class($subItemsSubItemStockItemItem) : sprintf('%s(%s)', gettype($subItemsSubItemStockItemItem), var_export($subItemsSubItemStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubItemStockItem property can only contain items of type \App\API\SOAP\StructType\SubItemStockItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubItemStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SubItemStockItem[] $subItemStockItem
     * @return \App\API\SOAP\StructType\SubItems
     */
    public function setSubItemStockItem(array $subItemStockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($subItemStockItemArrayErrorMessage = self::validateSubItemStockItemForArrayConstraintsFromSetSubItemStockItem($subItemStockItem))) {
            throw new \InvalidArgumentException($subItemStockItemArrayErrorMessage, __LINE__);
        }
        if (is_null($subItemStockItem) || (is_array($subItemStockItem) && empty($subItemStockItem))) {
            unset($this->SubItemStockItem);
        } else {
            $this->SubItemStockItem = $subItemStockItem;
        }
        return $this;
    }
    /**
     * Add item to SubItemStockItem value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SubItemStockItem $item
     * @return \App\API\SOAP\StructType\SubItems
     */
    public function addToSubItemStockItem(\App\API\SOAP\StructType\SubItemStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SubItemStockItem) {
            throw new \InvalidArgumentException(sprintf('The SubItemStockItem property can only contain items of type \App\API\SOAP\StructType\SubItemStockItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubItemStockItem[] = $item;
        return $this;
    }
}
