<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringSearch StructType
 * @subpackage Structs
 */
class StringSearch extends StringValue
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value2;
    /**
     * Constructor method for StringSearch
     * @uses StringSearch::setCondition()
     * @uses StringSearch::setValue2()
     * @param string $condition
     * @param string $value2
     */
    public function __construct($condition = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \App\API\SOAP\EnumType\StringCondition::valueIsValid()
     * @uses \App\API\SOAP\EnumType\StringCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \App\API\SOAP\StructType\StringSearch
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\App\API\SOAP\EnumType\StringCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\API\SOAP\EnumType\StringCondition', is_array($condition) ? implode(', ', $condition) : var_export($condition, true), implode(', ', \App\API\SOAP\EnumType\StringCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get Value2 value
     * @return string|null
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param string $value2
     * @return \App\API\SOAP\StructType\StringSearch
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: string
        if (!is_null($value2) && !is_string($value2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value2, true), gettype($value2)), __LINE__);
        }
        $this->Value2 = $value2;
        return $this;
    }
}
