<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItem StructType
 * @subpackage Structs
 */
class StockItem extends Entity
{
    /**
     * The ABCCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ABCCode;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Attributes
     */
    public $Attributes;
    /**
     * The AutoIncrementalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AutoIncrementalValue;
    /**
     * The AverageCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AverageCost;
    /**
     * The BaseUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BaseUOM;
    /**
     * The Boxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Boxes
     */
    public $Boxes;
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Categories
     */
    public $Categories;
    /**
     * The COGSAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $COGSAccount;
    /**
     * The COGSSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $COGSSubaccount;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Content;
    /**
     * The CrossReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CrossReferences
     */
    public $CrossReferences;
    /**
     * The CurrentStdCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrentStdCost;
    /**
     * The DefaultIssueLocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultIssueLocationID;
    /**
     * The DefaultPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The DefaultReceiptLocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultReceiptLocationID;
    /**
     * The DefaultSubitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultSubitem;
    /**
     * The DefaultWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultWarehouseID;
    /**
     * The DeferralAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DeferralAccount;
    /**
     * The DeferralSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DeferralSubaccount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DimensionVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DimensionVolume;
    /**
     * The DimensionWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DimensionWeight;
    /**
     * The DiscountAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ImageUrl;
    /**
     * The InventoryAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventorySubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The IsAKit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IsAKit;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemStatus;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemType;
    /**
     * The LandedCostVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LandedCostVarianceAccount;
    /**
     * The LandedCostVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LandedCostVarianceSubaccount;
    /**
     * The LastCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $LastCost;
    /**
     * The LastModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LastStdCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $LastStdCost;
    /**
     * The LotSerialClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LotSerialClass;
    /**
     * The Markup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Markup;
    /**
     * The MaxCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MaxCost;
    /**
     * The MinCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MinCost;
    /**
     * The MinMarkup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MinMarkup;
    /**
     * The MSRP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MSRP;
    /**
     * The PackagingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PackagingOption;
    /**
     * The PackSeparately
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PackSeparately;
    /**
     * The PendingStdCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PendingStdCost;
    /**
     * The POAccrualAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PostingClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PostingClass;
    /**
     * The PriceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PriceClass;
    /**
     * The PriceManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PriceManager;
    /**
     * The PriceWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PriceWorkgroup;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The PurchasePriceVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The PurchaseUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PurchaseUOM;
    /**
     * The ReasonCodeSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The ReplenishmentParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ReplenishmentParameters
     */
    public $ReplenishmentParameters;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SalesUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesUOM;
    /**
     * The StandardCostRevaluationAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StandardCostRevaluationAccount;
    /**
     * The StandardCostRevaluationSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StandardCostRevaluationSubaccount;
    /**
     * The StandardCostVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StandardCostVarianceAccount;
    /**
     * The StandardCostVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StandardCostVarianceSubaccount;
    /**
     * The SubItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SubItems
     */
    public $SubItems;
    /**
     * The SubjectToCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SubjectToCommission;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UOMConversions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\UOMConversions
     */
    public $UOMConversions;
    /**
     * The UseOnEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $UseOnEntry;
    /**
     * The ValuationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ValuationMethod;
    /**
     * The VendorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * The VolumeUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VolumeUOM;
    /**
     * The WarehouseDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\WarehouseDetails
     */
    public $WarehouseDetails;
    /**
     * The WeightUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WeightUOM;
    /**
     * Constructor method for StockItem
     * @uses StockItem::setABCCode()
     * @uses StockItem::setAttributes()
     * @uses StockItem::setAutoIncrementalValue()
     * @uses StockItem::setAverageCost()
     * @uses StockItem::setBaseUOM()
     * @uses StockItem::setBoxes()
     * @uses StockItem::setCategories()
     * @uses StockItem::setCOGSAccount()
     * @uses StockItem::setCOGSSubaccount()
     * @uses StockItem::setContent()
     * @uses StockItem::setCrossReferences()
     * @uses StockItem::setCurrentStdCost()
     * @uses StockItem::setDefaultIssueLocationID()
     * @uses StockItem::setDefaultPrice()
     * @uses StockItem::setDefaultReceiptLocationID()
     * @uses StockItem::setDefaultSubitem()
     * @uses StockItem::setDefaultWarehouseID()
     * @uses StockItem::setDeferralAccount()
     * @uses StockItem::setDeferralSubaccount()
     * @uses StockItem::setDescription()
     * @uses StockItem::setDimensionVolume()
     * @uses StockItem::setDimensionWeight()
     * @uses StockItem::setDiscountAccount()
     * @uses StockItem::setDiscountSubaccount()
     * @uses StockItem::setImageUrl()
     * @uses StockItem::setInventoryAccount()
     * @uses StockItem::setInventoryID()
     * @uses StockItem::setInventorySubaccount()
     * @uses StockItem::setIsAKit()
     * @uses StockItem::setItemClass()
     * @uses StockItem::setItemStatus()
     * @uses StockItem::setItemType()
     * @uses StockItem::setLandedCostVarianceAccount()
     * @uses StockItem::setLandedCostVarianceSubaccount()
     * @uses StockItem::setLastCost()
     * @uses StockItem::setLastModified()
     * @uses StockItem::setLastStdCost()
     * @uses StockItem::setLotSerialClass()
     * @uses StockItem::setMarkup()
     * @uses StockItem::setMaxCost()
     * @uses StockItem::setMinCost()
     * @uses StockItem::setMinMarkup()
     * @uses StockItem::setMSRP()
     * @uses StockItem::setPackagingOption()
     * @uses StockItem::setPackSeparately()
     * @uses StockItem::setPendingStdCost()
     * @uses StockItem::setPOAccrualAccount()
     * @uses StockItem::setPOAccrualSubaccount()
     * @uses StockItem::setPostingClass()
     * @uses StockItem::setPriceClass()
     * @uses StockItem::setPriceManager()
     * @uses StockItem::setPriceWorkgroup()
     * @uses StockItem::setProductManager()
     * @uses StockItem::setProductWorkgroup()
     * @uses StockItem::setPurchasePriceVarianceAccount()
     * @uses StockItem::setPurchasePriceVarianceSubaccount()
     * @uses StockItem::setPurchaseUOM()
     * @uses StockItem::setReasonCodeSubaccount()
     * @uses StockItem::setReplenishmentParameters()
     * @uses StockItem::setSalesAccount()
     * @uses StockItem::setSalesSubaccount()
     * @uses StockItem::setSalesUOM()
     * @uses StockItem::setStandardCostRevaluationAccount()
     * @uses StockItem::setStandardCostRevaluationSubaccount()
     * @uses StockItem::setStandardCostVarianceAccount()
     * @uses StockItem::setStandardCostVarianceSubaccount()
     * @uses StockItem::setSubItems()
     * @uses StockItem::setSubjectToCommission()
     * @uses StockItem::setTaxCategory()
     * @uses StockItem::setUOMConversions()
     * @uses StockItem::setUseOnEntry()
     * @uses StockItem::setValuationMethod()
     * @uses StockItem::setVendorDetails()
     * @uses StockItem::setVolumeUOM()
     * @uses StockItem::setWarehouseDetails()
     * @uses StockItem::setWeightUOM()
     * @param \App\API\SOAP\StructType\StringValue $aBCCode
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @param \App\API\SOAP\StructType\StringValue $autoIncrementalValue
     * @param \App\API\SOAP\StructType\DecimalValue $averageCost
     * @param \App\API\SOAP\StructType\StringValue $baseUOM
     * @param \App\API\SOAP\StructType\Boxes $boxes
     * @param \App\API\SOAP\StructType\Categories $categories
     * @param \App\API\SOAP\StructType\StringValue $cOGSAccount
     * @param \App\API\SOAP\StructType\StringValue $cOGSSubaccount
     * @param \App\API\SOAP\StructType\StringValue $content
     * @param \App\API\SOAP\StructType\CrossReferences $crossReferences
     * @param \App\API\SOAP\StructType\DecimalValue $currentStdCost
     * @param \App\API\SOAP\StructType\StringValue $defaultIssueLocationID
     * @param \App\API\SOAP\StructType\DecimalValue $defaultPrice
     * @param \App\API\SOAP\StructType\StringValue $defaultReceiptLocationID
     * @param \App\API\SOAP\StructType\StringValue $defaultSubitem
     * @param \App\API\SOAP\StructType\StringValue $defaultWarehouseID
     * @param \App\API\SOAP\StructType\StringValue $deferralAccount
     * @param \App\API\SOAP\StructType\StringValue $deferralSubaccount
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $dimensionVolume
     * @param \App\API\SOAP\StructType\DecimalValue $dimensionWeight
     * @param \App\API\SOAP\StructType\StringValue $discountAccount
     * @param \App\API\SOAP\StructType\StringValue $discountSubaccount
     * @param \App\API\SOAP\StructType\StringValue $imageUrl
     * @param \App\API\SOAP\StructType\StringValue $inventoryAccount
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $inventorySubaccount
     * @param \App\API\SOAP\StructType\BooleanValue $isAKit
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @param \App\API\SOAP\StructType\StringValue $itemStatus
     * @param \App\API\SOAP\StructType\StringValue $itemType
     * @param \App\API\SOAP\StructType\StringValue $landedCostVarianceAccount
     * @param \App\API\SOAP\StructType\StringValue $landedCostVarianceSubaccount
     * @param \App\API\SOAP\StructType\DecimalValue $lastCost
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModified
     * @param \App\API\SOAP\StructType\DecimalValue $lastStdCost
     * @param \App\API\SOAP\StructType\StringValue $lotSerialClass
     * @param \App\API\SOAP\StructType\DecimalValue $markup
     * @param \App\API\SOAP\StructType\DecimalValue $maxCost
     * @param \App\API\SOAP\StructType\DecimalValue $minCost
     * @param \App\API\SOAP\StructType\DecimalValue $minMarkup
     * @param \App\API\SOAP\StructType\DecimalValue $mSRP
     * @param \App\API\SOAP\StructType\StringValue $packagingOption
     * @param \App\API\SOAP\StructType\BooleanValue $packSeparately
     * @param \App\API\SOAP\StructType\DecimalValue $pendingStdCost
     * @param \App\API\SOAP\StructType\StringValue $pOAccrualAccount
     * @param \App\API\SOAP\StructType\StringValue $pOAccrualSubaccount
     * @param \App\API\SOAP\StructType\StringValue $postingClass
     * @param \App\API\SOAP\StructType\StringValue $priceClass
     * @param \App\API\SOAP\StructType\StringValue $priceManager
     * @param \App\API\SOAP\StructType\StringValue $priceWorkgroup
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @param \App\API\SOAP\StructType\StringValue $purchasePriceVarianceAccount
     * @param \App\API\SOAP\StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \App\API\SOAP\StructType\StringValue $purchaseUOM
     * @param \App\API\SOAP\StructType\StringValue $reasonCodeSubaccount
     * @param \App\API\SOAP\StructType\ReplenishmentParameters $replenishmentParameters
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @param \App\API\SOAP\StructType\StringValue $salesUOM
     * @param \App\API\SOAP\StructType\StringValue $standardCostRevaluationAccount
     * @param \App\API\SOAP\StructType\StringValue $standardCostRevaluationSubaccount
     * @param \App\API\SOAP\StructType\StringValue $standardCostVarianceAccount
     * @param \App\API\SOAP\StructType\StringValue $standardCostVarianceSubaccount
     * @param \App\API\SOAP\StructType\SubItems $subItems
     * @param \App\API\SOAP\StructType\BooleanValue $subjectToCommission
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\UOMConversions $uOMConversions
     * @param \App\API\SOAP\StructType\BooleanValue $useOnEntry
     * @param \App\API\SOAP\StructType\StringValue $valuationMethod
     * @param \App\API\SOAP\StructType\VendorDetails $vendorDetails
     * @param \App\API\SOAP\StructType\StringValue $volumeUOM
     * @param \App\API\SOAP\StructType\WarehouseDetails $warehouseDetails
     * @param \App\API\SOAP\StructType\StringValue $weightUOM
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $aBCCode = null, \App\API\SOAP\StructType\Attributes $attributes = null, \App\API\SOAP\StructType\StringValue $autoIncrementalValue = null, \App\API\SOAP\StructType\DecimalValue $averageCost = null, \App\API\SOAP\StructType\StringValue $baseUOM = null, \App\API\SOAP\StructType\Boxes $boxes = null, \App\API\SOAP\StructType\Categories $categories = null, \App\API\SOAP\StructType\StringValue $cOGSAccount = null, \App\API\SOAP\StructType\StringValue $cOGSSubaccount = null, \App\API\SOAP\StructType\StringValue $content = null, \App\API\SOAP\StructType\CrossReferences $crossReferences = null, \App\API\SOAP\StructType\DecimalValue $currentStdCost = null, \App\API\SOAP\StructType\StringValue $defaultIssueLocationID = null, \App\API\SOAP\StructType\DecimalValue $defaultPrice = null, \App\API\SOAP\StructType\StringValue $defaultReceiptLocationID = null, \App\API\SOAP\StructType\StringValue $defaultSubitem = null, \App\API\SOAP\StructType\StringValue $defaultWarehouseID = null, \App\API\SOAP\StructType\StringValue $deferralAccount = null, \App\API\SOAP\StructType\StringValue $deferralSubaccount = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $dimensionVolume = null, \App\API\SOAP\StructType\DecimalValue $dimensionWeight = null, \App\API\SOAP\StructType\StringValue $discountAccount = null, \App\API\SOAP\StructType\StringValue $discountSubaccount = null, \App\API\SOAP\StructType\StringValue $imageUrl = null, \App\API\SOAP\StructType\StringValue $inventoryAccount = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $inventorySubaccount = null, \App\API\SOAP\StructType\BooleanValue $isAKit = null, \App\API\SOAP\StructType\StringValue $itemClass = null, \App\API\SOAP\StructType\StringValue $itemStatus = null, \App\API\SOAP\StructType\StringValue $itemType = null, \App\API\SOAP\StructType\StringValue $landedCostVarianceAccount = null, \App\API\SOAP\StructType\StringValue $landedCostVarianceSubaccount = null, \App\API\SOAP\StructType\DecimalValue $lastCost = null, \App\API\SOAP\StructType\DateTimeValue $lastModified = null, \App\API\SOAP\StructType\DecimalValue $lastStdCost = null, \App\API\SOAP\StructType\StringValue $lotSerialClass = null, \App\API\SOAP\StructType\DecimalValue $markup = null, \App\API\SOAP\StructType\DecimalValue $maxCost = null, \App\API\SOAP\StructType\DecimalValue $minCost = null, \App\API\SOAP\StructType\DecimalValue $minMarkup = null, \App\API\SOAP\StructType\DecimalValue $mSRP = null, \App\API\SOAP\StructType\StringValue $packagingOption = null, \App\API\SOAP\StructType\BooleanValue $packSeparately = null, \App\API\SOAP\StructType\DecimalValue $pendingStdCost = null, \App\API\SOAP\StructType\StringValue $pOAccrualAccount = null, \App\API\SOAP\StructType\StringValue $pOAccrualSubaccount = null, \App\API\SOAP\StructType\StringValue $postingClass = null, \App\API\SOAP\StructType\StringValue $priceClass = null, \App\API\SOAP\StructType\StringValue $priceManager = null, \App\API\SOAP\StructType\StringValue $priceWorkgroup = null, \App\API\SOAP\StructType\StringValue $productManager = null, \App\API\SOAP\StructType\StringValue $productWorkgroup = null, \App\API\SOAP\StructType\StringValue $purchasePriceVarianceAccount = null, \App\API\SOAP\StructType\StringValue $purchasePriceVarianceSubaccount = null, \App\API\SOAP\StructType\StringValue $purchaseUOM = null, \App\API\SOAP\StructType\StringValue $reasonCodeSubaccount = null, \App\API\SOAP\StructType\ReplenishmentParameters $replenishmentParameters = null, \App\API\SOAP\StructType\StringValue $salesAccount = null, \App\API\SOAP\StructType\StringValue $salesSubaccount = null, \App\API\SOAP\StructType\StringValue $salesUOM = null, \App\API\SOAP\StructType\StringValue $standardCostRevaluationAccount = null, \App\API\SOAP\StructType\StringValue $standardCostRevaluationSubaccount = null, \App\API\SOAP\StructType\StringValue $standardCostVarianceAccount = null, \App\API\SOAP\StructType\StringValue $standardCostVarianceSubaccount = null, \App\API\SOAP\StructType\SubItems $subItems = null, \App\API\SOAP\StructType\BooleanValue $subjectToCommission = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\UOMConversions $uOMConversions = null, \App\API\SOAP\StructType\BooleanValue $useOnEntry = null, \App\API\SOAP\StructType\StringValue $valuationMethod = null, \App\API\SOAP\StructType\VendorDetails $vendorDetails = null, \App\API\SOAP\StructType\StringValue $volumeUOM = null, \App\API\SOAP\StructType\WarehouseDetails $warehouseDetails = null, \App\API\SOAP\StructType\StringValue $weightUOM = null)
    {
        $this
            ->setABCCode($aBCCode)
            ->setAttributes($attributes)
            ->setAutoIncrementalValue($autoIncrementalValue)
            ->setAverageCost($averageCost)
            ->setBaseUOM($baseUOM)
            ->setBoxes($boxes)
            ->setCategories($categories)
            ->setCOGSAccount($cOGSAccount)
            ->setCOGSSubaccount($cOGSSubaccount)
            ->setContent($content)
            ->setCrossReferences($crossReferences)
            ->setCurrentStdCost($currentStdCost)
            ->setDefaultIssueLocationID($defaultIssueLocationID)
            ->setDefaultPrice($defaultPrice)
            ->setDefaultReceiptLocationID($defaultReceiptLocationID)
            ->setDefaultSubitem($defaultSubitem)
            ->setDefaultWarehouseID($defaultWarehouseID)
            ->setDeferralAccount($deferralAccount)
            ->setDeferralSubaccount($deferralSubaccount)
            ->setDescription($description)
            ->setDimensionVolume($dimensionVolume)
            ->setDimensionWeight($dimensionWeight)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setImageUrl($imageUrl)
            ->setInventoryAccount($inventoryAccount)
            ->setInventoryID($inventoryID)
            ->setInventorySubaccount($inventorySubaccount)
            ->setIsAKit($isAKit)
            ->setItemClass($itemClass)
            ->setItemStatus($itemStatus)
            ->setItemType($itemType)
            ->setLandedCostVarianceAccount($landedCostVarianceAccount)
            ->setLandedCostVarianceSubaccount($landedCostVarianceSubaccount)
            ->setLastCost($lastCost)
            ->setLastModified($lastModified)
            ->setLastStdCost($lastStdCost)
            ->setLotSerialClass($lotSerialClass)
            ->setMarkup($markup)
            ->setMaxCost($maxCost)
            ->setMinCost($minCost)
            ->setMinMarkup($minMarkup)
            ->setMSRP($mSRP)
            ->setPackagingOption($packagingOption)
            ->setPackSeparately($packSeparately)
            ->setPendingStdCost($pendingStdCost)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPostingClass($postingClass)
            ->setPriceClass($priceClass)
            ->setPriceManager($priceManager)
            ->setPriceWorkgroup($priceWorkgroup)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setPurchaseUOM($purchaseUOM)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setReplenishmentParameters($replenishmentParameters)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setSalesUOM($salesUOM)
            ->setStandardCostRevaluationAccount($standardCostRevaluationAccount)
            ->setStandardCostRevaluationSubaccount($standardCostRevaluationSubaccount)
            ->setStandardCostVarianceAccount($standardCostVarianceAccount)
            ->setStandardCostVarianceSubaccount($standardCostVarianceSubaccount)
            ->setSubItems($subItems)
            ->setSubjectToCommission($subjectToCommission)
            ->setTaxCategory($taxCategory)
            ->setUOMConversions($uOMConversions)
            ->setUseOnEntry($useOnEntry)
            ->setValuationMethod($valuationMethod)
            ->setVendorDetails($vendorDetails)
            ->setVolumeUOM($volumeUOM)
            ->setWarehouseDetails($warehouseDetails)
            ->setWeightUOM($weightUOM);
    }
    /**
     * Get ABCCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getABCCode()
    {
        return isset($this->ABCCode) ? $this->ABCCode : null;
    }
    /**
     * Set ABCCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $aBCCode
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setABCCode(\App\API\SOAP\StructType\StringValue $aBCCode = null)
    {
        if (is_null($aBCCode) || (is_array($aBCCode) && empty($aBCCode))) {
            unset($this->ABCCode);
        } else {
            $this->ABCCode = $aBCCode;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setAttributes(\App\API\SOAP\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get AutoIncrementalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAutoIncrementalValue()
    {
        return isset($this->AutoIncrementalValue) ? $this->AutoIncrementalValue : null;
    }
    /**
     * Set AutoIncrementalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $autoIncrementalValue
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setAutoIncrementalValue(\App\API\SOAP\StructType\StringValue $autoIncrementalValue = null)
    {
        if (is_null($autoIncrementalValue) || (is_array($autoIncrementalValue) && empty($autoIncrementalValue))) {
            unset($this->AutoIncrementalValue);
        } else {
            $this->AutoIncrementalValue = $autoIncrementalValue;
        }
        return $this;
    }
    /**
     * Get AverageCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAverageCost()
    {
        return isset($this->AverageCost) ? $this->AverageCost : null;
    }
    /**
     * Set AverageCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $averageCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setAverageCost(\App\API\SOAP\StructType\DecimalValue $averageCost = null)
    {
        if (is_null($averageCost) || (is_array($averageCost) && empty($averageCost))) {
            unset($this->AverageCost);
        } else {
            $this->AverageCost = $averageCost;
        }
        return $this;
    }
    /**
     * Get BaseUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBaseUOM()
    {
        return isset($this->BaseUOM) ? $this->BaseUOM : null;
    }
    /**
     * Set BaseUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $baseUOM
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setBaseUOM(\App\API\SOAP\StructType\StringValue $baseUOM = null)
    {
        if (is_null($baseUOM) || (is_array($baseUOM) && empty($baseUOM))) {
            unset($this->BaseUOM);
        } else {
            $this->BaseUOM = $baseUOM;
        }
        return $this;
    }
    /**
     * Get Boxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Boxes|null
     */
    public function getBoxes()
    {
        return isset($this->Boxes) ? $this->Boxes : null;
    }
    /**
     * Set Boxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Boxes $boxes
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setBoxes(\App\API\SOAP\StructType\Boxes $boxes = null)
    {
        if (is_null($boxes) || (is_array($boxes) && empty($boxes))) {
            unset($this->Boxes);
        } else {
            $this->Boxes = $boxes;
        }
        return $this;
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Categories|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Categories $categories
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setCategories(\App\API\SOAP\StructType\Categories $categories = null)
    {
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Get COGSAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCOGSAccount()
    {
        return isset($this->COGSAccount) ? $this->COGSAccount : null;
    }
    /**
     * Set COGSAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cOGSAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setCOGSAccount(\App\API\SOAP\StructType\StringValue $cOGSAccount = null)
    {
        if (is_null($cOGSAccount) || (is_array($cOGSAccount) && empty($cOGSAccount))) {
            unset($this->COGSAccount);
        } else {
            $this->COGSAccount = $cOGSAccount;
        }
        return $this;
    }
    /**
     * Get COGSSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCOGSSubaccount()
    {
        return isset($this->COGSSubaccount) ? $this->COGSSubaccount : null;
    }
    /**
     * Set COGSSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cOGSSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setCOGSSubaccount(\App\API\SOAP\StructType\StringValue $cOGSSubaccount = null)
    {
        if (is_null($cOGSSubaccount) || (is_array($cOGSSubaccount) && empty($cOGSSubaccount))) {
            unset($this->COGSSubaccount);
        } else {
            $this->COGSSubaccount = $cOGSSubaccount;
        }
        return $this;
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $content
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setContent(\App\API\SOAP\StructType\StringValue $content = null)
    {
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get CrossReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CrossReferences|null
     */
    public function getCrossReferences()
    {
        return isset($this->CrossReferences) ? $this->CrossReferences : null;
    }
    /**
     * Set CrossReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\CrossReferences $crossReferences
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setCrossReferences(\App\API\SOAP\StructType\CrossReferences $crossReferences = null)
    {
        if (is_null($crossReferences) || (is_array($crossReferences) && empty($crossReferences))) {
            unset($this->CrossReferences);
        } else {
            $this->CrossReferences = $crossReferences;
        }
        return $this;
    }
    /**
     * Get CurrentStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrentStdCost()
    {
        return isset($this->CurrentStdCost) ? $this->CurrentStdCost : null;
    }
    /**
     * Set CurrentStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currentStdCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setCurrentStdCost(\App\API\SOAP\StructType\DecimalValue $currentStdCost = null)
    {
        if (is_null($currentStdCost) || (is_array($currentStdCost) && empty($currentStdCost))) {
            unset($this->CurrentStdCost);
        } else {
            $this->CurrentStdCost = $currentStdCost;
        }
        return $this;
    }
    /**
     * Get DefaultIssueLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultIssueLocationID()
    {
        return isset($this->DefaultIssueLocationID) ? $this->DefaultIssueLocationID : null;
    }
    /**
     * Set DefaultIssueLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultIssueLocationID
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDefaultIssueLocationID(\App\API\SOAP\StructType\StringValue $defaultIssueLocationID = null)
    {
        if (is_null($defaultIssueLocationID) || (is_array($defaultIssueLocationID) && empty($defaultIssueLocationID))) {
            unset($this->DefaultIssueLocationID);
        } else {
            $this->DefaultIssueLocationID = $defaultIssueLocationID;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $defaultPrice
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDefaultPrice(\App\API\SOAP\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get DefaultReceiptLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultReceiptLocationID()
    {
        return isset($this->DefaultReceiptLocationID) ? $this->DefaultReceiptLocationID : null;
    }
    /**
     * Set DefaultReceiptLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultReceiptLocationID
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDefaultReceiptLocationID(\App\API\SOAP\StructType\StringValue $defaultReceiptLocationID = null)
    {
        if (is_null($defaultReceiptLocationID) || (is_array($defaultReceiptLocationID) && empty($defaultReceiptLocationID))) {
            unset($this->DefaultReceiptLocationID);
        } else {
            $this->DefaultReceiptLocationID = $defaultReceiptLocationID;
        }
        return $this;
    }
    /**
     * Get DefaultSubitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultSubitem()
    {
        return isset($this->DefaultSubitem) ? $this->DefaultSubitem : null;
    }
    /**
     * Set DefaultSubitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultSubitem
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDefaultSubitem(\App\API\SOAP\StructType\StringValue $defaultSubitem = null)
    {
        if (is_null($defaultSubitem) || (is_array($defaultSubitem) && empty($defaultSubitem))) {
            unset($this->DefaultSubitem);
        } else {
            $this->DefaultSubitem = $defaultSubitem;
        }
        return $this;
    }
    /**
     * Get DefaultWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultWarehouseID()
    {
        return isset($this->DefaultWarehouseID) ? $this->DefaultWarehouseID : null;
    }
    /**
     * Set DefaultWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultWarehouseID
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDefaultWarehouseID(\App\API\SOAP\StructType\StringValue $defaultWarehouseID = null)
    {
        if (is_null($defaultWarehouseID) || (is_array($defaultWarehouseID) && empty($defaultWarehouseID))) {
            unset($this->DefaultWarehouseID);
        } else {
            $this->DefaultWarehouseID = $defaultWarehouseID;
        }
        return $this;
    }
    /**
     * Get DeferralAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDeferralAccount()
    {
        return isset($this->DeferralAccount) ? $this->DeferralAccount : null;
    }
    /**
     * Set DeferralAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $deferralAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDeferralAccount(\App\API\SOAP\StructType\StringValue $deferralAccount = null)
    {
        if (is_null($deferralAccount) || (is_array($deferralAccount) && empty($deferralAccount))) {
            unset($this->DeferralAccount);
        } else {
            $this->DeferralAccount = $deferralAccount;
        }
        return $this;
    }
    /**
     * Get DeferralSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDeferralSubaccount()
    {
        return isset($this->DeferralSubaccount) ? $this->DeferralSubaccount : null;
    }
    /**
     * Set DeferralSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $deferralSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDeferralSubaccount(\App\API\SOAP\StructType\StringValue $deferralSubaccount = null)
    {
        if (is_null($deferralSubaccount) || (is_array($deferralSubaccount) && empty($deferralSubaccount))) {
            unset($this->DeferralSubaccount);
        } else {
            $this->DeferralSubaccount = $deferralSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DimensionVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDimensionVolume()
    {
        return isset($this->DimensionVolume) ? $this->DimensionVolume : null;
    }
    /**
     * Set DimensionVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $dimensionVolume
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDimensionVolume(\App\API\SOAP\StructType\DecimalValue $dimensionVolume = null)
    {
        if (is_null($dimensionVolume) || (is_array($dimensionVolume) && empty($dimensionVolume))) {
            unset($this->DimensionVolume);
        } else {
            $this->DimensionVolume = $dimensionVolume;
        }
        return $this;
    }
    /**
     * Get DimensionWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDimensionWeight()
    {
        return isset($this->DimensionWeight) ? $this->DimensionWeight : null;
    }
    /**
     * Set DimensionWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $dimensionWeight
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDimensionWeight(\App\API\SOAP\StructType\DecimalValue $dimensionWeight = null)
    {
        if (is_null($dimensionWeight) || (is_array($dimensionWeight) && empty($dimensionWeight))) {
            unset($this->DimensionWeight);
        } else {
            $this->DimensionWeight = $dimensionWeight;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $discountAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDiscountAccount(\App\API\SOAP\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $discountSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setDiscountSubaccount(\App\API\SOAP\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get ImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getImageUrl()
    {
        return isset($this->ImageUrl) ? $this->ImageUrl : null;
    }
    /**
     * Set ImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $imageUrl
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setImageUrl(\App\API\SOAP\StructType\StringValue $imageUrl = null)
    {
        if (is_null($imageUrl) || (is_array($imageUrl) && empty($imageUrl))) {
            unset($this->ImageUrl);
        } else {
            $this->ImageUrl = $imageUrl;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setInventoryAccount(\App\API\SOAP\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventorySubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setInventorySubaccount(\App\API\SOAP\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get IsAKit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIsAKit()
    {
        return isset($this->IsAKit) ? $this->IsAKit : null;
    }
    /**
     * Set IsAKit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $isAKit
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setIsAKit(\App\API\SOAP\StructType\BooleanValue $isAKit = null)
    {
        if (is_null($isAKit) || (is_array($isAKit) && empty($isAKit))) {
            unset($this->IsAKit);
        } else {
            $this->IsAKit = $isAKit;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setItemClass(\App\API\SOAP\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemStatus()
    {
        return isset($this->ItemStatus) ? $this->ItemStatus : null;
    }
    /**
     * Set ItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemStatus
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setItemStatus(\App\API\SOAP\StructType\StringValue $itemStatus = null)
    {
        if (is_null($itemStatus) || (is_array($itemStatus) && empty($itemStatus))) {
            unset($this->ItemStatus);
        } else {
            $this->ItemStatus = $itemStatus;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemType
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setItemType(\App\API\SOAP\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLandedCostVarianceAccount()
    {
        return isset($this->LandedCostVarianceAccount) ? $this->LandedCostVarianceAccount : null;
    }
    /**
     * Set LandedCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $landedCostVarianceAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLandedCostVarianceAccount(\App\API\SOAP\StructType\StringValue $landedCostVarianceAccount = null)
    {
        if (is_null($landedCostVarianceAccount) || (is_array($landedCostVarianceAccount) && empty($landedCostVarianceAccount))) {
            unset($this->LandedCostVarianceAccount);
        } else {
            $this->LandedCostVarianceAccount = $landedCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLandedCostVarianceSubaccount()
    {
        return isset($this->LandedCostVarianceSubaccount) ? $this->LandedCostVarianceSubaccount : null;
    }
    /**
     * Set LandedCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $landedCostVarianceSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLandedCostVarianceSubaccount(\App\API\SOAP\StructType\StringValue $landedCostVarianceSubaccount = null)
    {
        if (is_null($landedCostVarianceSubaccount) || (is_array($landedCostVarianceSubaccount) && empty($landedCostVarianceSubaccount))) {
            unset($this->LandedCostVarianceSubaccount);
        } else {
            $this->LandedCostVarianceSubaccount = $landedCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get LastCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getLastCost()
    {
        return isset($this->LastCost) ? $this->LastCost : null;
    }
    /**
     * Set LastCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $lastCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLastCost(\App\API\SOAP\StructType\DecimalValue $lastCost = null)
    {
        if (is_null($lastCost) || (is_array($lastCost) && empty($lastCost))) {
            unset($this->LastCost);
        } else {
            $this->LastCost = $lastCost;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModified
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLastModified(\App\API\SOAP\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LastStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getLastStdCost()
    {
        return isset($this->LastStdCost) ? $this->LastStdCost : null;
    }
    /**
     * Set LastStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $lastStdCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLastStdCost(\App\API\SOAP\StructType\DecimalValue $lastStdCost = null)
    {
        if (is_null($lastStdCost) || (is_array($lastStdCost) && empty($lastStdCost))) {
            unset($this->LastStdCost);
        } else {
            $this->LastStdCost = $lastStdCost;
        }
        return $this;
    }
    /**
     * Get LotSerialClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLotSerialClass()
    {
        return isset($this->LotSerialClass) ? $this->LotSerialClass : null;
    }
    /**
     * Set LotSerialClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $lotSerialClass
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setLotSerialClass(\App\API\SOAP\StructType\StringValue $lotSerialClass = null)
    {
        if (is_null($lotSerialClass) || (is_array($lotSerialClass) && empty($lotSerialClass))) {
            unset($this->LotSerialClass);
        } else {
            $this->LotSerialClass = $lotSerialClass;
        }
        return $this;
    }
    /**
     * Get Markup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMarkup()
    {
        return isset($this->Markup) ? $this->Markup : null;
    }
    /**
     * Set Markup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $markup
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setMarkup(\App\API\SOAP\StructType\DecimalValue $markup = null)
    {
        if (is_null($markup) || (is_array($markup) && empty($markup))) {
            unset($this->Markup);
        } else {
            $this->Markup = $markup;
        }
        return $this;
    }
    /**
     * Get MaxCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMaxCost()
    {
        return isset($this->MaxCost) ? $this->MaxCost : null;
    }
    /**
     * Set MaxCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $maxCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setMaxCost(\App\API\SOAP\StructType\DecimalValue $maxCost = null)
    {
        if (is_null($maxCost) || (is_array($maxCost) && empty($maxCost))) {
            unset($this->MaxCost);
        } else {
            $this->MaxCost = $maxCost;
        }
        return $this;
    }
    /**
     * Get MinCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMinCost()
    {
        return isset($this->MinCost) ? $this->MinCost : null;
    }
    /**
     * Set MinCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $minCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setMinCost(\App\API\SOAP\StructType\DecimalValue $minCost = null)
    {
        if (is_null($minCost) || (is_array($minCost) && empty($minCost))) {
            unset($this->MinCost);
        } else {
            $this->MinCost = $minCost;
        }
        return $this;
    }
    /**
     * Get MinMarkup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMinMarkup()
    {
        return isset($this->MinMarkup) ? $this->MinMarkup : null;
    }
    /**
     * Set MinMarkup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $minMarkup
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setMinMarkup(\App\API\SOAP\StructType\DecimalValue $minMarkup = null)
    {
        if (is_null($minMarkup) || (is_array($minMarkup) && empty($minMarkup))) {
            unset($this->MinMarkup);
        } else {
            $this->MinMarkup = $minMarkup;
        }
        return $this;
    }
    /**
     * Get MSRP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMSRP()
    {
        return isset($this->MSRP) ? $this->MSRP : null;
    }
    /**
     * Set MSRP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $mSRP
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setMSRP(\App\API\SOAP\StructType\DecimalValue $mSRP = null)
    {
        if (is_null($mSRP) || (is_array($mSRP) && empty($mSRP))) {
            unset($this->MSRP);
        } else {
            $this->MSRP = $mSRP;
        }
        return $this;
    }
    /**
     * Get PackagingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPackagingOption()
    {
        return isset($this->PackagingOption) ? $this->PackagingOption : null;
    }
    /**
     * Set PackagingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $packagingOption
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPackagingOption(\App\API\SOAP\StructType\StringValue $packagingOption = null)
    {
        if (is_null($packagingOption) || (is_array($packagingOption) && empty($packagingOption))) {
            unset($this->PackagingOption);
        } else {
            $this->PackagingOption = $packagingOption;
        }
        return $this;
    }
    /**
     * Get PackSeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPackSeparately()
    {
        return isset($this->PackSeparately) ? $this->PackSeparately : null;
    }
    /**
     * Set PackSeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $packSeparately
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPackSeparately(\App\API\SOAP\StructType\BooleanValue $packSeparately = null)
    {
        if (is_null($packSeparately) || (is_array($packSeparately) && empty($packSeparately))) {
            unset($this->PackSeparately);
        } else {
            $this->PackSeparately = $packSeparately;
        }
        return $this;
    }
    /**
     * Get PendingStdCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPendingStdCost()
    {
        return isset($this->PendingStdCost) ? $this->PendingStdCost : null;
    }
    /**
     * Set PendingStdCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $pendingStdCost
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPendingStdCost(\App\API\SOAP\StructType\DecimalValue $pendingStdCost = null)
    {
        if (is_null($pendingStdCost) || (is_array($pendingStdCost) && empty($pendingStdCost))) {
            unset($this->PendingStdCost);
        } else {
            $this->PendingStdCost = $pendingStdCost;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOAccrualAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPOAccrualAccount(\App\API\SOAP\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOAccrualSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPOAccrualSubaccount(\App\API\SOAP\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PostingClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPostingClass()
    {
        return isset($this->PostingClass) ? $this->PostingClass : null;
    }
    /**
     * Set PostingClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $postingClass
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPostingClass(\App\API\SOAP\StructType\StringValue $postingClass = null)
    {
        if (is_null($postingClass) || (is_array($postingClass) && empty($postingClass))) {
            unset($this->PostingClass);
        } else {
            $this->PostingClass = $postingClass;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $priceClass
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPriceClass(\App\API\SOAP\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get PriceManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPriceManager()
    {
        return isset($this->PriceManager) ? $this->PriceManager : null;
    }
    /**
     * Set PriceManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $priceManager
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPriceManager(\App\API\SOAP\StructType\StringValue $priceManager = null)
    {
        if (is_null($priceManager) || (is_array($priceManager) && empty($priceManager))) {
            unset($this->PriceManager);
        } else {
            $this->PriceManager = $priceManager;
        }
        return $this;
    }
    /**
     * Get PriceWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPriceWorkgroup()
    {
        return isset($this->PriceWorkgroup) ? $this->PriceWorkgroup : null;
    }
    /**
     * Set PriceWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $priceWorkgroup
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPriceWorkgroup(\App\API\SOAP\StructType\StringValue $priceWorkgroup = null)
    {
        if (is_null($priceWorkgroup) || (is_array($priceWorkgroup) && empty($priceWorkgroup))) {
            unset($this->PriceWorkgroup);
        } else {
            $this->PriceWorkgroup = $priceWorkgroup;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setProductManager(\App\API\SOAP\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setProductWorkgroup(\App\API\SOAP\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $purchasePriceVarianceAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPurchasePriceVarianceAccount(\App\API\SOAP\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPurchasePriceVarianceSubaccount(\App\API\SOAP\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchaseUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPurchaseUOM()
    {
        return isset($this->PurchaseUOM) ? $this->PurchaseUOM : null;
    }
    /**
     * Set PurchaseUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $purchaseUOM
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setPurchaseUOM(\App\API\SOAP\StructType\StringValue $purchaseUOM = null)
    {
        if (is_null($purchaseUOM) || (is_array($purchaseUOM) && empty($purchaseUOM))) {
            unset($this->PurchaseUOM);
        } else {
            $this->PurchaseUOM = $purchaseUOM;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $reasonCodeSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setReasonCodeSubaccount(\App\API\SOAP\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get ReplenishmentParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ReplenishmentParameters|null
     */
    public function getReplenishmentParameters()
    {
        return isset($this->ReplenishmentParameters) ? $this->ReplenishmentParameters : null;
    }
    /**
     * Set ReplenishmentParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ReplenishmentParameters $replenishmentParameters
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setReplenishmentParameters(\App\API\SOAP\StructType\ReplenishmentParameters $replenishmentParameters = null)
    {
        if (is_null($replenishmentParameters) || (is_array($replenishmentParameters) && empty($replenishmentParameters))) {
            unset($this->ReplenishmentParameters);
        } else {
            $this->ReplenishmentParameters = $replenishmentParameters;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setSalesAccount(\App\API\SOAP\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setSalesSubaccount(\App\API\SOAP\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SalesUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesUOM()
    {
        return isset($this->SalesUOM) ? $this->SalesUOM : null;
    }
    /**
     * Set SalesUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesUOM
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setSalesUOM(\App\API\SOAP\StructType\StringValue $salesUOM = null)
    {
        if (is_null($salesUOM) || (is_array($salesUOM) && empty($salesUOM))) {
            unset($this->SalesUOM);
        } else {
            $this->SalesUOM = $salesUOM;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStandardCostRevaluationAccount()
    {
        return isset($this->StandardCostRevaluationAccount) ? $this->StandardCostRevaluationAccount : null;
    }
    /**
     * Set StandardCostRevaluationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $standardCostRevaluationAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setStandardCostRevaluationAccount(\App\API\SOAP\StructType\StringValue $standardCostRevaluationAccount = null)
    {
        if (is_null($standardCostRevaluationAccount) || (is_array($standardCostRevaluationAccount) && empty($standardCostRevaluationAccount))) {
            unset($this->StandardCostRevaluationAccount);
        } else {
            $this->StandardCostRevaluationAccount = $standardCostRevaluationAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStandardCostRevaluationSubaccount()
    {
        return isset($this->StandardCostRevaluationSubaccount) ? $this->StandardCostRevaluationSubaccount : null;
    }
    /**
     * Set StandardCostRevaluationSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $standardCostRevaluationSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setStandardCostRevaluationSubaccount(\App\API\SOAP\StructType\StringValue $standardCostRevaluationSubaccount = null)
    {
        if (is_null($standardCostRevaluationSubaccount) || (is_array($standardCostRevaluationSubaccount) && empty($standardCostRevaluationSubaccount))) {
            unset($this->StandardCostRevaluationSubaccount);
        } else {
            $this->StandardCostRevaluationSubaccount = $standardCostRevaluationSubaccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStandardCostVarianceAccount()
    {
        return isset($this->StandardCostVarianceAccount) ? $this->StandardCostVarianceAccount : null;
    }
    /**
     * Set StandardCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $standardCostVarianceAccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setStandardCostVarianceAccount(\App\API\SOAP\StructType\StringValue $standardCostVarianceAccount = null)
    {
        if (is_null($standardCostVarianceAccount) || (is_array($standardCostVarianceAccount) && empty($standardCostVarianceAccount))) {
            unset($this->StandardCostVarianceAccount);
        } else {
            $this->StandardCostVarianceAccount = $standardCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStandardCostVarianceSubaccount()
    {
        return isset($this->StandardCostVarianceSubaccount) ? $this->StandardCostVarianceSubaccount : null;
    }
    /**
     * Set StandardCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $standardCostVarianceSubaccount
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setStandardCostVarianceSubaccount(\App\API\SOAP\StructType\StringValue $standardCostVarianceSubaccount = null)
    {
        if (is_null($standardCostVarianceSubaccount) || (is_array($standardCostVarianceSubaccount) && empty($standardCostVarianceSubaccount))) {
            unset($this->StandardCostVarianceSubaccount);
        } else {
            $this->StandardCostVarianceSubaccount = $standardCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get SubItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SubItems|null
     */
    public function getSubItems()
    {
        return isset($this->SubItems) ? $this->SubItems : null;
    }
    /**
     * Set SubItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\SubItems $subItems
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setSubItems(\App\API\SOAP\StructType\SubItems $subItems = null)
    {
        if (is_null($subItems) || (is_array($subItems) && empty($subItems))) {
            unset($this->SubItems);
        } else {
            $this->SubItems = $subItems;
        }
        return $this;
    }
    /**
     * Get SubjectToCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSubjectToCommission()
    {
        return isset($this->SubjectToCommission) ? $this->SubjectToCommission : null;
    }
    /**
     * Set SubjectToCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $subjectToCommission
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setSubjectToCommission(\App\API\SOAP\StructType\BooleanValue $subjectToCommission = null)
    {
        if (is_null($subjectToCommission) || (is_array($subjectToCommission) && empty($subjectToCommission))) {
            unset($this->SubjectToCommission);
        } else {
            $this->SubjectToCommission = $subjectToCommission;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UOMConversions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\UOMConversions|null
     */
    public function getUOMConversions()
    {
        return isset($this->UOMConversions) ? $this->UOMConversions : null;
    }
    /**
     * Set UOMConversions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\UOMConversions $uOMConversions
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setUOMConversions(\App\API\SOAP\StructType\UOMConversions $uOMConversions = null)
    {
        if (is_null($uOMConversions) || (is_array($uOMConversions) && empty($uOMConversions))) {
            unset($this->UOMConversions);
        } else {
            $this->UOMConversions = $uOMConversions;
        }
        return $this;
    }
    /**
     * Get UseOnEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getUseOnEntry()
    {
        return isset($this->UseOnEntry) ? $this->UseOnEntry : null;
    }
    /**
     * Set UseOnEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $useOnEntry
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setUseOnEntry(\App\API\SOAP\StructType\BooleanValue $useOnEntry = null)
    {
        if (is_null($useOnEntry) || (is_array($useOnEntry) && empty($useOnEntry))) {
            unset($this->UseOnEntry);
        } else {
            $this->UseOnEntry = $useOnEntry;
        }
        return $this;
    }
    /**
     * Get ValuationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getValuationMethod()
    {
        return isset($this->ValuationMethod) ? $this->ValuationMethod : null;
    }
    /**
     * Set ValuationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $valuationMethod
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setValuationMethod(\App\API\SOAP\StructType\StringValue $valuationMethod = null)
    {
        if (is_null($valuationMethod) || (is_array($valuationMethod) && empty($valuationMethod))) {
            unset($this->ValuationMethod);
        } else {
            $this->ValuationMethod = $valuationMethod;
        }
        return $this;
    }
    /**
     * Get VendorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return isset($this->VendorDetails) ? $this->VendorDetails : null;
    }
    /**
     * Set VendorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\VendorDetails $vendorDetails
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setVendorDetails(\App\API\SOAP\StructType\VendorDetails $vendorDetails = null)
    {
        if (is_null($vendorDetails) || (is_array($vendorDetails) && empty($vendorDetails))) {
            unset($this->VendorDetails);
        } else {
            $this->VendorDetails = $vendorDetails;
        }
        return $this;
    }
    /**
     * Get VolumeUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVolumeUOM()
    {
        return isset($this->VolumeUOM) ? $this->VolumeUOM : null;
    }
    /**
     * Set VolumeUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $volumeUOM
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setVolumeUOM(\App\API\SOAP\StructType\StringValue $volumeUOM = null)
    {
        if (is_null($volumeUOM) || (is_array($volumeUOM) && empty($volumeUOM))) {
            unset($this->VolumeUOM);
        } else {
            $this->VolumeUOM = $volumeUOM;
        }
        return $this;
    }
    /**
     * Get WarehouseDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\WarehouseDetails|null
     */
    public function getWarehouseDetails()
    {
        return isset($this->WarehouseDetails) ? $this->WarehouseDetails : null;
    }
    /**
     * Set WarehouseDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\WarehouseDetails $warehouseDetails
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setWarehouseDetails(\App\API\SOAP\StructType\WarehouseDetails $warehouseDetails = null)
    {
        if (is_null($warehouseDetails) || (is_array($warehouseDetails) && empty($warehouseDetails))) {
            unset($this->WarehouseDetails);
        } else {
            $this->WarehouseDetails = $warehouseDetails;
        }
        return $this;
    }
    /**
     * Get WeightUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWeightUOM()
    {
        return isset($this->WeightUOM) ? $this->WeightUOM : null;
    }
    /**
     * Set WeightUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $weightUOM
     * @return \App\API\SOAP\StructType\StockItem
     */
    public function setWeightUOM(\App\API\SOAP\StructType\StringValue $weightUOM = null)
    {
        if (is_null($weightUOM) || (is_array($weightUOM) && empty($weightUOM))) {
            unset($this->WeightUOM);
        } else {
            $this->WeightUOM = $weightUOM;
        }
        return $this;
    }
}
