<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockComponents StructType
 * @subpackage Structs
 */
class StockComponents extends AbstractStructBase
{
    /**
     * The KitStockComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\KitStockComponent[]
     */
    public $KitStockComponent;
    /**
     * The KitAssemblyStockComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\KitAssemblyStockComponent[]
     */
    public $KitAssemblyStockComponent;
    /**
     * Constructor method for StockComponents
     * @uses StockComponents::setKitStockComponent()
     * @uses StockComponents::setKitAssemblyStockComponent()
     * @param \App\API\SOAP\StructType\KitStockComponent[] $kitStockComponent
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponent[] $kitAssemblyStockComponent
     */
    public function __construct(array $kitStockComponent = array(), array $kitAssemblyStockComponent = array())
    {
        $this
            ->setKitStockComponent($kitStockComponent)
            ->setKitAssemblyStockComponent($kitAssemblyStockComponent);
    }
    /**
     * Get KitStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\KitStockComponent[]|null
     */
    public function getKitStockComponent()
    {
        return isset($this->KitStockComponent) ? $this->KitStockComponent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitStockComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitStockComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitStockComponentForArrayConstraintsFromSetKitStockComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockComponentsKitStockComponentItem) {
            // validation for constraint: itemType
            if (!$stockComponentsKitStockComponentItem instanceof \App\API\SOAP\StructType\KitStockComponent) {
                $invalidValues[] = is_object($stockComponentsKitStockComponentItem) ? get_class($stockComponentsKitStockComponentItem) : sprintf('%s(%s)', gettype($stockComponentsKitStockComponentItem), var_export($stockComponentsKitStockComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitStockComponent property can only contain items of type \App\API\SOAP\StructType\KitStockComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitStockComponent[] $kitStockComponent
     * @return \App\API\SOAP\StructType\StockComponents
     */
    public function setKitStockComponent(array $kitStockComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($kitStockComponentArrayErrorMessage = self::validateKitStockComponentForArrayConstraintsFromSetKitStockComponent($kitStockComponent))) {
            throw new \InvalidArgumentException($kitStockComponentArrayErrorMessage, __LINE__);
        }
        if (is_null($kitStockComponent) || (is_array($kitStockComponent) && empty($kitStockComponent))) {
            unset($this->KitStockComponent);
        } else {
            $this->KitStockComponent = $kitStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitStockComponent value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitStockComponent $item
     * @return \App\API\SOAP\StructType\StockComponents
     */
    public function addToKitStockComponent(\App\API\SOAP\StructType\KitStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\KitStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitStockComponent property can only contain items of type \App\API\SOAP\StructType\KitStockComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitStockComponent[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\KitAssemblyStockComponent[]|null
     */
    public function getKitAssemblyStockComponent()
    {
        return isset($this->KitAssemblyStockComponent) ? $this->KitAssemblyStockComponent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitAssemblyStockComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitAssemblyStockComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitAssemblyStockComponentForArrayConstraintsFromSetKitAssemblyStockComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockComponentsKitAssemblyStockComponentItem) {
            // validation for constraint: itemType
            if (!$stockComponentsKitAssemblyStockComponentItem instanceof \App\API\SOAP\StructType\KitAssemblyStockComponent) {
                $invalidValues[] = is_object($stockComponentsKitAssemblyStockComponentItem) ? get_class($stockComponentsKitAssemblyStockComponentItem) : sprintf('%s(%s)', gettype($stockComponentsKitAssemblyStockComponentItem), var_export($stockComponentsKitAssemblyStockComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitAssemblyStockComponent property can only contain items of type \App\API\SOAP\StructType\KitAssemblyStockComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitAssemblyStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponent[] $kitAssemblyStockComponent
     * @return \App\API\SOAP\StructType\StockComponents
     */
    public function setKitAssemblyStockComponent(array $kitAssemblyStockComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($kitAssemblyStockComponentArrayErrorMessage = self::validateKitAssemblyStockComponentForArrayConstraintsFromSetKitAssemblyStockComponent($kitAssemblyStockComponent))) {
            throw new \InvalidArgumentException($kitAssemblyStockComponentArrayErrorMessage, __LINE__);
        }
        if (is_null($kitAssemblyStockComponent) || (is_array($kitAssemblyStockComponent) && empty($kitAssemblyStockComponent))) {
            unset($this->KitAssemblyStockComponent);
        } else {
            $this->KitAssemblyStockComponent = $kitAssemblyStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyStockComponent value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\KitAssemblyStockComponent $item
     * @return \App\API\SOAP\StructType\StockComponents
     */
    public function addToKitAssemblyStockComponent(\App\API\SOAP\StructType\KitAssemblyStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\KitAssemblyStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponent property can only contain items of type \App\API\SOAP\StructType\KitAssemblyStockComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitAssemblyStockComponent[] = $item;
        return $this;
    }
}
