<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopForRates StructType
 * @subpackage Structs
 */
class ShopForRates extends Entity
{
    /**
     * The IsManualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IsManualPackage;
    /**
     * The OrderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OrderWeight;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PackageWeight;
    /**
     * Constructor method for ShopForRates
     * @uses ShopForRates::setIsManualPackage()
     * @uses ShopForRates::setOrderWeight()
     * @uses ShopForRates::setPackageWeight()
     * @param \App\API\SOAP\StructType\BooleanValue $isManualPackage
     * @param \App\API\SOAP\StructType\DecimalValue $orderWeight
     * @param \App\API\SOAP\StructType\DecimalValue $packageWeight
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $isManualPackage = null, \App\API\SOAP\StructType\DecimalValue $orderWeight = null, \App\API\SOAP\StructType\DecimalValue $packageWeight = null)
    {
        $this
            ->setIsManualPackage($isManualPackage)
            ->setOrderWeight($orderWeight)
            ->setPackageWeight($packageWeight);
    }
    /**
     * Get IsManualPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIsManualPackage()
    {
        return isset($this->IsManualPackage) ? $this->IsManualPackage : null;
    }
    /**
     * Set IsManualPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $isManualPackage
     * @return \App\API\SOAP\StructType\ShopForRates
     */
    public function setIsManualPackage(\App\API\SOAP\StructType\BooleanValue $isManualPackage = null)
    {
        if (is_null($isManualPackage) || (is_array($isManualPackage) && empty($isManualPackage))) {
            unset($this->IsManualPackage);
        } else {
            $this->IsManualPackage = $isManualPackage;
        }
        return $this;
    }
    /**
     * Get OrderWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOrderWeight()
    {
        return isset($this->OrderWeight) ? $this->OrderWeight : null;
    }
    /**
     * Set OrderWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $orderWeight
     * @return \App\API\SOAP\StructType\ShopForRates
     */
    public function setOrderWeight(\App\API\SOAP\StructType\DecimalValue $orderWeight = null)
    {
        if (is_null($orderWeight) || (is_array($orderWeight) && empty($orderWeight))) {
            unset($this->OrderWeight);
        } else {
            $this->OrderWeight = $orderWeight;
        }
        return $this;
    }
    /**
     * Get PackageWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPackageWeight()
    {
        return isset($this->PackageWeight) ? $this->PackageWeight : null;
    }
    /**
     * Set PackageWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $packageWeight
     * @return \App\API\SOAP\StructType\ShopForRates
     */
    public function setPackageWeight(\App\API\SOAP\StructType\DecimalValue $packageWeight = null)
    {
        if (is_null($packageWeight) || (is_array($packageWeight) && empty($packageWeight))) {
            unset($this->PackageWeight);
        } else {
            $this->PackageWeight = $packageWeight;
        }
        return $this;
    }
}
