<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingSettings StructType
 * @subpackage Structs
 */
class ShippingSettings extends Entity
{
    /**
     * The CancelByDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CancelByDate;
    /**
     * The Canceled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Canceled;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The GroundCollect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $GroundCollect;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Insurance;
    /**
     * The PreferredWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PreferredWarehouseID;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $Priority;
    /**
     * The ResidentialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The ScheduledShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ScheduledShipmentDate;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingZone;
    /**
     * The ShipSeparately
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipSeparately;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The ShopForRates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShopForRates
     */
    public $ShopForRates;
    /**
     * The UseCustomersAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $UseCustomersAccount;
    /**
     * Constructor method for ShippingSettings
     * @uses ShippingSettings::setCancelByDate()
     * @uses ShippingSettings::setCanceled()
     * @uses ShippingSettings::setFOBPoint()
     * @uses ShippingSettings::setGroundCollect()
     * @uses ShippingSettings::setInsurance()
     * @uses ShippingSettings::setPreferredWarehouseID()
     * @uses ShippingSettings::setPriority()
     * @uses ShippingSettings::setResidentialDelivery()
     * @uses ShippingSettings::setSaturdayDelivery()
     * @uses ShippingSettings::setScheduledShipmentDate()
     * @uses ShippingSettings::setShippingRule()
     * @uses ShippingSettings::setShippingTerms()
     * @uses ShippingSettings::setShippingZone()
     * @uses ShippingSettings::setShipSeparately()
     * @uses ShippingSettings::setShipVia()
     * @uses ShippingSettings::setShopForRates()
     * @uses ShippingSettings::setUseCustomersAccount()
     * @param \App\API\SOAP\StructType\DateTimeValue $cancelByDate
     * @param \App\API\SOAP\StructType\BooleanValue $canceled
     * @param \App\API\SOAP\StructType\StringValue $fOBPoint
     * @param \App\API\SOAP\StructType\BooleanValue $groundCollect
     * @param \App\API\SOAP\StructType\BooleanValue $insurance
     * @param \App\API\SOAP\StructType\StringValue $preferredWarehouseID
     * @param \App\API\SOAP\StructType\ShortValue $priority
     * @param \App\API\SOAP\StructType\BooleanValue $residentialDelivery
     * @param \App\API\SOAP\StructType\BooleanValue $saturdayDelivery
     * @param \App\API\SOAP\StructType\DateTimeValue $scheduledShipmentDate
     * @param \App\API\SOAP\StructType\StringValue $shippingRule
     * @param \App\API\SOAP\StructType\StringValue $shippingTerms
     * @param \App\API\SOAP\StructType\StringValue $shippingZone
     * @param \App\API\SOAP\StructType\BooleanValue $shipSeparately
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @param \App\API\SOAP\StructType\ShopForRates $shopForRates
     * @param \App\API\SOAP\StructType\BooleanValue $useCustomersAccount
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $cancelByDate = null, \App\API\SOAP\StructType\BooleanValue $canceled = null, \App\API\SOAP\StructType\StringValue $fOBPoint = null, \App\API\SOAP\StructType\BooleanValue $groundCollect = null, \App\API\SOAP\StructType\BooleanValue $insurance = null, \App\API\SOAP\StructType\StringValue $preferredWarehouseID = null, \App\API\SOAP\StructType\ShortValue $priority = null, \App\API\SOAP\StructType\BooleanValue $residentialDelivery = null, \App\API\SOAP\StructType\BooleanValue $saturdayDelivery = null, \App\API\SOAP\StructType\DateTimeValue $scheduledShipmentDate = null, \App\API\SOAP\StructType\StringValue $shippingRule = null, \App\API\SOAP\StructType\StringValue $shippingTerms = null, \App\API\SOAP\StructType\StringValue $shippingZone = null, \App\API\SOAP\StructType\BooleanValue $shipSeparately = null, \App\API\SOAP\StructType\StringValue $shipVia = null, \App\API\SOAP\StructType\ShopForRates $shopForRates = null, \App\API\SOAP\StructType\BooleanValue $useCustomersAccount = null)
    {
        $this
            ->setCancelByDate($cancelByDate)
            ->setCanceled($canceled)
            ->setFOBPoint($fOBPoint)
            ->setGroundCollect($groundCollect)
            ->setInsurance($insurance)
            ->setPreferredWarehouseID($preferredWarehouseID)
            ->setPriority($priority)
            ->setResidentialDelivery($residentialDelivery)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setScheduledShipmentDate($scheduledShipmentDate)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setShipSeparately($shipSeparately)
            ->setShipVia($shipVia)
            ->setShopForRates($shopForRates)
            ->setUseCustomersAccount($useCustomersAccount);
    }
    /**
     * Get CancelByDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCancelByDate()
    {
        return isset($this->CancelByDate) ? $this->CancelByDate : null;
    }
    /**
     * Set CancelByDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $cancelByDate
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setCancelByDate(\App\API\SOAP\StructType\DateTimeValue $cancelByDate = null)
    {
        if (is_null($cancelByDate) || (is_array($cancelByDate) && empty($cancelByDate))) {
            unset($this->CancelByDate);
        } else {
            $this->CancelByDate = $cancelByDate;
        }
        return $this;
    }
    /**
     * Get Canceled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCanceled()
    {
        return isset($this->Canceled) ? $this->Canceled : null;
    }
    /**
     * Set Canceled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $canceled
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setCanceled(\App\API\SOAP\StructType\BooleanValue $canceled = null)
    {
        if (is_null($canceled) || (is_array($canceled) && empty($canceled))) {
            unset($this->Canceled);
        } else {
            $this->Canceled = $canceled;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fOBPoint
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setFOBPoint(\App\API\SOAP\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get GroundCollect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getGroundCollect()
    {
        return isset($this->GroundCollect) ? $this->GroundCollect : null;
    }
    /**
     * Set GroundCollect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $groundCollect
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setGroundCollect(\App\API\SOAP\StructType\BooleanValue $groundCollect = null)
    {
        if (is_null($groundCollect) || (is_array($groundCollect) && empty($groundCollect))) {
            unset($this->GroundCollect);
        } else {
            $this->GroundCollect = $groundCollect;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $insurance
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setInsurance(\App\API\SOAP\StructType\BooleanValue $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get PreferredWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPreferredWarehouseID()
    {
        return isset($this->PreferredWarehouseID) ? $this->PreferredWarehouseID : null;
    }
    /**
     * Set PreferredWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $preferredWarehouseID
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setPreferredWarehouseID(\App\API\SOAP\StructType\StringValue $preferredWarehouseID = null)
    {
        if (is_null($preferredWarehouseID) || (is_array($preferredWarehouseID) && empty($preferredWarehouseID))) {
            unset($this->PreferredWarehouseID);
        } else {
            $this->PreferredWarehouseID = $preferredWarehouseID;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $priority
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setPriority(\App\API\SOAP\StructType\ShortValue $priority = null)
    {
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $residentialDelivery
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setResidentialDelivery(\App\API\SOAP\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $saturdayDelivery
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setSaturdayDelivery(\App\API\SOAP\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get ScheduledShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getScheduledShipmentDate()
    {
        return isset($this->ScheduledShipmentDate) ? $this->ScheduledShipmentDate : null;
    }
    /**
     * Set ScheduledShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $scheduledShipmentDate
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setScheduledShipmentDate(\App\API\SOAP\StructType\DateTimeValue $scheduledShipmentDate = null)
    {
        if (is_null($scheduledShipmentDate) || (is_array($scheduledShipmentDate) && empty($scheduledShipmentDate))) {
            unset($this->ScheduledShipmentDate);
        } else {
            $this->ScheduledShipmentDate = $scheduledShipmentDate;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingRule
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShippingRule(\App\API\SOAP\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingTerms
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShippingTerms(\App\API\SOAP\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingZone()
    {
        return isset($this->ShippingZone) ? $this->ShippingZone : null;
    }
    /**
     * Set ShippingZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingZone
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShippingZone(\App\API\SOAP\StructType\StringValue $shippingZone = null)
    {
        if (is_null($shippingZone) || (is_array($shippingZone) && empty($shippingZone))) {
            unset($this->ShippingZone);
        } else {
            $this->ShippingZone = $shippingZone;
        }
        return $this;
    }
    /**
     * Get ShipSeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipSeparately()
    {
        return isset($this->ShipSeparately) ? $this->ShipSeparately : null;
    }
    /**
     * Set ShipSeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipSeparately
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShipSeparately(\App\API\SOAP\StructType\BooleanValue $shipSeparately = null)
    {
        if (is_null($shipSeparately) || (is_array($shipSeparately) && empty($shipSeparately))) {
            unset($this->ShipSeparately);
        } else {
            $this->ShipSeparately = $shipSeparately;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShipVia(\App\API\SOAP\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get ShopForRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShopForRates|null
     */
    public function getShopForRates()
    {
        return isset($this->ShopForRates) ? $this->ShopForRates : null;
    }
    /**
     * Set ShopForRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShopForRates $shopForRates
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setShopForRates(\App\API\SOAP\StructType\ShopForRates $shopForRates = null)
    {
        if (is_null($shopForRates) || (is_array($shopForRates) && empty($shopForRates))) {
            unset($this->ShopForRates);
        } else {
            $this->ShopForRates = $shopForRates;
        }
        return $this;
    }
    /**
     * Get UseCustomersAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getUseCustomersAccount()
    {
        return isset($this->UseCustomersAccount) ? $this->UseCustomersAccount : null;
    }
    /**
     * Set UseCustomersAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $useCustomersAccount
     * @return \App\API\SOAP\StructType\ShippingSettings
     */
    public function setUseCustomersAccount(\App\API\SOAP\StructType\BooleanValue $useCustomersAccount = null)
    {
        if (is_null($useCustomersAccount) || (is_array($useCustomersAccount) && empty($useCustomersAccount))) {
            unset($this->UseCustomersAccount);
        } else {
            $this->UseCustomersAccount = $useCustomersAccount;
        }
        return $this;
    }
}
