<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipments StructType
 * @subpackage Structs
 */
class Shipments extends AbstractStructBase
{
    /**
     * The SalesOrderShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesOrderShipment[]
     */
    public $SalesOrderShipment;
    /**
     * Constructor method for Shipments
     * @uses Shipments::setSalesOrderShipment()
     * @param \App\API\SOAP\StructType\SalesOrderShipment[] $salesOrderShipment
     */
    public function __construct(array $salesOrderShipment = array())
    {
        $this
            ->setSalesOrderShipment($salesOrderShipment);
    }
    /**
     * Get SalesOrderShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesOrderShipment[]|null
     */
    public function getSalesOrderShipment()
    {
        return isset($this->SalesOrderShipment) ? $this->SalesOrderShipment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrderShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrderShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrderShipmentForArrayConstraintsFromSetSalesOrderShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentsSalesOrderShipmentItem) {
            // validation for constraint: itemType
            if (!$shipmentsSalesOrderShipmentItem instanceof \App\API\SOAP\StructType\SalesOrderShipment) {
                $invalidValues[] = is_object($shipmentsSalesOrderShipmentItem) ? get_class($shipmentsSalesOrderShipmentItem) : sprintf('%s(%s)', gettype($shipmentsSalesOrderShipmentItem), var_export($shipmentsSalesOrderShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesOrderShipment property can only contain items of type \App\API\SOAP\StructType\SalesOrderShipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesOrderShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderShipment[] $salesOrderShipment
     * @return \App\API\SOAP\StructType\Shipments
     */
    public function setSalesOrderShipment(array $salesOrderShipment = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrderShipmentArrayErrorMessage = self::validateSalesOrderShipmentForArrayConstraintsFromSetSalesOrderShipment($salesOrderShipment))) {
            throw new \InvalidArgumentException($salesOrderShipmentArrayErrorMessage, __LINE__);
        }
        if (is_null($salesOrderShipment) || (is_array($salesOrderShipment) && empty($salesOrderShipment))) {
            unset($this->SalesOrderShipment);
        } else {
            $this->SalesOrderShipment = $salesOrderShipment;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderShipment value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderShipment $item
     * @return \App\API\SOAP\StructType\Shipments
     */
    public function addToSalesOrderShipment(\App\API\SOAP\StructType\SalesOrderShipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesOrderShipment) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderShipment property can only contain items of type \App\API\SOAP\StructType\SalesOrderShipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesOrderShipment[] = $item;
        return $this;
    }
}
