<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDetail StructType
 * @subpackage Structs
 */
class ShipmentDetail extends Entity
{
    /**
     * The Allocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Allocations
     */
    public $Allocations;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The FreeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $FreeItem;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The OpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OpenQty;
    /**
     * The OrderedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OrderedQty;
    /**
     * The OrderLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $OrderLineNbr;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderType;
    /**
     * The OriginalQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalQty;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The ShippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ShippedQty;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subitem;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for ShipmentDetail
     * @uses ShipmentDetail::setAllocations()
     * @uses ShipmentDetail::setDescription()
     * @uses ShipmentDetail::setExpirationDate()
     * @uses ShipmentDetail::setFreeItem()
     * @uses ShipmentDetail::setInventoryID()
     * @uses ShipmentDetail::setLineNbr()
     * @uses ShipmentDetail::setLocationID()
     * @uses ShipmentDetail::setLotSerialNbr()
     * @uses ShipmentDetail::setOpenQty()
     * @uses ShipmentDetail::setOrderedQty()
     * @uses ShipmentDetail::setOrderLineNbr()
     * @uses ShipmentDetail::setOrderNbr()
     * @uses ShipmentDetail::setOrderType()
     * @uses ShipmentDetail::setOriginalQty()
     * @uses ShipmentDetail::setReasonCode()
     * @uses ShipmentDetail::setShippedQty()
     * @uses ShipmentDetail::setSubitem()
     * @uses ShipmentDetail::setUOM()
     * @uses ShipmentDetail::setWarehouseID()
     * @param \App\API\SOAP\StructType\Allocations $allocations
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @param \App\API\SOAP\StructType\BooleanValue $freeItem
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @param \App\API\SOAP\StructType\DecimalValue $openQty
     * @param \App\API\SOAP\StructType\DecimalValue $orderedQty
     * @param \App\API\SOAP\StructType\IntValue $orderLineNbr
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @param \App\API\SOAP\StructType\DecimalValue $originalQty
     * @param \App\API\SOAP\StructType\StringValue $reasonCode
     * @param \App\API\SOAP\StructType\DecimalValue $shippedQty
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     */
    public function __construct(\App\API\SOAP\StructType\Allocations $allocations = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DateTimeValue $expirationDate = null, \App\API\SOAP\StructType\BooleanValue $freeItem = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\StringValue $lotSerialNbr = null, \App\API\SOAP\StructType\DecimalValue $openQty = null, \App\API\SOAP\StructType\DecimalValue $orderedQty = null, \App\API\SOAP\StructType\IntValue $orderLineNbr = null, \App\API\SOAP\StructType\StringValue $orderNbr = null, \App\API\SOAP\StructType\StringValue $orderType = null, \App\API\SOAP\StructType\DecimalValue $originalQty = null, \App\API\SOAP\StructType\StringValue $reasonCode = null, \App\API\SOAP\StructType\DecimalValue $shippedQty = null, \App\API\SOAP\StructType\StringValue $subitem = null, \App\API\SOAP\StructType\StringValue $uOM = null, \App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAllocations($allocations)
            ->setDescription($description)
            ->setExpirationDate($expirationDate)
            ->setFreeItem($freeItem)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setOpenQty($openQty)
            ->setOrderedQty($orderedQty)
            ->setOrderLineNbr($orderLineNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setOriginalQty($originalQty)
            ->setReasonCode($reasonCode)
            ->setShippedQty($shippedQty)
            ->setSubitem($subitem)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Allocations|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Allocations $allocations
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setAllocations(\App\API\SOAP\StructType\Allocations $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setExpirationDate(\App\API\SOAP\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get FreeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getFreeItem()
    {
        return isset($this->FreeItem) ? $this->FreeItem : null;
    }
    /**
     * Set FreeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $freeItem
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setFreeItem(\App\API\SOAP\StructType\BooleanValue $freeItem = null)
    {
        if (is_null($freeItem) || (is_array($freeItem) && empty($freeItem))) {
            unset($this->FreeItem);
        } else {
            $this->FreeItem = $freeItem;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setLotSerialNbr(\App\API\SOAP\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get OpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOpenQty()
    {
        return isset($this->OpenQty) ? $this->OpenQty : null;
    }
    /**
     * Set OpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $openQty
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOpenQty(\App\API\SOAP\StructType\DecimalValue $openQty = null)
    {
        if (is_null($openQty) || (is_array($openQty) && empty($openQty))) {
            unset($this->OpenQty);
        } else {
            $this->OpenQty = $openQty;
        }
        return $this;
    }
    /**
     * Get OrderedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOrderedQty()
    {
        return isset($this->OrderedQty) ? $this->OrderedQty : null;
    }
    /**
     * Set OrderedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $orderedQty
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOrderedQty(\App\API\SOAP\StructType\DecimalValue $orderedQty = null)
    {
        if (is_null($orderedQty) || (is_array($orderedQty) && empty($orderedQty))) {
            unset($this->OrderedQty);
        } else {
            $this->OrderedQty = $orderedQty;
        }
        return $this;
    }
    /**
     * Get OrderLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getOrderLineNbr()
    {
        return isset($this->OrderLineNbr) ? $this->OrderLineNbr : null;
    }
    /**
     * Set OrderLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $orderLineNbr
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOrderLineNbr(\App\API\SOAP\StructType\IntValue $orderLineNbr = null)
    {
        if (is_null($orderLineNbr) || (is_array($orderLineNbr) && empty($orderLineNbr))) {
            unset($this->OrderLineNbr);
        } else {
            $this->OrderLineNbr = $orderLineNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOrderNbr(\App\API\SOAP\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOrderType(\App\API\SOAP\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OriginalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalQty()
    {
        return isset($this->OriginalQty) ? $this->OriginalQty : null;
    }
    /**
     * Set OriginalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalQty
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setOriginalQty(\App\API\SOAP\StructType\DecimalValue $originalQty = null)
    {
        if (is_null($originalQty) || (is_array($originalQty) && empty($originalQty))) {
            unset($this->OriginalQty);
        } else {
            $this->OriginalQty = $originalQty;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $reasonCode
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setReasonCode(\App\API\SOAP\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get ShippedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getShippedQty()
    {
        return isset($this->ShippedQty) ? $this->ShippedQty : null;
    }
    /**
     * Set ShippedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $shippedQty
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setShippedQty(\App\API\SOAP\StructType\DecimalValue $shippedQty = null)
    {
        if (is_null($shippedQty) || (is_array($shippedQty) && empty($shippedQty))) {
            unset($this->ShippedQty);
        } else {
            $this->ShippedQty = $shippedQty;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setSubitem(\App\API\SOAP\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @return \App\API\SOAP\StructType\ShipmentDetail
     */
    public function setWarehouseID(\App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
