<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipViaFreightRate StructType
 * @subpackage Structs
 */
class ShipViaFreightRate extends Entity
{
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Rate;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Volume;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Weight;
    /**
     * The ZoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ZoneID;
    /**
     * Constructor method for ShipViaFreightRate
     * @uses ShipViaFreightRate::setLineNbr()
     * @uses ShipViaFreightRate::setRate()
     * @uses ShipViaFreightRate::setVolume()
     * @uses ShipViaFreightRate::setWeight()
     * @uses ShipViaFreightRate::setZoneID()
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\DecimalValue $rate
     * @param \App\API\SOAP\StructType\DecimalValue $volume
     * @param \App\API\SOAP\StructType\DecimalValue $weight
     * @param \App\API\SOAP\StructType\StringValue $zoneID
     */
    public function __construct(\App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\DecimalValue $rate = null, \App\API\SOAP\StructType\DecimalValue $volume = null, \App\API\SOAP\StructType\DecimalValue $weight = null, \App\API\SOAP\StructType\StringValue $zoneID = null)
    {
        $this
            ->setLineNbr($lineNbr)
            ->setRate($rate)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setZoneID($zoneID);
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\ShipViaFreightRate
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRate()
    {
        return isset($this->Rate) ? $this->Rate : null;
    }
    /**
     * Set Rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $rate
     * @return \App\API\SOAP\StructType\ShipViaFreightRate
     */
    public function setRate(\App\API\SOAP\StructType\DecimalValue $rate = null)
    {
        if (is_null($rate) || (is_array($rate) && empty($rate))) {
            unset($this->Rate);
        } else {
            $this->Rate = $rate;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $volume
     * @return \App\API\SOAP\StructType\ShipViaFreightRate
     */
    public function setVolume(\App\API\SOAP\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $weight
     * @return \App\API\SOAP\StructType\ShipViaFreightRate
     */
    public function setWeight(\App\API\SOAP\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get ZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getZoneID()
    {
        return isset($this->ZoneID) ? $this->ZoneID : null;
    }
    /**
     * Set ZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $zoneID
     * @return \App\API\SOAP\StructType\ShipViaFreightRate
     */
    public function setZoneID(\App\API\SOAP\StructType\StringValue $zoneID = null)
    {
        if (is_null($zoneID) || (is_array($zoneID) && empty($zoneID))) {
            unset($this->ZoneID);
        } else {
            $this->ZoneID = $zoneID;
        }
        return $this;
    }
}
