<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToSettings StructType
 * @subpackage Structs
 */
class ShipToSettings extends Entity
{
    /**
     * The ShipToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The Validated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Validated;
    /**
     * Constructor method for ShipToSettings
     * @uses ShipToSettings::setShipToAddress()
     * @uses ShipToSettings::setShipToAddressOverride()
     * @uses ShipToSettings::setShipToContact()
     * @uses ShipToSettings::setShipToContactOverride()
     * @uses ShipToSettings::setValidated()
     * @param \App\API\SOAP\StructType\Address $shipToAddress
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride
     * @param \App\API\SOAP\StructType\DocContact $shipToContact
     * @param \App\API\SOAP\StructType\BooleanValue $shipToContactOverride
     * @param \App\API\SOAP\StructType\BooleanValue $validated
     */
    public function __construct(\App\API\SOAP\StructType\Address $shipToAddress = null, \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride = null, \App\API\SOAP\StructType\DocContact $shipToContact = null, \App\API\SOAP\StructType\BooleanValue $shipToContactOverride = null, \App\API\SOAP\StructType\BooleanValue $validated = null)
    {
        $this
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setValidated($validated);
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $shipToAddress
     * @return \App\API\SOAP\StructType\ShipToSettings
     */
    public function setShipToAddress(\App\API\SOAP\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride
     * @return \App\API\SOAP\StructType\ShipToSettings
     */
    public function setShipToAddressOverride(\App\API\SOAP\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DocContact $shipToContact
     * @return \App\API\SOAP\StructType\ShipToSettings
     */
    public function setShipToContact(\App\API\SOAP\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipToContactOverride
     * @return \App\API\SOAP\StructType\ShipToSettings
     */
    public function setShipToContactOverride(\App\API\SOAP\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get Validated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getValidated()
    {
        return isset($this->Validated) ? $this->Validated : null;
    }
    /**
     * Set Validated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $validated
     * @return \App\API\SOAP\StructType\ShipToSettings
     */
    public function setValidated(\App\API\SOAP\StructType\BooleanValue $validated = null)
    {
        if (is_null($validated) || (is_array($validated) && empty($validated))) {
            unset($this->Validated);
        } else {
            $this->Validated = $validated;
        }
        return $this;
    }
}
