<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segments StructType
 * @subpackage Structs
 */
class Segments extends AbstractStructBase
{
    /**
     * The LotSerialClassSegment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\LotSerialClassSegment[]
     */
    public $LotSerialClassSegment;
    /**
     * Constructor method for Segments
     * @uses Segments::setLotSerialClassSegment()
     * @param \App\API\SOAP\StructType\LotSerialClassSegment[] $lotSerialClassSegment
     */
    public function __construct(array $lotSerialClassSegment = array())
    {
        $this
            ->setLotSerialClassSegment($lotSerialClassSegment);
    }
    /**
     * Get LotSerialClassSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\LotSerialClassSegment[]|null
     */
    public function getLotSerialClassSegment()
    {
        return isset($this->LotSerialClassSegment) ? $this->LotSerialClassSegment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLotSerialClassSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLotSerialClassSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLotSerialClassSegmentForArrayConstraintsFromSetLotSerialClassSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $segmentsLotSerialClassSegmentItem) {
            // validation for constraint: itemType
            if (!$segmentsLotSerialClassSegmentItem instanceof \App\API\SOAP\StructType\LotSerialClassSegment) {
                $invalidValues[] = is_object($segmentsLotSerialClassSegmentItem) ? get_class($segmentsLotSerialClassSegmentItem) : sprintf('%s(%s)', gettype($segmentsLotSerialClassSegmentItem), var_export($segmentsLotSerialClassSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LotSerialClassSegment property can only contain items of type \App\API\SOAP\StructType\LotSerialClassSegment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LotSerialClassSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\LotSerialClassSegment[] $lotSerialClassSegment
     * @return \App\API\SOAP\StructType\Segments
     */
    public function setLotSerialClassSegment(array $lotSerialClassSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($lotSerialClassSegmentArrayErrorMessage = self::validateLotSerialClassSegmentForArrayConstraintsFromSetLotSerialClassSegment($lotSerialClassSegment))) {
            throw new \InvalidArgumentException($lotSerialClassSegmentArrayErrorMessage, __LINE__);
        }
        if (is_null($lotSerialClassSegment) || (is_array($lotSerialClassSegment) && empty($lotSerialClassSegment))) {
            unset($this->LotSerialClassSegment);
        } else {
            $this->LotSerialClassSegment = $lotSerialClassSegment;
        }
        return $this;
    }
    /**
     * Add item to LotSerialClassSegment value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\LotSerialClassSegment $item
     * @return \App\API\SOAP\StructType\Segments
     */
    public function addToLotSerialClassSegment(\App\API\SOAP\StructType\LotSerialClassSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\LotSerialClassSegment) {
            throw new \InvalidArgumentException(sprintf('The LotSerialClassSegment property can only contain items of type \App\API\SOAP\StructType\LotSerialClassSegment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LotSerialClassSegment[] = $item;
        return $this;
    }
}
