<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesPrices StructType
 * @subpackage Structs
 */
class SalesPrices extends AbstractStructBase
{
    /**
     * The SalesPricesWorksheetDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesPricesWorksheetDetail[]
     */
    public $SalesPricesWorksheetDetail;
    /**
     * Constructor method for SalesPrices
     * @uses SalesPrices::setSalesPricesWorksheetDetail()
     * @param \App\API\SOAP\StructType\SalesPricesWorksheetDetail[] $salesPricesWorksheetDetail
     */
    public function __construct(array $salesPricesWorksheetDetail = array())
    {
        $this
            ->setSalesPricesWorksheetDetail($salesPricesWorksheetDetail);
    }
    /**
     * Get SalesPricesWorksheetDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesPricesWorksheetDetail[]|null
     */
    public function getSalesPricesWorksheetDetail()
    {
        return isset($this->SalesPricesWorksheetDetail) ? $this->SalesPricesWorksheetDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesPricesWorksheetDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesPricesWorksheetDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesPricesWorksheetDetailForArrayConstraintsFromSetSalesPricesWorksheetDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesPricesSalesPricesWorksheetDetailItem) {
            // validation for constraint: itemType
            if (!$salesPricesSalesPricesWorksheetDetailItem instanceof \App\API\SOAP\StructType\SalesPricesWorksheetDetail) {
                $invalidValues[] = is_object($salesPricesSalesPricesWorksheetDetailItem) ? get_class($salesPricesSalesPricesWorksheetDetailItem) : sprintf('%s(%s)', gettype($salesPricesSalesPricesWorksheetDetailItem), var_export($salesPricesSalesPricesWorksheetDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesPricesWorksheetDetail property can only contain items of type \App\API\SOAP\StructType\SalesPricesWorksheetDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesPricesWorksheetDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesPricesWorksheetDetail[] $salesPricesWorksheetDetail
     * @return \App\API\SOAP\StructType\SalesPrices
     */
    public function setSalesPricesWorksheetDetail(array $salesPricesWorksheetDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesPricesWorksheetDetailArrayErrorMessage = self::validateSalesPricesWorksheetDetailForArrayConstraintsFromSetSalesPricesWorksheetDetail($salesPricesWorksheetDetail))) {
            throw new \InvalidArgumentException($salesPricesWorksheetDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesPricesWorksheetDetail) || (is_array($salesPricesWorksheetDetail) && empty($salesPricesWorksheetDetail))) {
            unset($this->SalesPricesWorksheetDetail);
        } else {
            $this->SalesPricesWorksheetDetail = $salesPricesWorksheetDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesPricesWorksheetDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesPricesWorksheetDetail $item
     * @return \App\API\SOAP\StructType\SalesPrices
     */
    public function addToSalesPricesWorksheetDetail(\App\API\SOAP\StructType\SalesPricesWorksheetDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesPricesWorksheetDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesPricesWorksheetDetail property can only contain items of type \App\API\SOAP\StructType\SalesPricesWorksheetDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesPricesWorksheetDetail[] = $item;
        return $this;
    }
}
