<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderShipment StructType
 * @subpackage Structs
 */
class SalesOrderShipment extends Entity
{
    /**
     * The InventoryDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryDocType;
    /**
     * The InventoryRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryRefNbr;
    /**
     * The InvoiceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InvoiceNbr;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InvoiceType;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ShipmentDate;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The ShipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipmentType;
    /**
     * The ShippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ShippedQty;
    /**
     * The ShippedVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ShippedVolume;
    /**
     * The ShippedWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ShippedWeight;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for SalesOrderShipment
     * @uses SalesOrderShipment::setInventoryDocType()
     * @uses SalesOrderShipment::setInventoryRefNbr()
     * @uses SalesOrderShipment::setInvoiceNbr()
     * @uses SalesOrderShipment::setInvoiceType()
     * @uses SalesOrderShipment::setShipmentDate()
     * @uses SalesOrderShipment::setShipmentNbr()
     * @uses SalesOrderShipment::setShipmentType()
     * @uses SalesOrderShipment::setShippedQty()
     * @uses SalesOrderShipment::setShippedVolume()
     * @uses SalesOrderShipment::setShippedWeight()
     * @uses SalesOrderShipment::setStatus()
     * @param \App\API\SOAP\StructType\StringValue $inventoryDocType
     * @param \App\API\SOAP\StructType\StringValue $inventoryRefNbr
     * @param \App\API\SOAP\StructType\StringValue $invoiceNbr
     * @param \App\API\SOAP\StructType\StringValue $invoiceType
     * @param \App\API\SOAP\StructType\DateTimeValue $shipmentDate
     * @param \App\API\SOAP\StructType\StringValue $shipmentNbr
     * @param \App\API\SOAP\StructType\StringValue $shipmentType
     * @param \App\API\SOAP\StructType\DecimalValue $shippedQty
     * @param \App\API\SOAP\StructType\DecimalValue $shippedVolume
     * @param \App\API\SOAP\StructType\DecimalValue $shippedWeight
     * @param \App\API\SOAP\StructType\StringValue $status
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $inventoryDocType = null, \App\API\SOAP\StructType\StringValue $inventoryRefNbr = null, \App\API\SOAP\StructType\StringValue $invoiceNbr = null, \App\API\SOAP\StructType\StringValue $invoiceType = null, \App\API\SOAP\StructType\DateTimeValue $shipmentDate = null, \App\API\SOAP\StructType\StringValue $shipmentNbr = null, \App\API\SOAP\StructType\StringValue $shipmentType = null, \App\API\SOAP\StructType\DecimalValue $shippedQty = null, \App\API\SOAP\StructType\DecimalValue $shippedVolume = null, \App\API\SOAP\StructType\DecimalValue $shippedWeight = null, \App\API\SOAP\StructType\StringValue $status = null)
    {
        $this
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setInvoiceNbr($invoiceNbr)
            ->setInvoiceType($invoiceType)
            ->setShipmentDate($shipmentDate)
            ->setShipmentNbr($shipmentNbr)
            ->setShipmentType($shipmentType)
            ->setShippedQty($shippedQty)
            ->setShippedVolume($shippedVolume)
            ->setShippedWeight($shippedWeight)
            ->setStatus($status);
    }
    /**
     * Get InventoryDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryDocType()
    {
        return isset($this->InventoryDocType) ? $this->InventoryDocType : null;
    }
    /**
     * Set InventoryDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryDocType
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setInventoryDocType(\App\API\SOAP\StructType\StringValue $inventoryDocType = null)
    {
        if (is_null($inventoryDocType) || (is_array($inventoryDocType) && empty($inventoryDocType))) {
            unset($this->InventoryDocType);
        } else {
            $this->InventoryDocType = $inventoryDocType;
        }
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryRefNbr()
    {
        return isset($this->InventoryRefNbr) ? $this->InventoryRefNbr : null;
    }
    /**
     * Set InventoryRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryRefNbr
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setInventoryRefNbr(\App\API\SOAP\StructType\StringValue $inventoryRefNbr = null)
    {
        if (is_null($inventoryRefNbr) || (is_array($inventoryRefNbr) && empty($inventoryRefNbr))) {
            unset($this->InventoryRefNbr);
        } else {
            $this->InventoryRefNbr = $inventoryRefNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInvoiceNbr()
    {
        return isset($this->InvoiceNbr) ? $this->InvoiceNbr : null;
    }
    /**
     * Set InvoiceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $invoiceNbr
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setInvoiceNbr(\App\API\SOAP\StructType\StringValue $invoiceNbr = null)
    {
        if (is_null($invoiceNbr) || (is_array($invoiceNbr) && empty($invoiceNbr))) {
            unset($this->InvoiceNbr);
        } else {
            $this->InvoiceNbr = $invoiceNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $invoiceType
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setInvoiceType(\App\API\SOAP\StructType\StringValue $invoiceType = null)
    {
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $shipmentDate
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShipmentDate(\App\API\SOAP\StructType\DateTimeValue $shipmentDate = null)
    {
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipmentNbr
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShipmentNbr(\App\API\SOAP\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get ShipmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipmentType()
    {
        return isset($this->ShipmentType) ? $this->ShipmentType : null;
    }
    /**
     * Set ShipmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipmentType
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShipmentType(\App\API\SOAP\StructType\StringValue $shipmentType = null)
    {
        if (is_null($shipmentType) || (is_array($shipmentType) && empty($shipmentType))) {
            unset($this->ShipmentType);
        } else {
            $this->ShipmentType = $shipmentType;
        }
        return $this;
    }
    /**
     * Get ShippedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getShippedQty()
    {
        return isset($this->ShippedQty) ? $this->ShippedQty : null;
    }
    /**
     * Set ShippedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $shippedQty
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShippedQty(\App\API\SOAP\StructType\DecimalValue $shippedQty = null)
    {
        if (is_null($shippedQty) || (is_array($shippedQty) && empty($shippedQty))) {
            unset($this->ShippedQty);
        } else {
            $this->ShippedQty = $shippedQty;
        }
        return $this;
    }
    /**
     * Get ShippedVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getShippedVolume()
    {
        return isset($this->ShippedVolume) ? $this->ShippedVolume : null;
    }
    /**
     * Set ShippedVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $shippedVolume
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShippedVolume(\App\API\SOAP\StructType\DecimalValue $shippedVolume = null)
    {
        if (is_null($shippedVolume) || (is_array($shippedVolume) && empty($shippedVolume))) {
            unset($this->ShippedVolume);
        } else {
            $this->ShippedVolume = $shippedVolume;
        }
        return $this;
    }
    /**
     * Get ShippedWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getShippedWeight()
    {
        return isset($this->ShippedWeight) ? $this->ShippedWeight : null;
    }
    /**
     * Set ShippedWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $shippedWeight
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setShippedWeight(\App\API\SOAP\StructType\DecimalValue $shippedWeight = null)
    {
        if (is_null($shippedWeight) || (is_array($shippedWeight) && empty($shippedWeight))) {
            unset($this->ShippedWeight);
        } else {
            $this->ShippedWeight = $shippedWeight;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\SalesOrderShipment
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
