<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetailAllocation StructType
 * @subpackage Structs
 */
class SalesOrderDetailAllocation extends Entity
{
    /**
     * The Allocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The AllocWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AllocWarehouseID;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Completed;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderType;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The QtyOnShipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $QtyOnShipments;
    /**
     * The QtyReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $QtyReceived;
    /**
     * The RelatedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RelatedDocument;
    /**
     * The ShipOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The SplitLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $SplitLineNbr;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subitem;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for SalesOrderDetailAllocation
     * @uses SalesOrderDetailAllocation::setAllocated()
     * @uses SalesOrderDetailAllocation::setAllocWarehouseID()
     * @uses SalesOrderDetailAllocation::setCompleted()
     * @uses SalesOrderDetailAllocation::setExpirationDate()
     * @uses SalesOrderDetailAllocation::setInventoryID()
     * @uses SalesOrderDetailAllocation::setLineNbr()
     * @uses SalesOrderDetailAllocation::setLocationID()
     * @uses SalesOrderDetailAllocation::setLotSerialNbr()
     * @uses SalesOrderDetailAllocation::setOrderNbr()
     * @uses SalesOrderDetailAllocation::setOrderType()
     * @uses SalesOrderDetailAllocation::setQty()
     * @uses SalesOrderDetailAllocation::setQtyOnShipments()
     * @uses SalesOrderDetailAllocation::setQtyReceived()
     * @uses SalesOrderDetailAllocation::setRelatedDocument()
     * @uses SalesOrderDetailAllocation::setShipOn()
     * @uses SalesOrderDetailAllocation::setSplitLineNbr()
     * @uses SalesOrderDetailAllocation::setSubitem()
     * @uses SalesOrderDetailAllocation::setUOM()
     * @param \App\API\SOAP\StructType\BooleanValue $allocated
     * @param \App\API\SOAP\StructType\StringValue $allocWarehouseID
     * @param \App\API\SOAP\StructType\BooleanValue $completed
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\DecimalValue $qtyOnShipments
     * @param \App\API\SOAP\StructType\DecimalValue $qtyReceived
     * @param \App\API\SOAP\StructType\StringValue $relatedDocument
     * @param \App\API\SOAP\StructType\DateTimeValue $shipOn
     * @param \App\API\SOAP\StructType\IntValue $splitLineNbr
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @param \App\API\SOAP\StructType\StringValue $uOM
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $allocated = null, \App\API\SOAP\StructType\StringValue $allocWarehouseID = null, \App\API\SOAP\StructType\BooleanValue $completed = null, \App\API\SOAP\StructType\DateTimeValue $expirationDate = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\StringValue $lotSerialNbr = null, \App\API\SOAP\StructType\StringValue $orderNbr = null, \App\API\SOAP\StructType\StringValue $orderType = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\DecimalValue $qtyOnShipments = null, \App\API\SOAP\StructType\DecimalValue $qtyReceived = null, \App\API\SOAP\StructType\StringValue $relatedDocument = null, \App\API\SOAP\StructType\DateTimeValue $shipOn = null, \App\API\SOAP\StructType\IntValue $splitLineNbr = null, \App\API\SOAP\StructType\StringValue $subitem = null, \App\API\SOAP\StructType\StringValue $uOM = null)
    {
        $this
            ->setAllocated($allocated)
            ->setAllocWarehouseID($allocWarehouseID)
            ->setCompleted($completed)
            ->setExpirationDate($expirationDate)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setQty($qty)
            ->setQtyOnShipments($qtyOnShipments)
            ->setQtyReceived($qtyReceived)
            ->setRelatedDocument($relatedDocument)
            ->setShipOn($shipOn)
            ->setSplitLineNbr($splitLineNbr)
            ->setSubitem($subitem)
            ->setUOM($uOM);
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $allocated
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setAllocated(\App\API\SOAP\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get AllocWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAllocWarehouseID()
    {
        return isset($this->AllocWarehouseID) ? $this->AllocWarehouseID : null;
    }
    /**
     * Set AllocWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $allocWarehouseID
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setAllocWarehouseID(\App\API\SOAP\StructType\StringValue $allocWarehouseID = null)
    {
        if (is_null($allocWarehouseID) || (is_array($allocWarehouseID) && empty($allocWarehouseID))) {
            unset($this->AllocWarehouseID);
        } else {
            $this->AllocWarehouseID = $allocWarehouseID;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $completed
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setCompleted(\App\API\SOAP\StructType\BooleanValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setExpirationDate(\App\API\SOAP\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setLotSerialNbr(\App\API\SOAP\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setOrderNbr(\App\API\SOAP\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setOrderType(\App\API\SOAP\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQtyOnShipments()
    {
        return isset($this->QtyOnShipments) ? $this->QtyOnShipments : null;
    }
    /**
     * Set QtyOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qtyOnShipments
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setQtyOnShipments(\App\API\SOAP\StructType\DecimalValue $qtyOnShipments = null)
    {
        if (is_null($qtyOnShipments) || (is_array($qtyOnShipments) && empty($qtyOnShipments))) {
            unset($this->QtyOnShipments);
        } else {
            $this->QtyOnShipments = $qtyOnShipments;
        }
        return $this;
    }
    /**
     * Get QtyReceived value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQtyReceived()
    {
        return isset($this->QtyReceived) ? $this->QtyReceived : null;
    }
    /**
     * Set QtyReceived value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qtyReceived
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setQtyReceived(\App\API\SOAP\StructType\DecimalValue $qtyReceived = null)
    {
        if (is_null($qtyReceived) || (is_array($qtyReceived) && empty($qtyReceived))) {
            unset($this->QtyReceived);
        } else {
            $this->QtyReceived = $qtyReceived;
        }
        return $this;
    }
    /**
     * Get RelatedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRelatedDocument()
    {
        return isset($this->RelatedDocument) ? $this->RelatedDocument : null;
    }
    /**
     * Set RelatedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $relatedDocument
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setRelatedDocument(\App\API\SOAP\StructType\StringValue $relatedDocument = null)
    {
        if (is_null($relatedDocument) || (is_array($relatedDocument) && empty($relatedDocument))) {
            unset($this->RelatedDocument);
        } else {
            $this->RelatedDocument = $relatedDocument;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $shipOn
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setShipOn(\App\API\SOAP\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get SplitLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getSplitLineNbr()
    {
        return isset($this->SplitLineNbr) ? $this->SplitLineNbr : null;
    }
    /**
     * Set SplitLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $splitLineNbr
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setSplitLineNbr(\App\API\SOAP\StructType\IntValue $splitLineNbr = null)
    {
        if (is_null($splitLineNbr) || (is_array($splitLineNbr) && empty($splitLineNbr))) {
            unset($this->SplitLineNbr);
        } else {
            $this->SplitLineNbr = $splitLineNbr;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setSubitem(\App\API\SOAP\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\SalesOrderDetailAllocation
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
