<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrder StructType
 * @subpackage Structs
 */
class SalesOrder extends Entity
{
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Approved;
    /**
     * The BaseCurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BaseCurrencyID;
    /**
     * The BillToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $BillToAddress;
    /**
     * The BillToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillToAddressOverride;
    /**
     * The BillToAddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillToAddressValidated;
    /**
     * The BillToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DocContact
     */
    public $BillToContact;
    /**
     * The BillToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillToContactOverride;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The Commissions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Commissions
     */
    public $Commissions;
    /**
     * The ControlTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ControlTotal;
    /**
     * The CreditHold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CreditHold;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrencyRate;
    /**
     * The CurrencyRateTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyRateTypeID;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DestinationWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DestinationWarehouseID;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The DisableAutomaticDiscountUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $DisableAutomaticDiscountUpdate;
    /**
     * The DiscountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountDetails
     */
    public $DiscountDetails;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The ExternalRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExternalRef;
    /**
     * The FinancialSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\FinancialSettings
     */
    public $FinancialSettings;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The IsTaxValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IsTaxValid;
    /**
     * The LastModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The NewCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $NewCard;
    /**
     * The OrderedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OrderedQty;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderType;
    /**
     * The PaymentCardIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentCardIdentifier;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentProfileID;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Payments
     */
    public $Payments;
    /**
     * The PreAuthorizationNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PreAuthorizationNbr;
    /**
     * The PreAuthorizedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PreAuthorizedAmount;
    /**
     * The PreferredWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PreferredWarehouseID;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ReciprocalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ReciprocalRate;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The Shipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Shipments
     */
    public $Shipments;
    /**
     * The ShippingSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShippingSettings
     */
    public $ShippingSettings;
    /**
     * The ShipToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToAddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipToAddressValidated;
    /**
     * The ShipToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Totals
     */
    public $Totals;
    /**
     * The VATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VATExemptTotal;
    /**
     * The VATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VATTaxableTotal;
    /**
     * Constructor method for SalesOrder
     * @uses SalesOrder::setApproved()
     * @uses SalesOrder::setBaseCurrencyID()
     * @uses SalesOrder::setBillToAddress()
     * @uses SalesOrder::setBillToAddressOverride()
     * @uses SalesOrder::setBillToAddressValidated()
     * @uses SalesOrder::setBillToContact()
     * @uses SalesOrder::setBillToContactOverride()
     * @uses SalesOrder::setCashAccount()
     * @uses SalesOrder::setCommissions()
     * @uses SalesOrder::setControlTotal()
     * @uses SalesOrder::setCreditHold()
     * @uses SalesOrder::setCurrencyID()
     * @uses SalesOrder::setCurrencyRate()
     * @uses SalesOrder::setCurrencyRateTypeID()
     * @uses SalesOrder::setCustomerID()
     * @uses SalesOrder::setCustomerOrder()
     * @uses SalesOrder::setDate()
     * @uses SalesOrder::setDescription()
     * @uses SalesOrder::setDestinationWarehouseID()
     * @uses SalesOrder::setDetails()
     * @uses SalesOrder::setDisableAutomaticDiscountUpdate()
     * @uses SalesOrder::setDiscountDetails()
     * @uses SalesOrder::setEffectiveDate()
     * @uses SalesOrder::setExternalRef()
     * @uses SalesOrder::setFinancialSettings()
     * @uses SalesOrder::setHold()
     * @uses SalesOrder::setIsTaxValid()
     * @uses SalesOrder::setLastModified()
     * @uses SalesOrder::setLocationID()
     * @uses SalesOrder::setNewCard()
     * @uses SalesOrder::setOrderedQty()
     * @uses SalesOrder::setOrderNbr()
     * @uses SalesOrder::setOrderTotal()
     * @uses SalesOrder::setOrderType()
     * @uses SalesOrder::setPaymentCardIdentifier()
     * @uses SalesOrder::setPaymentMethod()
     * @uses SalesOrder::setPaymentProfileID()
     * @uses SalesOrder::setPaymentRef()
     * @uses SalesOrder::setPayments()
     * @uses SalesOrder::setPreAuthorizationNbr()
     * @uses SalesOrder::setPreAuthorizedAmount()
     * @uses SalesOrder::setPreferredWarehouseID()
     * @uses SalesOrder::setProject()
     * @uses SalesOrder::setReciprocalRate()
     * @uses SalesOrder::setRequestedOn()
     * @uses SalesOrder::setShipments()
     * @uses SalesOrder::setShippingSettings()
     * @uses SalesOrder::setShipToAddress()
     * @uses SalesOrder::setShipToAddressOverride()
     * @uses SalesOrder::setShipToAddressValidated()
     * @uses SalesOrder::setShipToContact()
     * @uses SalesOrder::setShipToContactOverride()
     * @uses SalesOrder::setShipVia()
     * @uses SalesOrder::setStatus()
     * @uses SalesOrder::setTaxDetails()
     * @uses SalesOrder::setTaxTotal()
     * @uses SalesOrder::setTotals()
     * @uses SalesOrder::setVATExemptTotal()
     * @uses SalesOrder::setVATTaxableTotal()
     * @param \App\API\SOAP\StructType\BooleanValue $approved
     * @param \App\API\SOAP\StructType\StringValue $baseCurrencyID
     * @param \App\API\SOAP\StructType\Address $billToAddress
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressOverride
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressValidated
     * @param \App\API\SOAP\StructType\DocContact $billToContact
     * @param \App\API\SOAP\StructType\BooleanValue $billToContactOverride
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @param \App\API\SOAP\StructType\Commissions $commissions
     * @param \App\API\SOAP\StructType\DecimalValue $controlTotal
     * @param \App\API\SOAP\StructType\BooleanValue $creditHold
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\DecimalValue $currencyRate
     * @param \App\API\SOAP\StructType\StringValue $currencyRateTypeID
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $destinationWarehouseID
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\BooleanValue $disableAutomaticDiscountUpdate
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @param \App\API\SOAP\StructType\DateTimeValue $effectiveDate
     * @param \App\API\SOAP\StructType\StringValue $externalRef
     * @param \App\API\SOAP\StructType\FinancialSettings $financialSettings
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\BooleanValue $isTaxValid
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModified
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\BooleanValue $newCard
     * @param \App\API\SOAP\StructType\DecimalValue $orderedQty
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @param \App\API\SOAP\StructType\DecimalValue $orderTotal
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @param \App\API\SOAP\StructType\StringValue $paymentCardIdentifier
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @param \App\API\SOAP\StructType\StringValue $paymentProfileID
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @param \App\API\SOAP\StructType\Payments $payments
     * @param \App\API\SOAP\StructType\StringValue $preAuthorizationNbr
     * @param \App\API\SOAP\StructType\DecimalValue $preAuthorizedAmount
     * @param \App\API\SOAP\StructType\StringValue $preferredWarehouseID
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\DecimalValue $reciprocalRate
     * @param \App\API\SOAP\StructType\DateTimeValue $requestedOn
     * @param \App\API\SOAP\StructType\Shipments $shipments
     * @param \App\API\SOAP\StructType\ShippingSettings $shippingSettings
     * @param \App\API\SOAP\StructType\Address $shipToAddress
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressValidated
     * @param \App\API\SOAP\StructType\DocContact $shipToContact
     * @param \App\API\SOAP\StructType\BooleanValue $shipToContactOverride
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @param \App\API\SOAP\StructType\DecimalValue $taxTotal
     * @param \App\API\SOAP\StructType\Totals $totals
     * @param \App\API\SOAP\StructType\DecimalValue $vATExemptTotal
     * @param \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $approved = null, \App\API\SOAP\StructType\StringValue $baseCurrencyID = null, \App\API\SOAP\StructType\Address $billToAddress = null, \App\API\SOAP\StructType\BooleanValue $billToAddressOverride = null, \App\API\SOAP\StructType\BooleanValue $billToAddressValidated = null, \App\API\SOAP\StructType\DocContact $billToContact = null, \App\API\SOAP\StructType\BooleanValue $billToContactOverride = null, \App\API\SOAP\StructType\StringValue $cashAccount = null, \App\API\SOAP\StructType\Commissions $commissions = null, \App\API\SOAP\StructType\DecimalValue $controlTotal = null, \App\API\SOAP\StructType\BooleanValue $creditHold = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\DecimalValue $currencyRate = null, \App\API\SOAP\StructType\StringValue $currencyRateTypeID = null, \App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\StringValue $customerOrder = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $destinationWarehouseID = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\BooleanValue $disableAutomaticDiscountUpdate = null, \App\API\SOAP\StructType\DiscountDetails $discountDetails = null, \App\API\SOAP\StructType\DateTimeValue $effectiveDate = null, \App\API\SOAP\StructType\StringValue $externalRef = null, \App\API\SOAP\StructType\FinancialSettings $financialSettings = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\BooleanValue $isTaxValid = null, \App\API\SOAP\StructType\DateTimeValue $lastModified = null, \App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\BooleanValue $newCard = null, \App\API\SOAP\StructType\DecimalValue $orderedQty = null, \App\API\SOAP\StructType\StringValue $orderNbr = null, \App\API\SOAP\StructType\DecimalValue $orderTotal = null, \App\API\SOAP\StructType\StringValue $orderType = null, \App\API\SOAP\StructType\StringValue $paymentCardIdentifier = null, \App\API\SOAP\StructType\StringValue $paymentMethod = null, \App\API\SOAP\StructType\StringValue $paymentProfileID = null, \App\API\SOAP\StructType\StringValue $paymentRef = null, \App\API\SOAP\StructType\Payments $payments = null, \App\API\SOAP\StructType\StringValue $preAuthorizationNbr = null, \App\API\SOAP\StructType\DecimalValue $preAuthorizedAmount = null, \App\API\SOAP\StructType\StringValue $preferredWarehouseID = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\DecimalValue $reciprocalRate = null, \App\API\SOAP\StructType\DateTimeValue $requestedOn = null, \App\API\SOAP\StructType\Shipments $shipments = null, \App\API\SOAP\StructType\ShippingSettings $shippingSettings = null, \App\API\SOAP\StructType\Address $shipToAddress = null, \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride = null, \App\API\SOAP\StructType\BooleanValue $shipToAddressValidated = null, \App\API\SOAP\StructType\DocContact $shipToContact = null, \App\API\SOAP\StructType\BooleanValue $shipToContactOverride = null, \App\API\SOAP\StructType\StringValue $shipVia = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\TaxDetails $taxDetails = null, \App\API\SOAP\StructType\DecimalValue $taxTotal = null, \App\API\SOAP\StructType\Totals $totals = null, \App\API\SOAP\StructType\DecimalValue $vATExemptTotal = null, \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal = null)
    {
        $this
            ->setApproved($approved)
            ->setBaseCurrencyID($baseCurrencyID)
            ->setBillToAddress($billToAddress)
            ->setBillToAddressOverride($billToAddressOverride)
            ->setBillToAddressValidated($billToAddressValidated)
            ->setBillToContact($billToContact)
            ->setBillToContactOverride($billToContactOverride)
            ->setCashAccount($cashAccount)
            ->setCommissions($commissions)
            ->setControlTotal($controlTotal)
            ->setCreditHold($creditHold)
            ->setCurrencyID($currencyID)
            ->setCurrencyRate($currencyRate)
            ->setCurrencyRateTypeID($currencyRateTypeID)
            ->setCustomerID($customerID)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDestinationWarehouseID($destinationWarehouseID)
            ->setDetails($details)
            ->setDisableAutomaticDiscountUpdate($disableAutomaticDiscountUpdate)
            ->setDiscountDetails($discountDetails)
            ->setEffectiveDate($effectiveDate)
            ->setExternalRef($externalRef)
            ->setFinancialSettings($financialSettings)
            ->setHold($hold)
            ->setIsTaxValid($isTaxValid)
            ->setLastModified($lastModified)
            ->setLocationID($locationID)
            ->setNewCard($newCard)
            ->setOrderedQty($orderedQty)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOrderType($orderType)
            ->setPaymentCardIdentifier($paymentCardIdentifier)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentProfileID($paymentProfileID)
            ->setPaymentRef($paymentRef)
            ->setPayments($payments)
            ->setPreAuthorizationNbr($preAuthorizationNbr)
            ->setPreAuthorizedAmount($preAuthorizedAmount)
            ->setPreferredWarehouseID($preferredWarehouseID)
            ->setProject($project)
            ->setReciprocalRate($reciprocalRate)
            ->setRequestedOn($requestedOn)
            ->setShipments($shipments)
            ->setShippingSettings($shippingSettings)
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToAddressValidated($shipToAddressValidated)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTaxTotal($taxTotal)
            ->setTotals($totals)
            ->setVATExemptTotal($vATExemptTotal)
            ->setVATTaxableTotal($vATTaxableTotal);
    }
    /**
     * Get Approved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getApproved()
    {
        return isset($this->Approved) ? $this->Approved : null;
    }
    /**
     * Set Approved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $approved
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setApproved(\App\API\SOAP\StructType\BooleanValue $approved = null)
    {
        if (is_null($approved) || (is_array($approved) && empty($approved))) {
            unset($this->Approved);
        } else {
            $this->Approved = $approved;
        }
        return $this;
    }
    /**
     * Get BaseCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBaseCurrencyID()
    {
        return isset($this->BaseCurrencyID) ? $this->BaseCurrencyID : null;
    }
    /**
     * Set BaseCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $baseCurrencyID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBaseCurrencyID(\App\API\SOAP\StructType\StringValue $baseCurrencyID = null)
    {
        if (is_null($baseCurrencyID) || (is_array($baseCurrencyID) && empty($baseCurrencyID))) {
            unset($this->BaseCurrencyID);
        } else {
            $this->BaseCurrencyID = $baseCurrencyID;
        }
        return $this;
    }
    /**
     * Get BillToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getBillToAddress()
    {
        return isset($this->BillToAddress) ? $this->BillToAddress : null;
    }
    /**
     * Set BillToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $billToAddress
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBillToAddress(\App\API\SOAP\StructType\Address $billToAddress = null)
    {
        if (is_null($billToAddress) || (is_array($billToAddress) && empty($billToAddress))) {
            unset($this->BillToAddress);
        } else {
            $this->BillToAddress = $billToAddress;
        }
        return $this;
    }
    /**
     * Get BillToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillToAddressOverride()
    {
        return isset($this->BillToAddressOverride) ? $this->BillToAddressOverride : null;
    }
    /**
     * Set BillToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressOverride
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBillToAddressOverride(\App\API\SOAP\StructType\BooleanValue $billToAddressOverride = null)
    {
        if (is_null($billToAddressOverride) || (is_array($billToAddressOverride) && empty($billToAddressOverride))) {
            unset($this->BillToAddressOverride);
        } else {
            $this->BillToAddressOverride = $billToAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillToAddressValidated()
    {
        return isset($this->BillToAddressValidated) ? $this->BillToAddressValidated : null;
    }
    /**
     * Set BillToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressValidated
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBillToAddressValidated(\App\API\SOAP\StructType\BooleanValue $billToAddressValidated = null)
    {
        if (is_null($billToAddressValidated) || (is_array($billToAddressValidated) && empty($billToAddressValidated))) {
            unset($this->BillToAddressValidated);
        } else {
            $this->BillToAddressValidated = $billToAddressValidated;
        }
        return $this;
    }
    /**
     * Get BillToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DocContact|null
     */
    public function getBillToContact()
    {
        return isset($this->BillToContact) ? $this->BillToContact : null;
    }
    /**
     * Set BillToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DocContact $billToContact
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBillToContact(\App\API\SOAP\StructType\DocContact $billToContact = null)
    {
        if (is_null($billToContact) || (is_array($billToContact) && empty($billToContact))) {
            unset($this->BillToContact);
        } else {
            $this->BillToContact = $billToContact;
        }
        return $this;
    }
    /**
     * Get BillToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillToContactOverride()
    {
        return isset($this->BillToContactOverride) ? $this->BillToContactOverride : null;
    }
    /**
     * Set BillToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billToContactOverride
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setBillToContactOverride(\App\API\SOAP\StructType\BooleanValue $billToContactOverride = null)
    {
        if (is_null($billToContactOverride) || (is_array($billToContactOverride) && empty($billToContactOverride))) {
            unset($this->BillToContactOverride);
        } else {
            $this->BillToContactOverride = $billToContactOverride;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCashAccount(\App\API\SOAP\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get Commissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Commissions|null
     */
    public function getCommissions()
    {
        return isset($this->Commissions) ? $this->Commissions : null;
    }
    /**
     * Set Commissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Commissions $commissions
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCommissions(\App\API\SOAP\StructType\Commissions $commissions = null)
    {
        if (is_null($commissions) || (is_array($commissions) && empty($commissions))) {
            unset($this->Commissions);
        } else {
            $this->Commissions = $commissions;
        }
        return $this;
    }
    /**
     * Get ControlTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getControlTotal()
    {
        return isset($this->ControlTotal) ? $this->ControlTotal : null;
    }
    /**
     * Set ControlTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $controlTotal
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setControlTotal(\App\API\SOAP\StructType\DecimalValue $controlTotal = null)
    {
        if (is_null($controlTotal) || (is_array($controlTotal) && empty($controlTotal))) {
            unset($this->ControlTotal);
        } else {
            $this->ControlTotal = $controlTotal;
        }
        return $this;
    }
    /**
     * Get CreditHold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCreditHold()
    {
        return isset($this->CreditHold) ? $this->CreditHold : null;
    }
    /**
     * Set CreditHold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $creditHold
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCreditHold(\App\API\SOAP\StructType\BooleanValue $creditHold = null)
    {
        if (is_null($creditHold) || (is_array($creditHold) && empty($creditHold))) {
            unset($this->CreditHold);
        } else {
            $this->CreditHold = $creditHold;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currencyRate
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCurrencyRate(\App\API\SOAP\StructType\DecimalValue $currencyRate = null)
    {
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get CurrencyRateTypeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyRateTypeID()
    {
        return isset($this->CurrencyRateTypeID) ? $this->CurrencyRateTypeID : null;
    }
    /**
     * Set CurrencyRateTypeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyRateTypeID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCurrencyRateTypeID(\App\API\SOAP\StructType\StringValue $currencyRateTypeID = null)
    {
        if (is_null($currencyRateTypeID) || (is_array($currencyRateTypeID) && empty($currencyRateTypeID))) {
            unset($this->CurrencyRateTypeID);
        } else {
            $this->CurrencyRateTypeID = $currencyRateTypeID;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setCustomerOrder(\App\API\SOAP\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DestinationWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDestinationWarehouseID()
    {
        return isset($this->DestinationWarehouseID) ? $this->DestinationWarehouseID : null;
    }
    /**
     * Set DestinationWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $destinationWarehouseID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDestinationWarehouseID(\App\API\SOAP\StructType\StringValue $destinationWarehouseID = null)
    {
        if (is_null($destinationWarehouseID) || (is_array($destinationWarehouseID) && empty($destinationWarehouseID))) {
            unset($this->DestinationWarehouseID);
        } else {
            $this->DestinationWarehouseID = $destinationWarehouseID;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DisableAutomaticDiscountUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getDisableAutomaticDiscountUpdate()
    {
        return isset($this->DisableAutomaticDiscountUpdate) ? $this->DisableAutomaticDiscountUpdate : null;
    }
    /**
     * Set DisableAutomaticDiscountUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $disableAutomaticDiscountUpdate
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDisableAutomaticDiscountUpdate(\App\API\SOAP\StructType\BooleanValue $disableAutomaticDiscountUpdate = null)
    {
        if (is_null($disableAutomaticDiscountUpdate) || (is_array($disableAutomaticDiscountUpdate) && empty($disableAutomaticDiscountUpdate))) {
            unset($this->DisableAutomaticDiscountUpdate);
        } else {
            $this->DisableAutomaticDiscountUpdate = $disableAutomaticDiscountUpdate;
        }
        return $this;
    }
    /**
     * Get DiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountDetails|null
     */
    public function getDiscountDetails()
    {
        return isset($this->DiscountDetails) ? $this->DiscountDetails : null;
    }
    /**
     * Set DiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setDiscountDetails(\App\API\SOAP\StructType\DiscountDetails $discountDetails = null)
    {
        if (is_null($discountDetails) || (is_array($discountDetails) && empty($discountDetails))) {
            unset($this->DiscountDetails);
        } else {
            $this->DiscountDetails = $discountDetails;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $effectiveDate
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setEffectiveDate(\App\API\SOAP\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get ExternalRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExternalRef()
    {
        return isset($this->ExternalRef) ? $this->ExternalRef : null;
    }
    /**
     * Set ExternalRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $externalRef
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setExternalRef(\App\API\SOAP\StructType\StringValue $externalRef = null)
    {
        if (is_null($externalRef) || (is_array($externalRef) && empty($externalRef))) {
            unset($this->ExternalRef);
        } else {
            $this->ExternalRef = $externalRef;
        }
        return $this;
    }
    /**
     * Get FinancialSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\FinancialSettings|null
     */
    public function getFinancialSettings()
    {
        return isset($this->FinancialSettings) ? $this->FinancialSettings : null;
    }
    /**
     * Set FinancialSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\FinancialSettings $financialSettings
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setFinancialSettings(\App\API\SOAP\StructType\FinancialSettings $financialSettings = null)
    {
        if (is_null($financialSettings) || (is_array($financialSettings) && empty($financialSettings))) {
            unset($this->FinancialSettings);
        } else {
            $this->FinancialSettings = $financialSettings;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get IsTaxValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIsTaxValid()
    {
        return isset($this->IsTaxValid) ? $this->IsTaxValid : null;
    }
    /**
     * Set IsTaxValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $isTaxValid
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setIsTaxValid(\App\API\SOAP\StructType\BooleanValue $isTaxValid = null)
    {
        if (is_null($isTaxValid) || (is_array($isTaxValid) && empty($isTaxValid))) {
            unset($this->IsTaxValid);
        } else {
            $this->IsTaxValid = $isTaxValid;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModified
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setLastModified(\App\API\SOAP\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get NewCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getNewCard()
    {
        return isset($this->NewCard) ? $this->NewCard : null;
    }
    /**
     * Set NewCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $newCard
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setNewCard(\App\API\SOAP\StructType\BooleanValue $newCard = null)
    {
        if (is_null($newCard) || (is_array($newCard) && empty($newCard))) {
            unset($this->NewCard);
        } else {
            $this->NewCard = $newCard;
        }
        return $this;
    }
    /**
     * Get OrderedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOrderedQty()
    {
        return isset($this->OrderedQty) ? $this->OrderedQty : null;
    }
    /**
     * Set OrderedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $orderedQty
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setOrderedQty(\App\API\SOAP\StructType\DecimalValue $orderedQty = null)
    {
        if (is_null($orderedQty) || (is_array($orderedQty) && empty($orderedQty))) {
            unset($this->OrderedQty);
        } else {
            $this->OrderedQty = $orderedQty;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setOrderNbr(\App\API\SOAP\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $orderTotal
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setOrderTotal(\App\API\SOAP\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setOrderType(\App\API\SOAP\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PaymentCardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentCardIdentifier()
    {
        return isset($this->PaymentCardIdentifier) ? $this->PaymentCardIdentifier : null;
    }
    /**
     * Set PaymentCardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentCardIdentifier
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPaymentCardIdentifier(\App\API\SOAP\StructType\StringValue $paymentCardIdentifier = null)
    {
        if (is_null($paymentCardIdentifier) || (is_array($paymentCardIdentifier) && empty($paymentCardIdentifier))) {
            unset($this->PaymentCardIdentifier);
        } else {
            $this->PaymentCardIdentifier = $paymentCardIdentifier;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPaymentMethod(\App\API\SOAP\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentProfileID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentProfileID()
    {
        return isset($this->PaymentProfileID) ? $this->PaymentProfileID : null;
    }
    /**
     * Set PaymentProfileID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentProfileID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPaymentProfileID(\App\API\SOAP\StructType\StringValue $paymentProfileID = null)
    {
        if (is_null($paymentProfileID) || (is_array($paymentProfileID) && empty($paymentProfileID))) {
            unset($this->PaymentProfileID);
        } else {
            $this->PaymentProfileID = $paymentProfileID;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPaymentRef(\App\API\SOAP\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Payments|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Payments $payments
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPayments(\App\API\SOAP\StructType\Payments $payments = null)
    {
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
    /**
     * Get PreAuthorizationNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPreAuthorizationNbr()
    {
        return isset($this->PreAuthorizationNbr) ? $this->PreAuthorizationNbr : null;
    }
    /**
     * Set PreAuthorizationNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $preAuthorizationNbr
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPreAuthorizationNbr(\App\API\SOAP\StructType\StringValue $preAuthorizationNbr = null)
    {
        if (is_null($preAuthorizationNbr) || (is_array($preAuthorizationNbr) && empty($preAuthorizationNbr))) {
            unset($this->PreAuthorizationNbr);
        } else {
            $this->PreAuthorizationNbr = $preAuthorizationNbr;
        }
        return $this;
    }
    /**
     * Get PreAuthorizedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPreAuthorizedAmount()
    {
        return isset($this->PreAuthorizedAmount) ? $this->PreAuthorizedAmount : null;
    }
    /**
     * Set PreAuthorizedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $preAuthorizedAmount
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPreAuthorizedAmount(\App\API\SOAP\StructType\DecimalValue $preAuthorizedAmount = null)
    {
        if (is_null($preAuthorizedAmount) || (is_array($preAuthorizedAmount) && empty($preAuthorizedAmount))) {
            unset($this->PreAuthorizedAmount);
        } else {
            $this->PreAuthorizedAmount = $preAuthorizedAmount;
        }
        return $this;
    }
    /**
     * Get PreferredWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPreferredWarehouseID()
    {
        return isset($this->PreferredWarehouseID) ? $this->PreferredWarehouseID : null;
    }
    /**
     * Set PreferredWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $preferredWarehouseID
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setPreferredWarehouseID(\App\API\SOAP\StructType\StringValue $preferredWarehouseID = null)
    {
        if (is_null($preferredWarehouseID) || (is_array($preferredWarehouseID) && empty($preferredWarehouseID))) {
            unset($this->PreferredWarehouseID);
        } else {
            $this->PreferredWarehouseID = $preferredWarehouseID;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ReciprocalRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getReciprocalRate()
    {
        return isset($this->ReciprocalRate) ? $this->ReciprocalRate : null;
    }
    /**
     * Set ReciprocalRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $reciprocalRate
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setReciprocalRate(\App\API\SOAP\StructType\DecimalValue $reciprocalRate = null)
    {
        if (is_null($reciprocalRate) || (is_array($reciprocalRate) && empty($reciprocalRate))) {
            unset($this->ReciprocalRate);
        } else {
            $this->ReciprocalRate = $reciprocalRate;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $requestedOn
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setRequestedOn(\App\API\SOAP\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Shipments|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Shipments $shipments
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipments(\App\API\SOAP\StructType\Shipments $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get ShippingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShippingSettings|null
     */
    public function getShippingSettings()
    {
        return isset($this->ShippingSettings) ? $this->ShippingSettings : null;
    }
    /**
     * Set ShippingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShippingSettings $shippingSettings
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShippingSettings(\App\API\SOAP\StructType\ShippingSettings $shippingSettings = null)
    {
        if (is_null($shippingSettings) || (is_array($shippingSettings) && empty($shippingSettings))) {
            unset($this->ShippingSettings);
        } else {
            $this->ShippingSettings = $shippingSettings;
        }
        return $this;
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $shipToAddress
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipToAddress(\App\API\SOAP\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressOverride
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipToAddressOverride(\App\API\SOAP\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipToAddressValidated()
    {
        return isset($this->ShipToAddressValidated) ? $this->ShipToAddressValidated : null;
    }
    /**
     * Set ShipToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipToAddressValidated
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipToAddressValidated(\App\API\SOAP\StructType\BooleanValue $shipToAddressValidated = null)
    {
        if (is_null($shipToAddressValidated) || (is_array($shipToAddressValidated) && empty($shipToAddressValidated))) {
            unset($this->ShipToAddressValidated);
        } else {
            $this->ShipToAddressValidated = $shipToAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DocContact $shipToContact
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipToContact(\App\API\SOAP\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shipToContactOverride
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipToContactOverride(\App\API\SOAP\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setShipVia(\App\API\SOAP\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setTaxDetails(\App\API\SOAP\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxTotal
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setTaxTotal(\App\API\SOAP\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Totals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Totals $totals
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setTotals(\App\API\SOAP\StructType\Totals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get VATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVATExemptTotal()
    {
        return isset($this->VATExemptTotal) ? $this->VATExemptTotal : null;
    }
    /**
     * Set VATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $vATExemptTotal
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setVATExemptTotal(\App\API\SOAP\StructType\DecimalValue $vATExemptTotal = null)
    {
        if (is_null($vATExemptTotal) || (is_array($vATExemptTotal) && empty($vATExemptTotal))) {
            unset($this->VATExemptTotal);
        } else {
            $this->VATExemptTotal = $vATExemptTotal;
        }
        return $this;
    }
    /**
     * Get VATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVATTaxableTotal()
    {
        return isset($this->VATTaxableTotal) ? $this->VATTaxableTotal : null;
    }
    /**
     * Set VATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal
     * @return \App\API\SOAP\StructType\SalesOrder
     */
    public function setVATTaxableTotal(\App\API\SOAP\StructType\DecimalValue $vATTaxableTotal = null)
    {
        if (is_null($vATTaxableTotal) || (is_array($vATTaxableTotal) && empty($vATTaxableTotal))) {
            unset($this->VATTaxableTotal);
        } else {
            $this->VATTaxableTotal = $vATTaxableTotal;
        }
        return $this;
    }
}
