<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceSalesPersonDetail StructType
 * @subpackage Structs
 */
class SalesInvoiceSalesPersonDetail extends Entity
{
    /**
     * The CommissionableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommissionableAmount;
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommissionAmount;
    /**
     * The CommissionPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommissionPercent;
    /**
     * The SalespersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalespersonID;
    /**
     * Constructor method for SalesInvoiceSalesPersonDetail
     * @uses SalesInvoiceSalesPersonDetail::setCommissionableAmount()
     * @uses SalesInvoiceSalesPersonDetail::setCommissionAmount()
     * @uses SalesInvoiceSalesPersonDetail::setCommissionPercent()
     * @uses SalesInvoiceSalesPersonDetail::setSalespersonID()
     * @param \App\API\SOAP\StructType\DecimalValue $commissionableAmount
     * @param \App\API\SOAP\StructType\DecimalValue $commissionAmount
     * @param \App\API\SOAP\StructType\DecimalValue $commissionPercent
     * @param \App\API\SOAP\StructType\StringValue $salespersonID
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $commissionableAmount = null, \App\API\SOAP\StructType\DecimalValue $commissionAmount = null, \App\API\SOAP\StructType\DecimalValue $commissionPercent = null, \App\API\SOAP\StructType\StringValue $salespersonID = null)
    {
        $this
            ->setCommissionableAmount($commissionableAmount)
            ->setCommissionAmount($commissionAmount)
            ->setCommissionPercent($commissionPercent)
            ->setSalespersonID($salespersonID);
    }
    /**
     * Get CommissionableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommissionableAmount()
    {
        return isset($this->CommissionableAmount) ? $this->CommissionableAmount : null;
    }
    /**
     * Set CommissionableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $commissionableAmount
     * @return \App\API\SOAP\StructType\SalesInvoiceSalesPersonDetail
     */
    public function setCommissionableAmount(\App\API\SOAP\StructType\DecimalValue $commissionableAmount = null)
    {
        if (is_null($commissionableAmount) || (is_array($commissionableAmount) && empty($commissionableAmount))) {
            unset($this->CommissionableAmount);
        } else {
            $this->CommissionableAmount = $commissionableAmount;
        }
        return $this;
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $commissionAmount
     * @return \App\API\SOAP\StructType\SalesInvoiceSalesPersonDetail
     */
    public function setCommissionAmount(\App\API\SOAP\StructType\DecimalValue $commissionAmount = null)
    {
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get CommissionPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommissionPercent()
    {
        return isset($this->CommissionPercent) ? $this->CommissionPercent : null;
    }
    /**
     * Set CommissionPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $commissionPercent
     * @return \App\API\SOAP\StructType\SalesInvoiceSalesPersonDetail
     */
    public function setCommissionPercent(\App\API\SOAP\StructType\DecimalValue $commissionPercent = null)
    {
        if (is_null($commissionPercent) || (is_array($commissionPercent) && empty($commissionPercent))) {
            unset($this->CommissionPercent);
        } else {
            $this->CommissionPercent = $commissionPercent;
        }
        return $this;
    }
    /**
     * Get SalespersonID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalespersonID()
    {
        return isset($this->SalespersonID) ? $this->SalespersonID : null;
    }
    /**
     * Set SalespersonID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salespersonID
     * @return \App\API\SOAP\StructType\SalesInvoiceSalesPersonDetail
     */
    public function setSalespersonID(\App\API\SOAP\StructType\StringValue $salespersonID = null)
    {
        if (is_null($salespersonID) || (is_array($salespersonID) && empty($salespersonID))) {
            unset($this->SalespersonID);
        } else {
            $this->SalespersonID = $salespersonID;
        }
        return $this;
    }
}
