<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceDetail StructType
 * @subpackage Structs
 */
class SalesInvoiceDetail extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BranchID;
    /**
     * The CalculateDiscountsOnImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CalculateDiscountsOnImport;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DiscountPercent;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The InventoryDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryDocType;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventoryRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryRefNbr;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Location;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The OrderLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $OrderLineNbr;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderType;
    /**
     * The OrigInvLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $OrigInvLineNbr;
    /**
     * The OrigInvNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrigInvNbr;
    /**
     * The OrigInvType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrigInvType;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subitem;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TransactionDescr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TransactionDescr;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesInvoiceDetail
     * @uses SalesInvoiceDetail::setAmount()
     * @uses SalesInvoiceDetail::setBranchID()
     * @uses SalesInvoiceDetail::setCalculateDiscountsOnImport()
     * @uses SalesInvoiceDetail::setCostCode()
     * @uses SalesInvoiceDetail::setDescription()
     * @uses SalesInvoiceDetail::setDiscountAmount()
     * @uses SalesInvoiceDetail::setDiscountPercent()
     * @uses SalesInvoiceDetail::setExpirationDate()
     * @uses SalesInvoiceDetail::setInventoryDocType()
     * @uses SalesInvoiceDetail::setInventoryID()
     * @uses SalesInvoiceDetail::setInventoryRefNbr()
     * @uses SalesInvoiceDetail::setLineNbr()
     * @uses SalesInvoiceDetail::setLocation()
     * @uses SalesInvoiceDetail::setLotSerialNbr()
     * @uses SalesInvoiceDetail::setManualDiscount()
     * @uses SalesInvoiceDetail::setOrderLineNbr()
     * @uses SalesInvoiceDetail::setOrderNbr()
     * @uses SalesInvoiceDetail::setOrderType()
     * @uses SalesInvoiceDetail::setOrigInvLineNbr()
     * @uses SalesInvoiceDetail::setOrigInvNbr()
     * @uses SalesInvoiceDetail::setOrigInvType()
     * @uses SalesInvoiceDetail::setProjectTask()
     * @uses SalesInvoiceDetail::setQty()
     * @uses SalesInvoiceDetail::setShipmentNbr()
     * @uses SalesInvoiceDetail::setSubitem()
     * @uses SalesInvoiceDetail::setTaxCategory()
     * @uses SalesInvoiceDetail::setTransactionDescr()
     * @uses SalesInvoiceDetail::setUnitPrice()
     * @uses SalesInvoiceDetail::setUOM()
     * @uses SalesInvoiceDetail::setWarehouseID()
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\StringValue $branchID
     * @param \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $discountAmount
     * @param \App\API\SOAP\StructType\DecimalValue $discountPercent
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @param \App\API\SOAP\StructType\StringValue $inventoryDocType
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $inventoryRefNbr
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\StringValue $location
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @param \App\API\SOAP\StructType\BooleanValue $manualDiscount
     * @param \App\API\SOAP\StructType\IntValue $orderLineNbr
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @param \App\API\SOAP\StructType\IntValue $origInvLineNbr
     * @param \App\API\SOAP\StructType\StringValue $origInvNbr
     * @param \App\API\SOAP\StructType\StringValue $origInvType
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\StringValue $shipmentNbr
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\StringValue $transactionDescr
     * @param \App\API\SOAP\StructType\DecimalValue $unitPrice
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\StringValue $branchID = null, \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $discountAmount = null, \App\API\SOAP\StructType\DecimalValue $discountPercent = null, \App\API\SOAP\StructType\DateTimeValue $expirationDate = null, \App\API\SOAP\StructType\StringValue $inventoryDocType = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $inventoryRefNbr = null, \App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\StringValue $location = null, \App\API\SOAP\StructType\StringValue $lotSerialNbr = null, \App\API\SOAP\StructType\BooleanValue $manualDiscount = null, \App\API\SOAP\StructType\IntValue $orderLineNbr = null, \App\API\SOAP\StructType\StringValue $orderNbr = null, \App\API\SOAP\StructType\StringValue $orderType = null, \App\API\SOAP\StructType\IntValue $origInvLineNbr = null, \App\API\SOAP\StructType\StringValue $origInvNbr = null, \App\API\SOAP\StructType\StringValue $origInvType = null, \App\API\SOAP\StructType\StringValue $projectTask = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\StringValue $shipmentNbr = null, \App\API\SOAP\StructType\StringValue $subitem = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\StringValue $transactionDescr = null, \App\API\SOAP\StructType\DecimalValue $unitPrice = null, \App\API\SOAP\StructType\StringValue $uOM = null, \App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAmount($amount)
            ->setBranchID($branchID)
            ->setCalculateDiscountsOnImport($calculateDiscountsOnImport)
            ->setCostCode($costCode)
            ->setDescription($description)
            ->setDiscountAmount($discountAmount)
            ->setDiscountPercent($discountPercent)
            ->setExpirationDate($expirationDate)
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryID($inventoryID)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setLineNbr($lineNbr)
            ->setLocation($location)
            ->setLotSerialNbr($lotSerialNbr)
            ->setManualDiscount($manualDiscount)
            ->setOrderLineNbr($orderLineNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setOrigInvLineNbr($origInvLineNbr)
            ->setOrigInvNbr($origInvNbr)
            ->setOrigInvType($origInvType)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setShipmentNbr($shipmentNbr)
            ->setSubitem($subitem)
            ->setTaxCategory($taxCategory)
            ->setTransactionDescr($transactionDescr)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branchID
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setBranchID(\App\API\SOAP\StructType\StringValue $branchID = null)
    {
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get CalculateDiscountsOnImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCalculateDiscountsOnImport()
    {
        return isset($this->CalculateDiscountsOnImport) ? $this->CalculateDiscountsOnImport : null;
    }
    /**
     * Set CalculateDiscountsOnImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setCalculateDiscountsOnImport(\App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport = null)
    {
        if (is_null($calculateDiscountsOnImport) || (is_array($calculateDiscountsOnImport) && empty($calculateDiscountsOnImport))) {
            unset($this->CalculateDiscountsOnImport);
        } else {
            $this->CalculateDiscountsOnImport = $calculateDiscountsOnImport;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $discountAmount
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setDiscountAmount(\App\API\SOAP\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $discountPercent
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setDiscountPercent(\App\API\SOAP\StructType\DecimalValue $discountPercent = null)
    {
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $expirationDate
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setExpirationDate(\App\API\SOAP\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get InventoryDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryDocType()
    {
        return isset($this->InventoryDocType) ? $this->InventoryDocType : null;
    }
    /**
     * Set InventoryDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryDocType
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setInventoryDocType(\App\API\SOAP\StructType\StringValue $inventoryDocType = null)
    {
        if (is_null($inventoryDocType) || (is_array($inventoryDocType) && empty($inventoryDocType))) {
            unset($this->InventoryDocType);
        } else {
            $this->InventoryDocType = $inventoryDocType;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryRefNbr()
    {
        return isset($this->InventoryRefNbr) ? $this->InventoryRefNbr : null;
    }
    /**
     * Set InventoryRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryRefNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setInventoryRefNbr(\App\API\SOAP\StructType\StringValue $inventoryRefNbr = null)
    {
        if (is_null($inventoryRefNbr) || (is_array($inventoryRefNbr) && empty($inventoryRefNbr))) {
            unset($this->InventoryRefNbr);
        } else {
            $this->InventoryRefNbr = $inventoryRefNbr;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $location
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setLocation(\App\API\SOAP\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $lotSerialNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setLotSerialNbr(\App\API\SOAP\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $manualDiscount
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setManualDiscount(\App\API\SOAP\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get OrderLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getOrderLineNbr()
    {
        return isset($this->OrderLineNbr) ? $this->OrderLineNbr : null;
    }
    /**
     * Set OrderLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $orderLineNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrderLineNbr(\App\API\SOAP\StructType\IntValue $orderLineNbr = null)
    {
        if (is_null($orderLineNbr) || (is_array($orderLineNbr) && empty($orderLineNbr))) {
            unset($this->OrderLineNbr);
        } else {
            $this->OrderLineNbr = $orderLineNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrderNbr(\App\API\SOAP\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrderType(\App\API\SOAP\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrigInvLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getOrigInvLineNbr()
    {
        return isset($this->OrigInvLineNbr) ? $this->OrigInvLineNbr : null;
    }
    /**
     * Set OrigInvLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $origInvLineNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrigInvLineNbr(\App\API\SOAP\StructType\IntValue $origInvLineNbr = null)
    {
        if (is_null($origInvLineNbr) || (is_array($origInvLineNbr) && empty($origInvLineNbr))) {
            unset($this->OrigInvLineNbr);
        } else {
            $this->OrigInvLineNbr = $origInvLineNbr;
        }
        return $this;
    }
    /**
     * Get OrigInvNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrigInvNbr()
    {
        return isset($this->OrigInvNbr) ? $this->OrigInvNbr : null;
    }
    /**
     * Set OrigInvNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $origInvNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrigInvNbr(\App\API\SOAP\StructType\StringValue $origInvNbr = null)
    {
        if (is_null($origInvNbr) || (is_array($origInvNbr) && empty($origInvNbr))) {
            unset($this->OrigInvNbr);
        } else {
            $this->OrigInvNbr = $origInvNbr;
        }
        return $this;
    }
    /**
     * Get OrigInvType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrigInvType()
    {
        return isset($this->OrigInvType) ? $this->OrigInvType : null;
    }
    /**
     * Set OrigInvType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $origInvType
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setOrigInvType(\App\API\SOAP\StructType\StringValue $origInvType = null)
    {
        if (is_null($origInvType) || (is_array($origInvType) && empty($origInvType))) {
            unset($this->OrigInvType);
        } else {
            $this->OrigInvType = $origInvType;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setProjectTask(\App\API\SOAP\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipmentNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setShipmentNbr(\App\API\SOAP\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subitem
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setSubitem(\App\API\SOAP\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TransactionDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTransactionDescr()
    {
        return isset($this->TransactionDescr) ? $this->TransactionDescr : null;
    }
    /**
     * Set TransactionDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $transactionDescr
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setTransactionDescr(\App\API\SOAP\StructType\StringValue $transactionDescr = null)
    {
        if (is_null($transactionDescr) || (is_array($transactionDescr) && empty($transactionDescr))) {
            unset($this->TransactionDescr);
        } else {
            $this->TransactionDescr = $transactionDescr;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitPrice
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setUnitPrice(\App\API\SOAP\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail
     */
    public function setWarehouseID(\App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
