<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceApplicationCreditMemo StructType
 * @subpackage Structs
 */
class SalesInvoiceApplicationCreditMemo extends Entity
{
    /**
     * The AmountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AmountPaid;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Balance;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Currency;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Customer;
    /**
     * The CustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DocType;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for SalesInvoiceApplicationCreditMemo
     * @uses SalesInvoiceApplicationCreditMemo::setAmountPaid()
     * @uses SalesInvoiceApplicationCreditMemo::setBalance()
     * @uses SalesInvoiceApplicationCreditMemo::setCurrency()
     * @uses SalesInvoiceApplicationCreditMemo::setCustomer()
     * @uses SalesInvoiceApplicationCreditMemo::setCustomerOrder()
     * @uses SalesInvoiceApplicationCreditMemo::setDate()
     * @uses SalesInvoiceApplicationCreditMemo::setDescription()
     * @uses SalesInvoiceApplicationCreditMemo::setDocType()
     * @uses SalesInvoiceApplicationCreditMemo::setPostPeriod()
     * @uses SalesInvoiceApplicationCreditMemo::setReferenceNbr()
     * @uses SalesInvoiceApplicationCreditMemo::setStatus()
     * @param \App\API\SOAP\StructType\DecimalValue $amountPaid
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @param \App\API\SOAP\StructType\StringValue $currency
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $docType
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amountPaid = null, \App\API\SOAP\StructType\DecimalValue $balance = null, \App\API\SOAP\StructType\StringValue $currency = null, \App\API\SOAP\StructType\StringValue $customer = null, \App\API\SOAP\StructType\StringValue $customerOrder = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $docType = null, \App\API\SOAP\StructType\StringValue $postPeriod = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\StringValue $status = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBalance($balance)
            ->setCurrency($currency)
            ->setCustomer($customer)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDocType($docType)
            ->setPostPeriod($postPeriod)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amountPaid
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setAmountPaid(\App\API\SOAP\StructType\DecimalValue $amountPaid = null)
    {
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setBalance(\App\API\SOAP\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currency
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setCurrency(\App\API\SOAP\StructType\StringValue $currency = null)
    {
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setCustomer(\App\API\SOAP\StructType\StringValue $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setCustomerOrder(\App\API\SOAP\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $docType
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setDocType(\App\API\SOAP\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setPostPeriod(\App\API\SOAP\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\SalesInvoiceApplicationCreditMemo
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
