<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoice StructType
 * @subpackage Structs
 */
class SalesInvoice extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The ApplicationsCreditMemo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public $ApplicationsCreditMemo;
    /**
     * The ApplicationsInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ApplicationsInvoice
     */
    public $ApplicationsInvoice;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Balance;
    /**
     * The BillingSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BillToSettings
     */
    public $BillingSettings;
    /**
     * The CashDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CashDiscount;
    /**
     * The Commissions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceCommissions
     */
    public $Commissions;
    /**
     * The CreditHold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CreditHold;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Currency;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The DiscountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountDetails
     */
    public $DiscountDetails;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $DueDate;
    /**
     * The FinancialDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceFinancialDetails
     */
    public $FinancialDetails;
    /**
     * The FreightDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\FreightDetails
     */
    public $FreightDetails;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceTotals
     */
    public $Totals;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The VATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VATExemptTotal;
    /**
     * The VATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VATTaxableTotal;
    /**
     * Constructor method for SalesInvoice
     * @uses SalesInvoice::setAmount()
     * @uses SalesInvoice::setApplicationsCreditMemo()
     * @uses SalesInvoice::setApplicationsInvoice()
     * @uses SalesInvoice::setBalance()
     * @uses SalesInvoice::setBillingSettings()
     * @uses SalesInvoice::setCashDiscount()
     * @uses SalesInvoice::setCommissions()
     * @uses SalesInvoice::setCreditHold()
     * @uses SalesInvoice::setCurrency()
     * @uses SalesInvoice::setCustomerID()
     * @uses SalesInvoice::setCustomerOrder()
     * @uses SalesInvoice::setDate()
     * @uses SalesInvoice::setDescription()
     * @uses SalesInvoice::setDetails()
     * @uses SalesInvoice::setDiscountDetails()
     * @uses SalesInvoice::setDueDate()
     * @uses SalesInvoice::setFinancialDetails()
     * @uses SalesInvoice::setFreightDetails()
     * @uses SalesInvoice::setHold()
     * @uses SalesInvoice::setProject()
     * @uses SalesInvoice::setReferenceNbr()
     * @uses SalesInvoice::setStatus()
     * @uses SalesInvoice::setTaxDetails()
     * @uses SalesInvoice::setTotals()
     * @uses SalesInvoice::setType()
     * @uses SalesInvoice::setVATExemptTotal()
     * @uses SalesInvoice::setVATTaxableTotal()
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo
     * @param \App\API\SOAP\StructType\ApplicationsInvoice $applicationsInvoice
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @param \App\API\SOAP\StructType\BillToSettings $billingSettings
     * @param \App\API\SOAP\StructType\DecimalValue $cashDiscount
     * @param \App\API\SOAP\StructType\SalesInvoiceCommissions $commissions
     * @param \App\API\SOAP\StructType\BooleanValue $creditHold
     * @param \App\API\SOAP\StructType\StringValue $currency
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @param \App\API\SOAP\StructType\SalesInvoiceFinancialDetails $financialDetails
     * @param \App\API\SOAP\StructType\FreightDetails $freightDetails
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @param \App\API\SOAP\StructType\SalesInvoiceTotals $totals
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\DecimalValue $vATExemptTotal
     * @param \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo = null, \App\API\SOAP\StructType\ApplicationsInvoice $applicationsInvoice = null, \App\API\SOAP\StructType\DecimalValue $balance = null, \App\API\SOAP\StructType\BillToSettings $billingSettings = null, \App\API\SOAP\StructType\DecimalValue $cashDiscount = null, \App\API\SOAP\StructType\SalesInvoiceCommissions $commissions = null, \App\API\SOAP\StructType\BooleanValue $creditHold = null, \App\API\SOAP\StructType\StringValue $currency = null, \App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\StringValue $customerOrder = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\DiscountDetails $discountDetails = null, \App\API\SOAP\StructType\DateTimeValue $dueDate = null, \App\API\SOAP\StructType\SalesInvoiceFinancialDetails $financialDetails = null, \App\API\SOAP\StructType\FreightDetails $freightDetails = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\TaxDetails $taxDetails = null, \App\API\SOAP\StructType\SalesInvoiceTotals $totals = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\DecimalValue $vATExemptTotal = null, \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal = null)
    {
        $this
            ->setAmount($amount)
            ->setApplicationsCreditMemo($applicationsCreditMemo)
            ->setApplicationsInvoice($applicationsInvoice)
            ->setBalance($balance)
            ->setBillingSettings($billingSettings)
            ->setCashDiscount($cashDiscount)
            ->setCommissions($commissions)
            ->setCreditHold($creditHold)
            ->setCurrency($currency)
            ->setCustomerID($customerID)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setDiscountDetails($discountDetails)
            ->setDueDate($dueDate)
            ->setFinancialDetails($financialDetails)
            ->setFreightDetails($freightDetails)
            ->setHold($hold)
            ->setProject($project)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTotals($totals)
            ->setType($type)
            ->setVATExemptTotal($vATExemptTotal)
            ->setVATTaxableTotal($vATTaxableTotal);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ApplicationsCreditMemo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo|null
     */
    public function getApplicationsCreditMemo()
    {
        return isset($this->ApplicationsCreditMemo) ? $this->ApplicationsCreditMemo : null;
    }
    /**
     * Set ApplicationsCreditMemo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setApplicationsCreditMemo(\App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo = null)
    {
        if (is_null($applicationsCreditMemo) || (is_array($applicationsCreditMemo) && empty($applicationsCreditMemo))) {
            unset($this->ApplicationsCreditMemo);
        } else {
            $this->ApplicationsCreditMemo = $applicationsCreditMemo;
        }
        return $this;
    }
    /**
     * Get ApplicationsInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ApplicationsInvoice|null
     */
    public function getApplicationsInvoice()
    {
        return isset($this->ApplicationsInvoice) ? $this->ApplicationsInvoice : null;
    }
    /**
     * Set ApplicationsInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ApplicationsInvoice $applicationsInvoice
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setApplicationsInvoice(\App\API\SOAP\StructType\ApplicationsInvoice $applicationsInvoice = null)
    {
        if (is_null($applicationsInvoice) || (is_array($applicationsInvoice) && empty($applicationsInvoice))) {
            unset($this->ApplicationsInvoice);
        } else {
            $this->ApplicationsInvoice = $applicationsInvoice;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setBalance(\App\API\SOAP\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get BillingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BillToSettings|null
     */
    public function getBillingSettings()
    {
        return isset($this->BillingSettings) ? $this->BillingSettings : null;
    }
    /**
     * Set BillingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BillToSettings $billingSettings
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setBillingSettings(\App\API\SOAP\StructType\BillToSettings $billingSettings = null)
    {
        if (is_null($billingSettings) || (is_array($billingSettings) && empty($billingSettings))) {
            unset($this->BillingSettings);
        } else {
            $this->BillingSettings = $billingSettings;
        }
        return $this;
    }
    /**
     * Get CashDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCashDiscount()
    {
        return isset($this->CashDiscount) ? $this->CashDiscount : null;
    }
    /**
     * Set CashDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $cashDiscount
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCashDiscount(\App\API\SOAP\StructType\DecimalValue $cashDiscount = null)
    {
        if (is_null($cashDiscount) || (is_array($cashDiscount) && empty($cashDiscount))) {
            unset($this->CashDiscount);
        } else {
            $this->CashDiscount = $cashDiscount;
        }
        return $this;
    }
    /**
     * Get Commissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceCommissions|null
     */
    public function getCommissions()
    {
        return isset($this->Commissions) ? $this->Commissions : null;
    }
    /**
     * Set Commissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\SalesInvoiceCommissions $commissions
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCommissions(\App\API\SOAP\StructType\SalesInvoiceCommissions $commissions = null)
    {
        if (is_null($commissions) || (is_array($commissions) && empty($commissions))) {
            unset($this->Commissions);
        } else {
            $this->Commissions = $commissions;
        }
        return $this;
    }
    /**
     * Get CreditHold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCreditHold()
    {
        return isset($this->CreditHold) ? $this->CreditHold : null;
    }
    /**
     * Set CreditHold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $creditHold
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCreditHold(\App\API\SOAP\StructType\BooleanValue $creditHold = null)
    {
        if (is_null($creditHold) || (is_array($creditHold) && empty($creditHold))) {
            unset($this->CreditHold);
        } else {
            $this->CreditHold = $creditHold;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currency
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCurrency(\App\API\SOAP\StructType\StringValue $currency = null)
    {
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setCustomerOrder(\App\API\SOAP\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountDetails|null
     */
    public function getDiscountDetails()
    {
        return isset($this->DiscountDetails) ? $this->DiscountDetails : null;
    }
    /**
     * Set DiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setDiscountDetails(\App\API\SOAP\StructType\DiscountDetails $discountDetails = null)
    {
        if (is_null($discountDetails) || (is_array($discountDetails) && empty($discountDetails))) {
            unset($this->DiscountDetails);
        } else {
            $this->DiscountDetails = $discountDetails;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setDueDate(\App\API\SOAP\StructType\DateTimeValue $dueDate = null)
    {
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get FinancialDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceFinancialDetails|null
     */
    public function getFinancialDetails()
    {
        return isset($this->FinancialDetails) ? $this->FinancialDetails : null;
    }
    /**
     * Set FinancialDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\SalesInvoiceFinancialDetails $financialDetails
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setFinancialDetails(\App\API\SOAP\StructType\SalesInvoiceFinancialDetails $financialDetails = null)
    {
        if (is_null($financialDetails) || (is_array($financialDetails) && empty($financialDetails))) {
            unset($this->FinancialDetails);
        } else {
            $this->FinancialDetails = $financialDetails;
        }
        return $this;
    }
    /**
     * Get FreightDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\FreightDetails|null
     */
    public function getFreightDetails()
    {
        return isset($this->FreightDetails) ? $this->FreightDetails : null;
    }
    /**
     * Set FreightDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\FreightDetails $freightDetails
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setFreightDetails(\App\API\SOAP\StructType\FreightDetails $freightDetails = null)
    {
        if (is_null($freightDetails) || (is_array($freightDetails) && empty($freightDetails))) {
            unset($this->FreightDetails);
        } else {
            $this->FreightDetails = $freightDetails;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setTaxDetails(\App\API\SOAP\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\SalesInvoiceTotals $totals
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setTotals(\App\API\SOAP\StructType\SalesInvoiceTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get VATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVATExemptTotal()
    {
        return isset($this->VATExemptTotal) ? $this->VATExemptTotal : null;
    }
    /**
     * Set VATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $vATExemptTotal
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setVATExemptTotal(\App\API\SOAP\StructType\DecimalValue $vATExemptTotal = null)
    {
        if (is_null($vATExemptTotal) || (is_array($vATExemptTotal) && empty($vATExemptTotal))) {
            unset($this->VATExemptTotal);
        } else {
            $this->VATExemptTotal = $vATExemptTotal;
        }
        return $this;
    }
    /**
     * Get VATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVATTaxableTotal()
    {
        return isset($this->VATTaxableTotal) ? $this->VATTaxableTotal : null;
    }
    /**
     * Set VATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $vATTaxableTotal
     * @return \App\API\SOAP\StructType\SalesInvoice
     */
    public function setVATTaxableTotal(\App\API\SOAP\StructType\DecimalValue $vATTaxableTotal = null)
    {
        if (is_null($vATTaxableTotal) || (is_array($vATTaxableTotal) && empty($vATTaxableTotal))) {
            unset($this->VATTaxableTotal);
        } else {
            $this->VATTaxableTotal = $vATTaxableTotal;
        }
        return $this;
    }
}
