<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesCategories StructType
 * @subpackage Structs
 */
class SalesCategories extends AbstractStructBase
{
    /**
     * The NonStockItemSalesCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\NonStockItemSalesCategory[]
     */
    public $NonStockItemSalesCategory;
    /**
     * Constructor method for SalesCategories
     * @uses SalesCategories::setNonStockItemSalesCategory()
     * @param \App\API\SOAP\StructType\NonStockItemSalesCategory[] $nonStockItemSalesCategory
     */
    public function __construct(array $nonStockItemSalesCategory = array())
    {
        $this
            ->setNonStockItemSalesCategory($nonStockItemSalesCategory);
    }
    /**
     * Get NonStockItemSalesCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\NonStockItemSalesCategory[]|null
     */
    public function getNonStockItemSalesCategory()
    {
        return isset($this->NonStockItemSalesCategory) ? $this->NonStockItemSalesCategory : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNonStockItemSalesCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonStockItemSalesCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonStockItemSalesCategoryForArrayConstraintsFromSetNonStockItemSalesCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesCategoriesNonStockItemSalesCategoryItem) {
            // validation for constraint: itemType
            if (!$salesCategoriesNonStockItemSalesCategoryItem instanceof \App\API\SOAP\StructType\NonStockItemSalesCategory) {
                $invalidValues[] = is_object($salesCategoriesNonStockItemSalesCategoryItem) ? get_class($salesCategoriesNonStockItemSalesCategoryItem) : sprintf('%s(%s)', gettype($salesCategoriesNonStockItemSalesCategoryItem), var_export($salesCategoriesNonStockItemSalesCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NonStockItemSalesCategory property can only contain items of type \App\API\SOAP\StructType\NonStockItemSalesCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NonStockItemSalesCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemSalesCategory[] $nonStockItemSalesCategory
     * @return \App\API\SOAP\StructType\SalesCategories
     */
    public function setNonStockItemSalesCategory(array $nonStockItemSalesCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($nonStockItemSalesCategoryArrayErrorMessage = self::validateNonStockItemSalesCategoryForArrayConstraintsFromSetNonStockItemSalesCategory($nonStockItemSalesCategory))) {
            throw new \InvalidArgumentException($nonStockItemSalesCategoryArrayErrorMessage, __LINE__);
        }
        if (is_null($nonStockItemSalesCategory) || (is_array($nonStockItemSalesCategory) && empty($nonStockItemSalesCategory))) {
            unset($this->NonStockItemSalesCategory);
        } else {
            $this->NonStockItemSalesCategory = $nonStockItemSalesCategory;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemSalesCategory value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemSalesCategory $item
     * @return \App\API\SOAP\StructType\SalesCategories
     */
    public function addToNonStockItemSalesCategory(\App\API\SOAP\StructType\NonStockItemSalesCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\NonStockItemSalesCategory) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemSalesCategory property can only contain items of type \App\API\SOAP\StructType\NonStockItemSalesCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NonStockItemSalesCategory[] = $item;
        return $this;
    }
}
