<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevenueBudget StructType
 * @subpackage Structs
 */
class RevenueBudget extends AbstractStructBase
{
    /**
     * The ChangeOrderRevenueBudget
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ChangeOrderRevenueBudget[]
     */
    public $ChangeOrderRevenueBudget;
    /**
     * Constructor method for RevenueBudget
     * @uses RevenueBudget::setChangeOrderRevenueBudget()
     * @param \App\API\SOAP\StructType\ChangeOrderRevenueBudget[] $changeOrderRevenueBudget
     */
    public function __construct(array $changeOrderRevenueBudget = array())
    {
        $this
            ->setChangeOrderRevenueBudget($changeOrderRevenueBudget);
    }
    /**
     * Get ChangeOrderRevenueBudget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ChangeOrderRevenueBudget[]|null
     */
    public function getChangeOrderRevenueBudget()
    {
        return isset($this->ChangeOrderRevenueBudget) ? $this->ChangeOrderRevenueBudget : null;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeOrderRevenueBudget method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeOrderRevenueBudget method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeOrderRevenueBudgetForArrayConstraintsFromSetChangeOrderRevenueBudget(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenueBudgetChangeOrderRevenueBudgetItem) {
            // validation for constraint: itemType
            if (!$revenueBudgetChangeOrderRevenueBudgetItem instanceof \App\API\SOAP\StructType\ChangeOrderRevenueBudget) {
                $invalidValues[] = is_object($revenueBudgetChangeOrderRevenueBudgetItem) ? get_class($revenueBudgetChangeOrderRevenueBudgetItem) : sprintf('%s(%s)', gettype($revenueBudgetChangeOrderRevenueBudgetItem), var_export($revenueBudgetChangeOrderRevenueBudgetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeOrderRevenueBudget property can only contain items of type \App\API\SOAP\StructType\ChangeOrderRevenueBudget, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeOrderRevenueBudget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ChangeOrderRevenueBudget[] $changeOrderRevenueBudget
     * @return \App\API\SOAP\StructType\RevenueBudget
     */
    public function setChangeOrderRevenueBudget(array $changeOrderRevenueBudget = array())
    {
        // validation for constraint: array
        if ('' !== ($changeOrderRevenueBudgetArrayErrorMessage = self::validateChangeOrderRevenueBudgetForArrayConstraintsFromSetChangeOrderRevenueBudget($changeOrderRevenueBudget))) {
            throw new \InvalidArgumentException($changeOrderRevenueBudgetArrayErrorMessage, __LINE__);
        }
        if (is_null($changeOrderRevenueBudget) || (is_array($changeOrderRevenueBudget) && empty($changeOrderRevenueBudget))) {
            unset($this->ChangeOrderRevenueBudget);
        } else {
            $this->ChangeOrderRevenueBudget = $changeOrderRevenueBudget;
        }
        return $this;
    }
    /**
     * Add item to ChangeOrderRevenueBudget value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ChangeOrderRevenueBudget $item
     * @return \App\API\SOAP\StructType\RevenueBudget
     */
    public function addToChangeOrderRevenueBudget(\App\API\SOAP\StructType\ChangeOrderRevenueBudget $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ChangeOrderRevenueBudget) {
            throw new \InvalidArgumentException(sprintf('The ChangeOrderRevenueBudget property can only contain items of type \App\API\SOAP\StructType\ChangeOrderRevenueBudget, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeOrderRevenueBudget[] = $item;
        return $this;
    }
}
