<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends AbstractStructBase
{
    /**
     * The AccountByPeriodRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AccountByPeriodRow[]
     */
    public $AccountByPeriodRow;
    /**
     * The AccountDetailsRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AccountDetailsRow[]
     */
    public $AccountDetailsRow;
    /**
     * The AccountSummaryRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AccountSummaryRow[]
     */
    public $AccountSummaryRow;
    /**
     * The InventoryAllocationRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InventoryAllocationRow[]
     */
    public $InventoryAllocationRow;
    /**
     * The InventorySummaryRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InventorySummaryRow[]
     */
    public $InventorySummaryRow;
    /**
     * The AccountBySubaccountRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AccountBySubaccountRow[]
     */
    public $AccountBySubaccountRow;
    /**
     * Constructor method for Results
     * @uses Results::setAccountByPeriodRow()
     * @uses Results::setAccountDetailsRow()
     * @uses Results::setAccountSummaryRow()
     * @uses Results::setInventoryAllocationRow()
     * @uses Results::setInventorySummaryRow()
     * @uses Results::setAccountBySubaccountRow()
     * @param \App\API\SOAP\StructType\AccountByPeriodRow[] $accountByPeriodRow
     * @param \App\API\SOAP\StructType\AccountDetailsRow[] $accountDetailsRow
     * @param \App\API\SOAP\StructType\AccountSummaryRow[] $accountSummaryRow
     * @param \App\API\SOAP\StructType\InventoryAllocationRow[] $inventoryAllocationRow
     * @param \App\API\SOAP\StructType\InventorySummaryRow[] $inventorySummaryRow
     * @param \App\API\SOAP\StructType\AccountBySubaccountRow[] $accountBySubaccountRow
     */
    public function __construct(array $accountByPeriodRow = array(), array $accountDetailsRow = array(), array $accountSummaryRow = array(), array $inventoryAllocationRow = array(), array $inventorySummaryRow = array(), array $accountBySubaccountRow = array())
    {
        $this
            ->setAccountByPeriodRow($accountByPeriodRow)
            ->setAccountDetailsRow($accountDetailsRow)
            ->setAccountSummaryRow($accountSummaryRow)
            ->setInventoryAllocationRow($inventoryAllocationRow)
            ->setInventorySummaryRow($inventorySummaryRow)
            ->setAccountBySubaccountRow($accountBySubaccountRow);
    }
    /**
     * Get AccountByPeriodRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AccountByPeriodRow[]|null
     */
    public function getAccountByPeriodRow()
    {
        return isset($this->AccountByPeriodRow) ? $this->AccountByPeriodRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountByPeriodRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountByPeriodRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountByPeriodRowForArrayConstraintsFromSetAccountByPeriodRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsAccountByPeriodRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountByPeriodRowItem instanceof \App\API\SOAP\StructType\AccountByPeriodRow) {
                $invalidValues[] = is_object($resultsAccountByPeriodRowItem) ? get_class($resultsAccountByPeriodRowItem) : sprintf('%s(%s)', gettype($resultsAccountByPeriodRowItem), var_export($resultsAccountByPeriodRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountByPeriodRow property can only contain items of type \App\API\SOAP\StructType\AccountByPeriodRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountByPeriodRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountByPeriodRow[] $accountByPeriodRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setAccountByPeriodRow(array $accountByPeriodRow = array())
    {
        // validation for constraint: array
        if ('' !== ($accountByPeriodRowArrayErrorMessage = self::validateAccountByPeriodRowForArrayConstraintsFromSetAccountByPeriodRow($accountByPeriodRow))) {
            throw new \InvalidArgumentException($accountByPeriodRowArrayErrorMessage, __LINE__);
        }
        if (is_null($accountByPeriodRow) || (is_array($accountByPeriodRow) && empty($accountByPeriodRow))) {
            unset($this->AccountByPeriodRow);
        } else {
            $this->AccountByPeriodRow = $accountByPeriodRow;
        }
        return $this;
    }
    /**
     * Add item to AccountByPeriodRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountByPeriodRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToAccountByPeriodRow(\App\API\SOAP\StructType\AccountByPeriodRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AccountByPeriodRow) {
            throw new \InvalidArgumentException(sprintf('The AccountByPeriodRow property can only contain items of type \App\API\SOAP\StructType\AccountByPeriodRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountByPeriodRow[] = $item;
        return $this;
    }
    /**
     * Get AccountDetailsRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AccountDetailsRow[]|null
     */
    public function getAccountDetailsRow()
    {
        return isset($this->AccountDetailsRow) ? $this->AccountDetailsRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountDetailsRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountDetailsRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountDetailsRowForArrayConstraintsFromSetAccountDetailsRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsAccountDetailsRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountDetailsRowItem instanceof \App\API\SOAP\StructType\AccountDetailsRow) {
                $invalidValues[] = is_object($resultsAccountDetailsRowItem) ? get_class($resultsAccountDetailsRowItem) : sprintf('%s(%s)', gettype($resultsAccountDetailsRowItem), var_export($resultsAccountDetailsRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountDetailsRow property can only contain items of type \App\API\SOAP\StructType\AccountDetailsRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountDetailsRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountDetailsRow[] $accountDetailsRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setAccountDetailsRow(array $accountDetailsRow = array())
    {
        // validation for constraint: array
        if ('' !== ($accountDetailsRowArrayErrorMessage = self::validateAccountDetailsRowForArrayConstraintsFromSetAccountDetailsRow($accountDetailsRow))) {
            throw new \InvalidArgumentException($accountDetailsRowArrayErrorMessage, __LINE__);
        }
        if (is_null($accountDetailsRow) || (is_array($accountDetailsRow) && empty($accountDetailsRow))) {
            unset($this->AccountDetailsRow);
        } else {
            $this->AccountDetailsRow = $accountDetailsRow;
        }
        return $this;
    }
    /**
     * Add item to AccountDetailsRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountDetailsRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToAccountDetailsRow(\App\API\SOAP\StructType\AccountDetailsRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AccountDetailsRow) {
            throw new \InvalidArgumentException(sprintf('The AccountDetailsRow property can only contain items of type \App\API\SOAP\StructType\AccountDetailsRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountDetailsRow[] = $item;
        return $this;
    }
    /**
     * Get AccountSummaryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AccountSummaryRow[]|null
     */
    public function getAccountSummaryRow()
    {
        return isset($this->AccountSummaryRow) ? $this->AccountSummaryRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountSummaryRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountSummaryRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountSummaryRowForArrayConstraintsFromSetAccountSummaryRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsAccountSummaryRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountSummaryRowItem instanceof \App\API\SOAP\StructType\AccountSummaryRow) {
                $invalidValues[] = is_object($resultsAccountSummaryRowItem) ? get_class($resultsAccountSummaryRowItem) : sprintf('%s(%s)', gettype($resultsAccountSummaryRowItem), var_export($resultsAccountSummaryRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountSummaryRow property can only contain items of type \App\API\SOAP\StructType\AccountSummaryRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountSummaryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountSummaryRow[] $accountSummaryRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setAccountSummaryRow(array $accountSummaryRow = array())
    {
        // validation for constraint: array
        if ('' !== ($accountSummaryRowArrayErrorMessage = self::validateAccountSummaryRowForArrayConstraintsFromSetAccountSummaryRow($accountSummaryRow))) {
            throw new \InvalidArgumentException($accountSummaryRowArrayErrorMessage, __LINE__);
        }
        if (is_null($accountSummaryRow) || (is_array($accountSummaryRow) && empty($accountSummaryRow))) {
            unset($this->AccountSummaryRow);
        } else {
            $this->AccountSummaryRow = $accountSummaryRow;
        }
        return $this;
    }
    /**
     * Add item to AccountSummaryRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountSummaryRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToAccountSummaryRow(\App\API\SOAP\StructType\AccountSummaryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AccountSummaryRow) {
            throw new \InvalidArgumentException(sprintf('The AccountSummaryRow property can only contain items of type \App\API\SOAP\StructType\AccountSummaryRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountSummaryRow[] = $item;
        return $this;
    }
    /**
     * Get InventoryAllocationRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InventoryAllocationRow[]|null
     */
    public function getInventoryAllocationRow()
    {
        return isset($this->InventoryAllocationRow) ? $this->InventoryAllocationRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryAllocationRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryAllocationRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryAllocationRowForArrayConstraintsFromSetInventoryAllocationRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsInventoryAllocationRowItem) {
            // validation for constraint: itemType
            if (!$resultsInventoryAllocationRowItem instanceof \App\API\SOAP\StructType\InventoryAllocationRow) {
                $invalidValues[] = is_object($resultsInventoryAllocationRowItem) ? get_class($resultsInventoryAllocationRowItem) : sprintf('%s(%s)', gettype($resultsInventoryAllocationRowItem), var_export($resultsInventoryAllocationRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryAllocationRow property can only contain items of type \App\API\SOAP\StructType\InventoryAllocationRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryAllocationRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryAllocationRow[] $inventoryAllocationRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setInventoryAllocationRow(array $inventoryAllocationRow = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryAllocationRowArrayErrorMessage = self::validateInventoryAllocationRowForArrayConstraintsFromSetInventoryAllocationRow($inventoryAllocationRow))) {
            throw new \InvalidArgumentException($inventoryAllocationRowArrayErrorMessage, __LINE__);
        }
        if (is_null($inventoryAllocationRow) || (is_array($inventoryAllocationRow) && empty($inventoryAllocationRow))) {
            unset($this->InventoryAllocationRow);
        } else {
            $this->InventoryAllocationRow = $inventoryAllocationRow;
        }
        return $this;
    }
    /**
     * Add item to InventoryAllocationRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryAllocationRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToInventoryAllocationRow(\App\API\SOAP\StructType\InventoryAllocationRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InventoryAllocationRow) {
            throw new \InvalidArgumentException(sprintf('The InventoryAllocationRow property can only contain items of type \App\API\SOAP\StructType\InventoryAllocationRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryAllocationRow[] = $item;
        return $this;
    }
    /**
     * Get InventorySummaryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InventorySummaryRow[]|null
     */
    public function getInventorySummaryRow()
    {
        return isset($this->InventorySummaryRow) ? $this->InventorySummaryRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventorySummaryRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventorySummaryRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventorySummaryRowForArrayConstraintsFromSetInventorySummaryRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsInventorySummaryRowItem) {
            // validation for constraint: itemType
            if (!$resultsInventorySummaryRowItem instanceof \App\API\SOAP\StructType\InventorySummaryRow) {
                $invalidValues[] = is_object($resultsInventorySummaryRowItem) ? get_class($resultsInventorySummaryRowItem) : sprintf('%s(%s)', gettype($resultsInventorySummaryRowItem), var_export($resultsInventorySummaryRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventorySummaryRow property can only contain items of type \App\API\SOAP\StructType\InventorySummaryRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventorySummaryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventorySummaryRow[] $inventorySummaryRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setInventorySummaryRow(array $inventorySummaryRow = array())
    {
        // validation for constraint: array
        if ('' !== ($inventorySummaryRowArrayErrorMessage = self::validateInventorySummaryRowForArrayConstraintsFromSetInventorySummaryRow($inventorySummaryRow))) {
            throw new \InvalidArgumentException($inventorySummaryRowArrayErrorMessage, __LINE__);
        }
        if (is_null($inventorySummaryRow) || (is_array($inventorySummaryRow) && empty($inventorySummaryRow))) {
            unset($this->InventorySummaryRow);
        } else {
            $this->InventorySummaryRow = $inventorySummaryRow;
        }
        return $this;
    }
    /**
     * Add item to InventorySummaryRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventorySummaryRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToInventorySummaryRow(\App\API\SOAP\StructType\InventorySummaryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InventorySummaryRow) {
            throw new \InvalidArgumentException(sprintf('The InventorySummaryRow property can only contain items of type \App\API\SOAP\StructType\InventorySummaryRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventorySummaryRow[] = $item;
        return $this;
    }
    /**
     * Get AccountBySubaccountRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AccountBySubaccountRow[]|null
     */
    public function getAccountBySubaccountRow()
    {
        return isset($this->AccountBySubaccountRow) ? $this->AccountBySubaccountRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountBySubaccountRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountBySubaccountRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountBySubaccountRowForArrayConstraintsFromSetAccountBySubaccountRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultsAccountBySubaccountRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountBySubaccountRowItem instanceof \App\API\SOAP\StructType\AccountBySubaccountRow) {
                $invalidValues[] = is_object($resultsAccountBySubaccountRowItem) ? get_class($resultsAccountBySubaccountRowItem) : sprintf('%s(%s)', gettype($resultsAccountBySubaccountRowItem), var_export($resultsAccountBySubaccountRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountBySubaccountRow property can only contain items of type \App\API\SOAP\StructType\AccountBySubaccountRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountBySubaccountRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountBySubaccountRow[] $accountBySubaccountRow
     * @return \App\API\SOAP\StructType\Results
     */
    public function setAccountBySubaccountRow(array $accountBySubaccountRow = array())
    {
        // validation for constraint: array
        if ('' !== ($accountBySubaccountRowArrayErrorMessage = self::validateAccountBySubaccountRowForArrayConstraintsFromSetAccountBySubaccountRow($accountBySubaccountRow))) {
            throw new \InvalidArgumentException($accountBySubaccountRowArrayErrorMessage, __LINE__);
        }
        if (is_null($accountBySubaccountRow) || (is_array($accountBySubaccountRow) && empty($accountBySubaccountRow))) {
            unset($this->AccountBySubaccountRow);
        } else {
            $this->AccountBySubaccountRow = $accountBySubaccountRow;
        }
        return $this;
    }
    /**
     * Add item to AccountBySubaccountRow value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AccountBySubaccountRow $item
     * @return \App\API\SOAP\StructType\Results
     */
    public function addToAccountBySubaccountRow(\App\API\SOAP\StructType\AccountBySubaccountRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AccountBySubaccountRow) {
            throw new \InvalidArgumentException(sprintf('The AccountBySubaccountRow property can only contain items of type \App\API\SOAP\StructType\AccountBySubaccountRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountBySubaccountRow[] = $item;
        return $this;
    }
}
