<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplenishmentParameterStockItem StructType
 * @subpackage Structs
 */
class ReplenishmentParameterStockItem extends Entity
{
    /**
     * The DemandForecastModel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DemandForecastModel;
    /**
     * The ForecastPeriodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ForecastPeriodType;
    /**
     * The LaunchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LaunchDate;
    /**
     * The MaxQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MaxQty;
    /**
     * The MaxShelfLifeInDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $MaxShelfLifeInDays;
    /**
     * The Method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Method;
    /**
     * The PeriodsToAnalyze
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $PeriodsToAnalyze;
    /**
     * The ReorderPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ReorderPoint;
    /**
     * The ReplenishmentClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentClass;
    /**
     * The ReplenishmentWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentWarehouse;
    /**
     * The SafetyStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SafetyStock;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Seasonality;
    /**
     * The ServiceLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ServiceLevel;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Source;
    /**
     * The TerminationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $TerminationDate;
    /**
     * The TransferERQ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TransferERQ;
    /**
     * Constructor method for ReplenishmentParameterStockItem
     * @uses ReplenishmentParameterStockItem::setDemandForecastModel()
     * @uses ReplenishmentParameterStockItem::setForecastPeriodType()
     * @uses ReplenishmentParameterStockItem::setLaunchDate()
     * @uses ReplenishmentParameterStockItem::setMaxQty()
     * @uses ReplenishmentParameterStockItem::setMaxShelfLifeInDays()
     * @uses ReplenishmentParameterStockItem::setMethod()
     * @uses ReplenishmentParameterStockItem::setPeriodsToAnalyze()
     * @uses ReplenishmentParameterStockItem::setReorderPoint()
     * @uses ReplenishmentParameterStockItem::setReplenishmentClass()
     * @uses ReplenishmentParameterStockItem::setReplenishmentWarehouse()
     * @uses ReplenishmentParameterStockItem::setSafetyStock()
     * @uses ReplenishmentParameterStockItem::setSeasonality()
     * @uses ReplenishmentParameterStockItem::setServiceLevel()
     * @uses ReplenishmentParameterStockItem::setSource()
     * @uses ReplenishmentParameterStockItem::setTerminationDate()
     * @uses ReplenishmentParameterStockItem::setTransferERQ()
     * @param \App\API\SOAP\StructType\StringValue $demandForecastModel
     * @param \App\API\SOAP\StructType\StringValue $forecastPeriodType
     * @param \App\API\SOAP\StructType\DateTimeValue $launchDate
     * @param \App\API\SOAP\StructType\DecimalValue $maxQty
     * @param \App\API\SOAP\StructType\IntValue $maxShelfLifeInDays
     * @param \App\API\SOAP\StructType\StringValue $method
     * @param \App\API\SOAP\StructType\IntValue $periodsToAnalyze
     * @param \App\API\SOAP\StructType\DecimalValue $reorderPoint
     * @param \App\API\SOAP\StructType\StringValue $replenishmentClass
     * @param \App\API\SOAP\StructType\StringValue $replenishmentWarehouse
     * @param \App\API\SOAP\StructType\DecimalValue $safetyStock
     * @param \App\API\SOAP\StructType\StringValue $seasonality
     * @param \App\API\SOAP\StructType\DecimalValue $serviceLevel
     * @param \App\API\SOAP\StructType\StringValue $source
     * @param \App\API\SOAP\StructType\DateTimeValue $terminationDate
     * @param \App\API\SOAP\StructType\DecimalValue $transferERQ
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $demandForecastModel = null, \App\API\SOAP\StructType\StringValue $forecastPeriodType = null, \App\API\SOAP\StructType\DateTimeValue $launchDate = null, \App\API\SOAP\StructType\DecimalValue $maxQty = null, \App\API\SOAP\StructType\IntValue $maxShelfLifeInDays = null, \App\API\SOAP\StructType\StringValue $method = null, \App\API\SOAP\StructType\IntValue $periodsToAnalyze = null, \App\API\SOAP\StructType\DecimalValue $reorderPoint = null, \App\API\SOAP\StructType\StringValue $replenishmentClass = null, \App\API\SOAP\StructType\StringValue $replenishmentWarehouse = null, \App\API\SOAP\StructType\DecimalValue $safetyStock = null, \App\API\SOAP\StructType\StringValue $seasonality = null, \App\API\SOAP\StructType\DecimalValue $serviceLevel = null, \App\API\SOAP\StructType\StringValue $source = null, \App\API\SOAP\StructType\DateTimeValue $terminationDate = null, \App\API\SOAP\StructType\DecimalValue $transferERQ = null)
    {
        $this
            ->setDemandForecastModel($demandForecastModel)
            ->setForecastPeriodType($forecastPeriodType)
            ->setLaunchDate($launchDate)
            ->setMaxQty($maxQty)
            ->setMaxShelfLifeInDays($maxShelfLifeInDays)
            ->setMethod($method)
            ->setPeriodsToAnalyze($periodsToAnalyze)
            ->setReorderPoint($reorderPoint)
            ->setReplenishmentClass($replenishmentClass)
            ->setReplenishmentWarehouse($replenishmentWarehouse)
            ->setSafetyStock($safetyStock)
            ->setSeasonality($seasonality)
            ->setServiceLevel($serviceLevel)
            ->setSource($source)
            ->setTerminationDate($terminationDate)
            ->setTransferERQ($transferERQ);
    }
    /**
     * Get DemandForecastModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDemandForecastModel()
    {
        return isset($this->DemandForecastModel) ? $this->DemandForecastModel : null;
    }
    /**
     * Set DemandForecastModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $demandForecastModel
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setDemandForecastModel(\App\API\SOAP\StructType\StringValue $demandForecastModel = null)
    {
        if (is_null($demandForecastModel) || (is_array($demandForecastModel) && empty($demandForecastModel))) {
            unset($this->DemandForecastModel);
        } else {
            $this->DemandForecastModel = $demandForecastModel;
        }
        return $this;
    }
    /**
     * Get ForecastPeriodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getForecastPeriodType()
    {
        return isset($this->ForecastPeriodType) ? $this->ForecastPeriodType : null;
    }
    /**
     * Set ForecastPeriodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $forecastPeriodType
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setForecastPeriodType(\App\API\SOAP\StructType\StringValue $forecastPeriodType = null)
    {
        if (is_null($forecastPeriodType) || (is_array($forecastPeriodType) && empty($forecastPeriodType))) {
            unset($this->ForecastPeriodType);
        } else {
            $this->ForecastPeriodType = $forecastPeriodType;
        }
        return $this;
    }
    /**
     * Get LaunchDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLaunchDate()
    {
        return isset($this->LaunchDate) ? $this->LaunchDate : null;
    }
    /**
     * Set LaunchDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $launchDate
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setLaunchDate(\App\API\SOAP\StructType\DateTimeValue $launchDate = null)
    {
        if (is_null($launchDate) || (is_array($launchDate) && empty($launchDate))) {
            unset($this->LaunchDate);
        } else {
            $this->LaunchDate = $launchDate;
        }
        return $this;
    }
    /**
     * Get MaxQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMaxQty()
    {
        return isset($this->MaxQty) ? $this->MaxQty : null;
    }
    /**
     * Set MaxQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $maxQty
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setMaxQty(\App\API\SOAP\StructType\DecimalValue $maxQty = null)
    {
        if (is_null($maxQty) || (is_array($maxQty) && empty($maxQty))) {
            unset($this->MaxQty);
        } else {
            $this->MaxQty = $maxQty;
        }
        return $this;
    }
    /**
     * Get MaxShelfLifeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getMaxShelfLifeInDays()
    {
        return isset($this->MaxShelfLifeInDays) ? $this->MaxShelfLifeInDays : null;
    }
    /**
     * Set MaxShelfLifeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $maxShelfLifeInDays
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setMaxShelfLifeInDays(\App\API\SOAP\StructType\IntValue $maxShelfLifeInDays = null)
    {
        if (is_null($maxShelfLifeInDays) || (is_array($maxShelfLifeInDays) && empty($maxShelfLifeInDays))) {
            unset($this->MaxShelfLifeInDays);
        } else {
            $this->MaxShelfLifeInDays = $maxShelfLifeInDays;
        }
        return $this;
    }
    /**
     * Get Method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getMethod()
    {
        return isset($this->Method) ? $this->Method : null;
    }
    /**
     * Set Method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $method
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setMethod(\App\API\SOAP\StructType\StringValue $method = null)
    {
        if (is_null($method) || (is_array($method) && empty($method))) {
            unset($this->Method);
        } else {
            $this->Method = $method;
        }
        return $this;
    }
    /**
     * Get PeriodsToAnalyze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getPeriodsToAnalyze()
    {
        return isset($this->PeriodsToAnalyze) ? $this->PeriodsToAnalyze : null;
    }
    /**
     * Set PeriodsToAnalyze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $periodsToAnalyze
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setPeriodsToAnalyze(\App\API\SOAP\StructType\IntValue $periodsToAnalyze = null)
    {
        if (is_null($periodsToAnalyze) || (is_array($periodsToAnalyze) && empty($periodsToAnalyze))) {
            unset($this->PeriodsToAnalyze);
        } else {
            $this->PeriodsToAnalyze = $periodsToAnalyze;
        }
        return $this;
    }
    /**
     * Get ReorderPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getReorderPoint()
    {
        return isset($this->ReorderPoint) ? $this->ReorderPoint : null;
    }
    /**
     * Set ReorderPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $reorderPoint
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setReorderPoint(\App\API\SOAP\StructType\DecimalValue $reorderPoint = null)
    {
        if (is_null($reorderPoint) || (is_array($reorderPoint) && empty($reorderPoint))) {
            unset($this->ReorderPoint);
        } else {
            $this->ReorderPoint = $reorderPoint;
        }
        return $this;
    }
    /**
     * Get ReplenishmentClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentClass()
    {
        return isset($this->ReplenishmentClass) ? $this->ReplenishmentClass : null;
    }
    /**
     * Set ReplenishmentClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentClass
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setReplenishmentClass(\App\API\SOAP\StructType\StringValue $replenishmentClass = null)
    {
        if (is_null($replenishmentClass) || (is_array($replenishmentClass) && empty($replenishmentClass))) {
            unset($this->ReplenishmentClass);
        } else {
            $this->ReplenishmentClass = $replenishmentClass;
        }
        return $this;
    }
    /**
     * Get ReplenishmentWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentWarehouse()
    {
        return isset($this->ReplenishmentWarehouse) ? $this->ReplenishmentWarehouse : null;
    }
    /**
     * Set ReplenishmentWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentWarehouse
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setReplenishmentWarehouse(\App\API\SOAP\StructType\StringValue $replenishmentWarehouse = null)
    {
        if (is_null($replenishmentWarehouse) || (is_array($replenishmentWarehouse) && empty($replenishmentWarehouse))) {
            unset($this->ReplenishmentWarehouse);
        } else {
            $this->ReplenishmentWarehouse = $replenishmentWarehouse;
        }
        return $this;
    }
    /**
     * Get SafetyStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSafetyStock()
    {
        return isset($this->SafetyStock) ? $this->SafetyStock : null;
    }
    /**
     * Set SafetyStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $safetyStock
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setSafetyStock(\App\API\SOAP\StructType\DecimalValue $safetyStock = null)
    {
        if (is_null($safetyStock) || (is_array($safetyStock) && empty($safetyStock))) {
            unset($this->SafetyStock);
        } else {
            $this->SafetyStock = $safetyStock;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $seasonality
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setSeasonality(\App\API\SOAP\StructType\StringValue $seasonality = null)
    {
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get ServiceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getServiceLevel()
    {
        return isset($this->ServiceLevel) ? $this->ServiceLevel : null;
    }
    /**
     * Set ServiceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $serviceLevel
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setServiceLevel(\App\API\SOAP\StructType\DecimalValue $serviceLevel = null)
    {
        if (is_null($serviceLevel) || (is_array($serviceLevel) && empty($serviceLevel))) {
            unset($this->ServiceLevel);
        } else {
            $this->ServiceLevel = $serviceLevel;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $source
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setSource(\App\API\SOAP\StructType\StringValue $source = null)
    {
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get TerminationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getTerminationDate()
    {
        return isset($this->TerminationDate) ? $this->TerminationDate : null;
    }
    /**
     * Set TerminationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $terminationDate
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setTerminationDate(\App\API\SOAP\StructType\DateTimeValue $terminationDate = null)
    {
        if (is_null($terminationDate) || (is_array($terminationDate) && empty($terminationDate))) {
            unset($this->TerminationDate);
        } else {
            $this->TerminationDate = $terminationDate;
        }
        return $this;
    }
    /**
     * Get TransferERQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTransferERQ()
    {
        return isset($this->TransferERQ) ? $this->TransferERQ : null;
    }
    /**
     * Set TransferERQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $transferERQ
     * @return \App\API\SOAP\StructType\ReplenishmentParameterStockItem
     */
    public function setTransferERQ(\App\API\SOAP\StructType\DecimalValue $transferERQ = null)
    {
        if (is_null($transferERQ) || (is_array($transferERQ) && empty($transferERQ))) {
            unset($this->TransferERQ);
        } else {
            $this->TransferERQ = $transferERQ;
        }
        return $this;
    }
}
