<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedTasks StructType
 * @subpackage Structs
 */
class RelatedTasks extends AbstractStructBase
{
    /**
     * The TaskRelatedTask
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaskRelatedTask[]
     */
    public $TaskRelatedTask;
    /**
     * Constructor method for RelatedTasks
     * @uses RelatedTasks::setTaskRelatedTask()
     * @param \App\API\SOAP\StructType\TaskRelatedTask[] $taskRelatedTask
     */
    public function __construct(array $taskRelatedTask = array())
    {
        $this
            ->setTaskRelatedTask($taskRelatedTask);
    }
    /**
     * Get TaskRelatedTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaskRelatedTask[]|null
     */
    public function getTaskRelatedTask()
    {
        return isset($this->TaskRelatedTask) ? $this->TaskRelatedTask : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskRelatedTask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskRelatedTask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskRelatedTaskForArrayConstraintsFromSetTaskRelatedTask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedTasksTaskRelatedTaskItem) {
            // validation for constraint: itemType
            if (!$relatedTasksTaskRelatedTaskItem instanceof \App\API\SOAP\StructType\TaskRelatedTask) {
                $invalidValues[] = is_object($relatedTasksTaskRelatedTaskItem) ? get_class($relatedTasksTaskRelatedTaskItem) : sprintf('%s(%s)', gettype($relatedTasksTaskRelatedTaskItem), var_export($relatedTasksTaskRelatedTaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaskRelatedTask property can only contain items of type \App\API\SOAP\StructType\TaskRelatedTask, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaskRelatedTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TaskRelatedTask[] $taskRelatedTask
     * @return \App\API\SOAP\StructType\RelatedTasks
     */
    public function setTaskRelatedTask(array $taskRelatedTask = array())
    {
        // validation for constraint: array
        if ('' !== ($taskRelatedTaskArrayErrorMessage = self::validateTaskRelatedTaskForArrayConstraintsFromSetTaskRelatedTask($taskRelatedTask))) {
            throw new \InvalidArgumentException($taskRelatedTaskArrayErrorMessage, __LINE__);
        }
        if (is_null($taskRelatedTask) || (is_array($taskRelatedTask) && empty($taskRelatedTask))) {
            unset($this->TaskRelatedTask);
        } else {
            $this->TaskRelatedTask = $taskRelatedTask;
        }
        return $this;
    }
    /**
     * Add item to TaskRelatedTask value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TaskRelatedTask $item
     * @return \App\API\SOAP\StructType\RelatedTasks
     */
    public function addToTaskRelatedTask(\App\API\SOAP\StructType\TaskRelatedTask $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TaskRelatedTask) {
            throw new \InvalidArgumentException(sprintf('The TaskRelatedTask property can only contain items of type \App\API\SOAP\StructType\TaskRelatedTask, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaskRelatedTask[] = $item;
        return $this;
    }
}
