<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseSettings StructType
 * @subpackage Structs
 */
class PurchaseSettings extends Entity
{
    /**
     * The POSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POSiteID;
    /**
     * The POSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POSource;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VendorID;
    /**
     * Constructor method for PurchaseSettings
     * @uses PurchaseSettings::setPOSiteID()
     * @uses PurchaseSettings::setPOSource()
     * @uses PurchaseSettings::setVendorID()
     * @param \App\API\SOAP\StructType\StringValue $pOSiteID
     * @param \App\API\SOAP\StructType\StringValue $pOSource
     * @param \App\API\SOAP\StructType\StringValue $vendorID
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $pOSiteID = null, \App\API\SOAP\StructType\StringValue $pOSource = null, \App\API\SOAP\StructType\StringValue $vendorID = null)
    {
        $this
            ->setPOSiteID($pOSiteID)
            ->setPOSource($pOSource)
            ->setVendorID($vendorID);
    }
    /**
     * Get POSiteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOSiteID()
    {
        return isset($this->POSiteID) ? $this->POSiteID : null;
    }
    /**
     * Set POSiteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOSiteID
     * @return \App\API\SOAP\StructType\PurchaseSettings
     */
    public function setPOSiteID(\App\API\SOAP\StructType\StringValue $pOSiteID = null)
    {
        if (is_null($pOSiteID) || (is_array($pOSiteID) && empty($pOSiteID))) {
            unset($this->POSiteID);
        } else {
            $this->POSiteID = $pOSiteID;
        }
        return $this;
    }
    /**
     * Get POSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOSource()
    {
        return isset($this->POSource) ? $this->POSource : null;
    }
    /**
     * Set POSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOSource
     * @return \App\API\SOAP\StructType\PurchaseSettings
     */
    public function setPOSource(\App\API\SOAP\StructType\StringValue $pOSource = null)
    {
        if (is_null($pOSource) || (is_array($pOSource) && empty($pOSource))) {
            unset($this->POSource);
        } else {
            $this->POSource = $pOSource;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendorID
     * @return \App\API\SOAP\StructType\PurchaseSettings
     */
    public function setVendorID(\App\API\SOAP\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
}
