<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseReceipt StructType
 * @subpackage Structs
 */
class PurchaseReceipt extends Entity
{
    /**
     * The BillDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $BillDate;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The ControlAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ControlAmount;
    /**
     * The ControlQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ControlQty;
    /**
     * The CreateBill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CreateBill;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The ReceiptNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReceiptNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TotalAmount;
    /**
     * The TotalQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TotalQty;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The UnbilledQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnbilledQuantity;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VendorID;
    /**
     * The VendorRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VendorRef;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for PurchaseReceipt
     * @uses PurchaseReceipt::setBillDate()
     * @uses PurchaseReceipt::setBranch()
     * @uses PurchaseReceipt::setControlAmount()
     * @uses PurchaseReceipt::setControlQty()
     * @uses PurchaseReceipt::setCreateBill()
     * @uses PurchaseReceipt::setCurrencyID()
     * @uses PurchaseReceipt::setDate()
     * @uses PurchaseReceipt::setDetails()
     * @uses PurchaseReceipt::setHold()
     * @uses PurchaseReceipt::setPostPeriod()
     * @uses PurchaseReceipt::setReceiptNbr()
     * @uses PurchaseReceipt::setStatus()
     * @uses PurchaseReceipt::setTotalAmount()
     * @uses PurchaseReceipt::setTotalQty()
     * @uses PurchaseReceipt::setType()
     * @uses PurchaseReceipt::setUnbilledQuantity()
     * @uses PurchaseReceipt::setVendorID()
     * @uses PurchaseReceipt::setVendorRef()
     * @uses PurchaseReceipt::setWarehouse()
     * @param \App\API\SOAP\StructType\DateTimeValue $billDate
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\DecimalValue $controlAmount
     * @param \App\API\SOAP\StructType\DecimalValue $controlQty
     * @param \App\API\SOAP\StructType\BooleanValue $createBill
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @param \App\API\SOAP\StructType\StringValue $receiptNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\DecimalValue $totalAmount
     * @param \App\API\SOAP\StructType\DecimalValue $totalQty
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\DecimalValue $unbilledQuantity
     * @param \App\API\SOAP\StructType\StringValue $vendorID
     * @param \App\API\SOAP\StructType\StringValue $vendorRef
     * @param \App\API\SOAP\StructType\StringValue $warehouse
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $billDate = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\DecimalValue $controlAmount = null, \App\API\SOAP\StructType\DecimalValue $controlQty = null, \App\API\SOAP\StructType\BooleanValue $createBill = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\StringValue $postPeriod = null, \App\API\SOAP\StructType\StringValue $receiptNbr = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\DecimalValue $totalAmount = null, \App\API\SOAP\StructType\DecimalValue $totalQty = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\DecimalValue $unbilledQuantity = null, \App\API\SOAP\StructType\StringValue $vendorID = null, \App\API\SOAP\StructType\StringValue $vendorRef = null, \App\API\SOAP\StructType\StringValue $warehouse = null)
    {
        $this
            ->setBillDate($billDate)
            ->setBranch($branch)
            ->setControlAmount($controlAmount)
            ->setControlQty($controlQty)
            ->setCreateBill($createBill)
            ->setCurrencyID($currencyID)
            ->setDate($date)
            ->setDetails($details)
            ->setHold($hold)
            ->setPostPeriod($postPeriod)
            ->setReceiptNbr($receiptNbr)
            ->setStatus($status)
            ->setTotalAmount($totalAmount)
            ->setTotalQty($totalQty)
            ->setType($type)
            ->setUnbilledQuantity($unbilledQuantity)
            ->setVendorID($vendorID)
            ->setVendorRef($vendorRef)
            ->setWarehouse($warehouse);
    }
    /**
     * Get BillDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getBillDate()
    {
        return isset($this->BillDate) ? $this->BillDate : null;
    }
    /**
     * Set BillDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $billDate
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setBillDate(\App\API\SOAP\StructType\DateTimeValue $billDate = null)
    {
        if (is_null($billDate) || (is_array($billDate) && empty($billDate))) {
            unset($this->BillDate);
        } else {
            $this->BillDate = $billDate;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ControlAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getControlAmount()
    {
        return isset($this->ControlAmount) ? $this->ControlAmount : null;
    }
    /**
     * Set ControlAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $controlAmount
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setControlAmount(\App\API\SOAP\StructType\DecimalValue $controlAmount = null)
    {
        if (is_null($controlAmount) || (is_array($controlAmount) && empty($controlAmount))) {
            unset($this->ControlAmount);
        } else {
            $this->ControlAmount = $controlAmount;
        }
        return $this;
    }
    /**
     * Get ControlQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getControlQty()
    {
        return isset($this->ControlQty) ? $this->ControlQty : null;
    }
    /**
     * Set ControlQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $controlQty
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setControlQty(\App\API\SOAP\StructType\DecimalValue $controlQty = null)
    {
        if (is_null($controlQty) || (is_array($controlQty) && empty($controlQty))) {
            unset($this->ControlQty);
        } else {
            $this->ControlQty = $controlQty;
        }
        return $this;
    }
    /**
     * Get CreateBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCreateBill()
    {
        return isset($this->CreateBill) ? $this->CreateBill : null;
    }
    /**
     * Set CreateBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $createBill
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setCreateBill(\App\API\SOAP\StructType\BooleanValue $createBill = null)
    {
        if (is_null($createBill) || (is_array($createBill) && empty($createBill))) {
            unset($this->CreateBill);
        } else {
            $this->CreateBill = $createBill;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setPostPeriod(\App\API\SOAP\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get ReceiptNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReceiptNbr()
    {
        return isset($this->ReceiptNbr) ? $this->ReceiptNbr : null;
    }
    /**
     * Set ReceiptNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $receiptNbr
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setReceiptNbr(\App\API\SOAP\StructType\StringValue $receiptNbr = null)
    {
        if (is_null($receiptNbr) || (is_array($receiptNbr) && empty($receiptNbr))) {
            unset($this->ReceiptNbr);
        } else {
            $this->ReceiptNbr = $receiptNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $totalAmount
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setTotalAmount(\App\API\SOAP\StructType\DecimalValue $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotalQty()
    {
        return isset($this->TotalQty) ? $this->TotalQty : null;
    }
    /**
     * Set TotalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $totalQty
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setTotalQty(\App\API\SOAP\StructType\DecimalValue $totalQty = null)
    {
        if (is_null($totalQty) || (is_array($totalQty) && empty($totalQty))) {
            unset($this->TotalQty);
        } else {
            $this->TotalQty = $totalQty;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnbilledQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnbilledQuantity()
    {
        return isset($this->UnbilledQuantity) ? $this->UnbilledQuantity : null;
    }
    /**
     * Set UnbilledQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unbilledQuantity
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setUnbilledQuantity(\App\API\SOAP\StructType\DecimalValue $unbilledQuantity = null)
    {
        if (is_null($unbilledQuantity) || (is_array($unbilledQuantity) && empty($unbilledQuantity))) {
            unset($this->UnbilledQuantity);
        } else {
            $this->UnbilledQuantity = $unbilledQuantity;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendorID
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setVendorID(\App\API\SOAP\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
    /**
     * Get VendorRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendorRef()
    {
        return isset($this->VendorRef) ? $this->VendorRef : null;
    }
    /**
     * Set VendorRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendorRef
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setVendorRef(\App\API\SOAP\StructType\StringValue $vendorRef = null)
    {
        if (is_null($vendorRef) || (is_array($vendorRef) && empty($vendorRef))) {
            unset($this->VendorRef);
        } else {
            $this->VendorRef = $vendorRef;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouse
     * @return \App\API\SOAP\StructType\PurchaseReceipt
     */
    public function setWarehouse(\App\API\SOAP\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
