<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectUnionLocal StructType
 * @subpackage Structs
 */
class ProjectUnionLocal extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The UnionLocalID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UnionLocalID;
    /**
     * Constructor method for ProjectUnionLocal
     * @uses ProjectUnionLocal::setDescription()
     * @uses ProjectUnionLocal::setUnionLocalID()
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $unionLocalID
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $unionLocalID = null)
    {
        $this
            ->setDescription($description)
            ->setUnionLocalID($unionLocalID);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectUnionLocal
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get UnionLocalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUnionLocalID()
    {
        return isset($this->UnionLocalID) ? $this->UnionLocalID : null;
    }
    /**
     * Set UnionLocalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $unionLocalID
     * @return \App\API\SOAP\StructType\ProjectUnionLocal
     */
    public function setUnionLocalID(\App\API\SOAP\StructType\StringValue $unionLocalID = null)
    {
        if (is_null($unionLocalID) || (is_array($unionLocalID) && empty($unionLocalID))) {
            unset($this->UnionLocalID);
        } else {
            $this->UnionLocalID = $unionLocalID;
        }
        return $this;
    }
}
