<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTransactionDetail StructType
 * @subpackage Structs
 */
class ProjectTransactionDetail extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The AccountGroupDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountGroupDescription;
    /**
     * The Allocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BillableQty;
    /**
     * The Billed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Billed;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The CreditAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CreditAccount;
    /**
     * The CreditSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CreditSubaccount;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DebitAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DebitAccount;
    /**
     * The DebitSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DebitSubaccount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EarningType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EarningType;
    /**
     * The Employee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Employee;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $EndDate;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The FinPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FinPeriod;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Location;
    /**
     * The Multiplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Multiplier;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Released
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Released;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\LongValue
     */
    public $TransactionID;
    /**
     * The UnitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitRate;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * The UseBillableQtyInAmountFormula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $UseBillableQtyInAmountFormula;
    /**
     * The VendorOrCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for ProjectTransactionDetail
     * @uses ProjectTransactionDetail::setAccountGroup()
     * @uses ProjectTransactionDetail::setAccountGroupDescription()
     * @uses ProjectTransactionDetail::setAllocated()
     * @uses ProjectTransactionDetail::setAmount()
     * @uses ProjectTransactionDetail::setBatchNbr()
     * @uses ProjectTransactionDetail::setBillable()
     * @uses ProjectTransactionDetail::setBillableQty()
     * @uses ProjectTransactionDetail::setBilled()
     * @uses ProjectTransactionDetail::setBranch()
     * @uses ProjectTransactionDetail::setCostCode()
     * @uses ProjectTransactionDetail::setCreditAccount()
     * @uses ProjectTransactionDetail::setCreditSubaccount()
     * @uses ProjectTransactionDetail::setDate()
     * @uses ProjectTransactionDetail::setDebitAccount()
     * @uses ProjectTransactionDetail::setDebitSubaccount()
     * @uses ProjectTransactionDetail::setDescription()
     * @uses ProjectTransactionDetail::setEarningType()
     * @uses ProjectTransactionDetail::setEmployee()
     * @uses ProjectTransactionDetail::setEndDate()
     * @uses ProjectTransactionDetail::setExternalRefNbr()
     * @uses ProjectTransactionDetail::setFinPeriod()
     * @uses ProjectTransactionDetail::setInventoryID()
     * @uses ProjectTransactionDetail::setLocation()
     * @uses ProjectTransactionDetail::setMultiplier()
     * @uses ProjectTransactionDetail::setProject()
     * @uses ProjectTransactionDetail::setProjectTask()
     * @uses ProjectTransactionDetail::setQty()
     * @uses ProjectTransactionDetail::setReleased()
     * @uses ProjectTransactionDetail::setStartDate()
     * @uses ProjectTransactionDetail::setTransactionID()
     * @uses ProjectTransactionDetail::setUnitRate()
     * @uses ProjectTransactionDetail::setUOM()
     * @uses ProjectTransactionDetail::setUseBillableQtyInAmountFormula()
     * @uses ProjectTransactionDetail::setVendorOrCustomer()
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @param \App\API\SOAP\StructType\StringValue $accountGroupDescription
     * @param \App\API\SOAP\StructType\BooleanValue $allocated
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\StringValue $batchNbr
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @param \App\API\SOAP\StructType\DecimalValue $billableQty
     * @param \App\API\SOAP\StructType\BooleanValue $billed
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\StringValue $creditAccount
     * @param \App\API\SOAP\StructType\StringValue $creditSubaccount
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $debitAccount
     * @param \App\API\SOAP\StructType\StringValue $debitSubaccount
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $earningType
     * @param \App\API\SOAP\StructType\StringValue $employee
     * @param \App\API\SOAP\StructType\DateTimeValue $endDate
     * @param \App\API\SOAP\StructType\StringValue $externalRefNbr
     * @param \App\API\SOAP\StructType\StringValue $finPeriod
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $location
     * @param \App\API\SOAP\StructType\DecimalValue $multiplier
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\BooleanValue $released
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @param \App\API\SOAP\StructType\LongValue $transactionID
     * @param \App\API\SOAP\StructType\DecimalValue $unitRate
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @param \App\API\SOAP\StructType\BooleanValue $useBillableQtyInAmountFormula
     * @param \App\API\SOAP\StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountGroup = null, \App\API\SOAP\StructType\StringValue $accountGroupDescription = null, \App\API\SOAP\StructType\BooleanValue $allocated = null, \App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\StringValue $batchNbr = null, \App\API\SOAP\StructType\BooleanValue $billable = null, \App\API\SOAP\StructType\DecimalValue $billableQty = null, \App\API\SOAP\StructType\BooleanValue $billed = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\StringValue $creditAccount = null, \App\API\SOAP\StructType\StringValue $creditSubaccount = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $debitAccount = null, \App\API\SOAP\StructType\StringValue $debitSubaccount = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $earningType = null, \App\API\SOAP\StructType\StringValue $employee = null, \App\API\SOAP\StructType\DateTimeValue $endDate = null, \App\API\SOAP\StructType\StringValue $externalRefNbr = null, \App\API\SOAP\StructType\StringValue $finPeriod = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $location = null, \App\API\SOAP\StructType\DecimalValue $multiplier = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $projectTask = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\BooleanValue $released = null, \App\API\SOAP\StructType\DateTimeValue $startDate = null, \App\API\SOAP\StructType\LongValue $transactionID = null, \App\API\SOAP\StructType\DecimalValue $unitRate = null, \App\API\SOAP\StructType\StringValue $uOM = null, \App\API\SOAP\StructType\BooleanValue $useBillableQtyInAmountFormula = null, \App\API\SOAP\StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setAccountGroupDescription($accountGroupDescription)
            ->setAllocated($allocated)
            ->setAmount($amount)
            ->setBatchNbr($batchNbr)
            ->setBillable($billable)
            ->setBillableQty($billableQty)
            ->setBilled($billed)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setCreditAccount($creditAccount)
            ->setCreditSubaccount($creditSubaccount)
            ->setDate($date)
            ->setDebitAccount($debitAccount)
            ->setDebitSubaccount($debitSubaccount)
            ->setDescription($description)
            ->setEarningType($earningType)
            ->setEmployee($employee)
            ->setEndDate($endDate)
            ->setExternalRefNbr($externalRefNbr)
            ->setFinPeriod($finPeriod)
            ->setInventoryID($inventoryID)
            ->setLocation($location)
            ->setMultiplier($multiplier)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setReleased($released)
            ->setStartDate($startDate)
            ->setTransactionID($transactionID)
            ->setUnitRate($unitRate)
            ->setUOM($uOM)
            ->setUseBillableQtyInAmountFormula($useBillableQtyInAmountFormula)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setAccountGroup(\App\API\SOAP\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get AccountGroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountGroupDescription()
    {
        return isset($this->AccountGroupDescription) ? $this->AccountGroupDescription : null;
    }
    /**
     * Set AccountGroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountGroupDescription
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setAccountGroupDescription(\App\API\SOAP\StructType\StringValue $accountGroupDescription = null)
    {
        if (is_null($accountGroupDescription) || (is_array($accountGroupDescription) && empty($accountGroupDescription))) {
            unset($this->AccountGroupDescription);
        } else {
            $this->AccountGroupDescription = $accountGroupDescription;
        }
        return $this;
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $allocated
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setAllocated(\App\API\SOAP\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $batchNbr
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setBatchNbr(\App\API\SOAP\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setBillable(\App\API\SOAP\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBillableQty()
    {
        return isset($this->BillableQty) ? $this->BillableQty : null;
    }
    /**
     * Set BillableQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $billableQty
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setBillableQty(\App\API\SOAP\StructType\DecimalValue $billableQty = null)
    {
        if (is_null($billableQty) || (is_array($billableQty) && empty($billableQty))) {
            unset($this->BillableQty);
        } else {
            $this->BillableQty = $billableQty;
        }
        return $this;
    }
    /**
     * Get Billed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBilled()
    {
        return isset($this->Billed) ? $this->Billed : null;
    }
    /**
     * Set Billed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billed
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setBilled(\App\API\SOAP\StructType\BooleanValue $billed = null)
    {
        if (is_null($billed) || (is_array($billed) && empty($billed))) {
            unset($this->Billed);
        } else {
            $this->Billed = $billed;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CreditAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCreditAccount()
    {
        return isset($this->CreditAccount) ? $this->CreditAccount : null;
    }
    /**
     * Set CreditAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $creditAccount
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setCreditAccount(\App\API\SOAP\StructType\StringValue $creditAccount = null)
    {
        if (is_null($creditAccount) || (is_array($creditAccount) && empty($creditAccount))) {
            unset($this->CreditAccount);
        } else {
            $this->CreditAccount = $creditAccount;
        }
        return $this;
    }
    /**
     * Get CreditSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCreditSubaccount()
    {
        return isset($this->CreditSubaccount) ? $this->CreditSubaccount : null;
    }
    /**
     * Set CreditSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $creditSubaccount
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setCreditSubaccount(\App\API\SOAP\StructType\StringValue $creditSubaccount = null)
    {
        if (is_null($creditSubaccount) || (is_array($creditSubaccount) && empty($creditSubaccount))) {
            unset($this->CreditSubaccount);
        } else {
            $this->CreditSubaccount = $creditSubaccount;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DebitAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDebitAccount()
    {
        return isset($this->DebitAccount) ? $this->DebitAccount : null;
    }
    /**
     * Set DebitAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $debitAccount
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setDebitAccount(\App\API\SOAP\StructType\StringValue $debitAccount = null)
    {
        if (is_null($debitAccount) || (is_array($debitAccount) && empty($debitAccount))) {
            unset($this->DebitAccount);
        } else {
            $this->DebitAccount = $debitAccount;
        }
        return $this;
    }
    /**
     * Get DebitSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDebitSubaccount()
    {
        return isset($this->DebitSubaccount) ? $this->DebitSubaccount : null;
    }
    /**
     * Set DebitSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $debitSubaccount
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setDebitSubaccount(\App\API\SOAP\StructType\StringValue $debitSubaccount = null)
    {
        if (is_null($debitSubaccount) || (is_array($debitSubaccount) && empty($debitSubaccount))) {
            unset($this->DebitSubaccount);
        } else {
            $this->DebitSubaccount = $debitSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EarningType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEarningType()
    {
        return isset($this->EarningType) ? $this->EarningType : null;
    }
    /**
     * Set EarningType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $earningType
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setEarningType(\App\API\SOAP\StructType\StringValue $earningType = null)
    {
        if (is_null($earningType) || (is_array($earningType) && empty($earningType))) {
            unset($this->EarningType);
        } else {
            $this->EarningType = $earningType;
        }
        return $this;
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employee
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setEmployee(\App\API\SOAP\StructType\StringValue $employee = null)
    {
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $endDate
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setEndDate(\App\API\SOAP\StructType\DateTimeValue $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $externalRefNbr
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setExternalRefNbr(\App\API\SOAP\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get FinPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFinPeriod()
    {
        return isset($this->FinPeriod) ? $this->FinPeriod : null;
    }
    /**
     * Set FinPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $finPeriod
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setFinPeriod(\App\API\SOAP\StructType\StringValue $finPeriod = null)
    {
        if (is_null($finPeriod) || (is_array($finPeriod) && empty($finPeriod))) {
            unset($this->FinPeriod);
        } else {
            $this->FinPeriod = $finPeriod;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $location
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setLocation(\App\API\SOAP\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Multiplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMultiplier()
    {
        return isset($this->Multiplier) ? $this->Multiplier : null;
    }
    /**
     * Set Multiplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $multiplier
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setMultiplier(\App\API\SOAP\StructType\DecimalValue $multiplier = null)
    {
        if (is_null($multiplier) || (is_array($multiplier) && empty($multiplier))) {
            unset($this->Multiplier);
        } else {
            $this->Multiplier = $multiplier;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setProjectTask(\App\API\SOAP\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Released value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getReleased()
    {
        return isset($this->Released) ? $this->Released : null;
    }
    /**
     * Set Released value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $released
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setReleased(\App\API\SOAP\StructType\BooleanValue $released = null)
    {
        if (is_null($released) || (is_array($released) && empty($released))) {
            unset($this->Released);
        } else {
            $this->Released = $released;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setStartDate(\App\API\SOAP\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\LongValue|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\LongValue $transactionID
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setTransactionID(\App\API\SOAP\StructType\LongValue $transactionID = null)
    {
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Get UnitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitRate()
    {
        return isset($this->UnitRate) ? $this->UnitRate : null;
    }
    /**
     * Set UnitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitRate
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setUnitRate(\App\API\SOAP\StructType\DecimalValue $unitRate = null)
    {
        if (is_null($unitRate) || (is_array($unitRate) && empty($unitRate))) {
            unset($this->UnitRate);
        } else {
            $this->UnitRate = $unitRate;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get UseBillableQtyInAmountFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getUseBillableQtyInAmountFormula()
    {
        return isset($this->UseBillableQtyInAmountFormula) ? $this->UseBillableQtyInAmountFormula : null;
    }
    /**
     * Set UseBillableQtyInAmountFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $useBillableQtyInAmountFormula
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setUseBillableQtyInAmountFormula(\App\API\SOAP\StructType\BooleanValue $useBillableQtyInAmountFormula = null)
    {
        if (is_null($useBillableQtyInAmountFormula) || (is_array($useBillableQtyInAmountFormula) && empty($useBillableQtyInAmountFormula))) {
            unset($this->UseBillableQtyInAmountFormula);
        } else {
            $this->UseBillableQtyInAmountFormula = $useBillableQtyInAmountFormula;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendorOrCustomer
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail
     */
    public function setVendorOrCustomer(\App\API\SOAP\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
}
