<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectGLAccount StructType
 * @subpackage Structs
 */
class ProjectGLAccount extends Entity
{
    /**
     * The AccrualAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccrualAccount;
    /**
     * The AccrualSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccrualSubaccount;
    /**
     * The DefaultAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultAccount;
    /**
     * The DefaultSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultSubaccount;
    /**
     * The DefaultTaskForGLAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DefaultTaskForGLAccounts
     */
    public $DefaultTaskForGLAccounts;
    /**
     * Constructor method for ProjectGLAccount
     * @uses ProjectGLAccount::setAccrualAccount()
     * @uses ProjectGLAccount::setAccrualSubaccount()
     * @uses ProjectGLAccount::setDefaultAccount()
     * @uses ProjectGLAccount::setDefaultSubaccount()
     * @uses ProjectGLAccount::setDefaultTaskForGLAccounts()
     * @param \App\API\SOAP\StructType\StringValue $accrualAccount
     * @param \App\API\SOAP\StructType\StringValue $accrualSubaccount
     * @param \App\API\SOAP\StructType\StringValue $defaultAccount
     * @param \App\API\SOAP\StructType\StringValue $defaultSubaccount
     * @param \App\API\SOAP\StructType\DefaultTaskForGLAccounts $defaultTaskForGLAccounts
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accrualAccount = null, \App\API\SOAP\StructType\StringValue $accrualSubaccount = null, \App\API\SOAP\StructType\StringValue $defaultAccount = null, \App\API\SOAP\StructType\StringValue $defaultSubaccount = null, \App\API\SOAP\StructType\DefaultTaskForGLAccounts $defaultTaskForGLAccounts = null)
    {
        $this
            ->setAccrualAccount($accrualAccount)
            ->setAccrualSubaccount($accrualSubaccount)
            ->setDefaultAccount($defaultAccount)
            ->setDefaultSubaccount($defaultSubaccount)
            ->setDefaultTaskForGLAccounts($defaultTaskForGLAccounts);
    }
    /**
     * Get AccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccrualAccount()
    {
        return isset($this->AccrualAccount) ? $this->AccrualAccount : null;
    }
    /**
     * Set AccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accrualAccount
     * @return \App\API\SOAP\StructType\ProjectGLAccount
     */
    public function setAccrualAccount(\App\API\SOAP\StructType\StringValue $accrualAccount = null)
    {
        if (is_null($accrualAccount) || (is_array($accrualAccount) && empty($accrualAccount))) {
            unset($this->AccrualAccount);
        } else {
            $this->AccrualAccount = $accrualAccount;
        }
        return $this;
    }
    /**
     * Get AccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccrualSubaccount()
    {
        return isset($this->AccrualSubaccount) ? $this->AccrualSubaccount : null;
    }
    /**
     * Set AccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accrualSubaccount
     * @return \App\API\SOAP\StructType\ProjectGLAccount
     */
    public function setAccrualSubaccount(\App\API\SOAP\StructType\StringValue $accrualSubaccount = null)
    {
        if (is_null($accrualSubaccount) || (is_array($accrualSubaccount) && empty($accrualSubaccount))) {
            unset($this->AccrualSubaccount);
        } else {
            $this->AccrualSubaccount = $accrualSubaccount;
        }
        return $this;
    }
    /**
     * Get DefaultAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultAccount()
    {
        return isset($this->DefaultAccount) ? $this->DefaultAccount : null;
    }
    /**
     * Set DefaultAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultAccount
     * @return \App\API\SOAP\StructType\ProjectGLAccount
     */
    public function setDefaultAccount(\App\API\SOAP\StructType\StringValue $defaultAccount = null)
    {
        if (is_null($defaultAccount) || (is_array($defaultAccount) && empty($defaultAccount))) {
            unset($this->DefaultAccount);
        } else {
            $this->DefaultAccount = $defaultAccount;
        }
        return $this;
    }
    /**
     * Get DefaultSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultSubaccount()
    {
        return isset($this->DefaultSubaccount) ? $this->DefaultSubaccount : null;
    }
    /**
     * Set DefaultSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultSubaccount
     * @return \App\API\SOAP\StructType\ProjectGLAccount
     */
    public function setDefaultSubaccount(\App\API\SOAP\StructType\StringValue $defaultSubaccount = null)
    {
        if (is_null($defaultSubaccount) || (is_array($defaultSubaccount) && empty($defaultSubaccount))) {
            unset($this->DefaultSubaccount);
        } else {
            $this->DefaultSubaccount = $defaultSubaccount;
        }
        return $this;
    }
    /**
     * Get DefaultTaskForGLAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DefaultTaskForGLAccounts|null
     */
    public function getDefaultTaskForGLAccounts()
    {
        return isset($this->DefaultTaskForGLAccounts) ? $this->DefaultTaskForGLAccounts : null;
    }
    /**
     * Set DefaultTaskForGLAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DefaultTaskForGLAccounts $defaultTaskForGLAccounts
     * @return \App\API\SOAP\StructType\ProjectGLAccount
     */
    public function setDefaultTaskForGLAccounts(\App\API\SOAP\StructType\DefaultTaskForGLAccounts $defaultTaskForGLAccounts = null)
    {
        if (is_null($defaultTaskForGLAccounts) || (is_array($defaultTaskForGLAccounts) && empty($defaultTaskForGLAccounts))) {
            unset($this->DefaultTaskForGLAccounts);
        } else {
            $this->DefaultTaskForGLAccounts = $defaultTaskForGLAccounts;
        }
        return $this;
    }
}
