<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectEmployee StructType
 * @subpackage Structs
 */
class ProjectEmployee extends Entity
{
    /**
     * The Department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Department;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The EmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EmployeeName;
    /**
     * Constructor method for ProjectEmployee
     * @uses ProjectEmployee::setDepartment()
     * @uses ProjectEmployee::setEmployeeID()
     * @uses ProjectEmployee::setEmployeeName()
     * @param \App\API\SOAP\StructType\StringValue $department
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @param \App\API\SOAP\StructType\StringValue $employeeName
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $department = null, \App\API\SOAP\StructType\StringValue $employeeID = null, \App\API\SOAP\StructType\StringValue $employeeName = null)
    {
        $this
            ->setDepartment($department)
            ->setEmployeeID($employeeID)
            ->setEmployeeName($employeeName);
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $department
     * @return \App\API\SOAP\StructType\ProjectEmployee
     */
    public function setDepartment(\App\API\SOAP\StructType\StringValue $department = null)
    {
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @return \App\API\SOAP\StructType\ProjectEmployee
     */
    public function setEmployeeID(\App\API\SOAP\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get EmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployeeName()
    {
        return isset($this->EmployeeName) ? $this->EmployeeName : null;
    }
    /**
     * Set EmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employeeName
     * @return \App\API\SOAP\StructType\ProjectEmployee
     */
    public function setEmployeeName(\App\API\SOAP\StructType\StringValue $employeeName = null)
    {
        if (is_null($employeeName) || (is_array($employeeName) && empty($employeeName))) {
            unset($this->EmployeeName);
        } else {
            $this->EmployeeName = $employeeName;
        }
        return $this;
    }
}
