<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBudget StructType
 * @subpackage Structs
 */
class ProjectBudget extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The ActualPlusOpenCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualPlusOpenCommittedAmount;
    /**
     * The ActualQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualQty;
    /**
     * The AutoCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $AutoCompleted;
    /**
     * The BudgetedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BudgetedCOAmount;
    /**
     * The BudgetedCOQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BudgetedCOQty;
    /**
     * The CommittedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedCOAmount;
    /**
     * The CommittedCOQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedCOQty;
    /**
     * The CommittedInvoicedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedInvoicedAmount;
    /**
     * The CommittedInvoicedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedInvoicedQty;
    /**
     * The CommittedOpenAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedOpenAmount;
    /**
     * The CommittedOpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedOpenQty;
    /**
     * The CommittedReceivedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedReceivedQty;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Completed;
    /**
     * The CostAtCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CostAtCompletion;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The CostToComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CostToComplete;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DraftInvoicesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DraftInvoicesAmount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LastCostAtCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $LastCostAtCompletion;
    /**
     * The LastCostToComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $LastCostToComplete;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LastPercentageOfCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $LastPercentageOfCompletion;
    /**
     * The OriginalBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalBudgetedAmount;
    /**
     * The OriginalBudgetedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalBudgetedQty;
    /**
     * The OriginalCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalCommittedAmount;
    /**
     * The OriginalCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalCommittedQty;
    /**
     * The PendingInvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PendingInvoiceAmount;
    /**
     * The PercentageOfCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PercentageOfCompletion;
    /**
     * The Performance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Performance;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RevenueTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $RevenueTask;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The RevisedBudgetedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedBudgetedQty;
    /**
     * The RevisedCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedCommittedAmount;
    /**
     * The RevisedCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedCommittedQty;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The UnitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitRate;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * The VarianceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VarianceAmount;
    /**
     * Constructor method for ProjectBudget
     * @uses ProjectBudget::setAccountGroup()
     * @uses ProjectBudget::setActualAmount()
     * @uses ProjectBudget::setActualPlusOpenCommittedAmount()
     * @uses ProjectBudget::setActualQty()
     * @uses ProjectBudget::setAutoCompleted()
     * @uses ProjectBudget::setBudgetedCOAmount()
     * @uses ProjectBudget::setBudgetedCOQty()
     * @uses ProjectBudget::setCommittedCOAmount()
     * @uses ProjectBudget::setCommittedCOQty()
     * @uses ProjectBudget::setCommittedInvoicedAmount()
     * @uses ProjectBudget::setCommittedInvoicedQty()
     * @uses ProjectBudget::setCommittedOpenAmount()
     * @uses ProjectBudget::setCommittedOpenQty()
     * @uses ProjectBudget::setCommittedReceivedQty()
     * @uses ProjectBudget::setCompleted()
     * @uses ProjectBudget::setCostAtCompletion()
     * @uses ProjectBudget::setCostCode()
     * @uses ProjectBudget::setCostToComplete()
     * @uses ProjectBudget::setDescription()
     * @uses ProjectBudget::setDraftInvoicesAmount()
     * @uses ProjectBudget::setInventoryID()
     * @uses ProjectBudget::setLastCostAtCompletion()
     * @uses ProjectBudget::setLastCostToComplete()
     * @uses ProjectBudget::setLastModifiedDateTime()
     * @uses ProjectBudget::setLastPercentageOfCompletion()
     * @uses ProjectBudget::setOriginalBudgetedAmount()
     * @uses ProjectBudget::setOriginalBudgetedQty()
     * @uses ProjectBudget::setOriginalCommittedAmount()
     * @uses ProjectBudget::setOriginalCommittedQty()
     * @uses ProjectBudget::setPendingInvoiceAmount()
     * @uses ProjectBudget::setPercentageOfCompletion()
     * @uses ProjectBudget::setPerformance()
     * @uses ProjectBudget::setProjectID()
     * @uses ProjectBudget::setProjectTaskID()
     * @uses ProjectBudget::setRetainage()
     * @uses ProjectBudget::setRevenueTask()
     * @uses ProjectBudget::setRevisedBudgetedAmount()
     * @uses ProjectBudget::setRevisedBudgetedQty()
     * @uses ProjectBudget::setRevisedCommittedAmount()
     * @uses ProjectBudget::setRevisedCommittedQty()
     * @uses ProjectBudget::setTaxCategory()
     * @uses ProjectBudget::setType()
     * @uses ProjectBudget::setUnitRate()
     * @uses ProjectBudget::setUOM()
     * @uses ProjectBudget::setVarianceAmount()
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @param \App\API\SOAP\StructType\DecimalValue $actualPlusOpenCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $actualQty
     * @param \App\API\SOAP\StructType\BooleanValue $autoCompleted
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOQty
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOQty
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedQty
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenQty
     * @param \App\API\SOAP\StructType\DecimalValue $committedReceivedQty
     * @param \App\API\SOAP\StructType\DecimalValue $completed
     * @param \App\API\SOAP\StructType\DecimalValue $costAtCompletion
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\DecimalValue $costToComplete
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\DecimalValue $lastCostAtCompletion
     * @param \App\API\SOAP\StructType\DecimalValue $lastCostToComplete
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\DecimalValue $lastPercentageOfCompletion
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedQty
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedQty
     * @param \App\API\SOAP\StructType\DecimalValue $pendingInvoiceAmount
     * @param \App\API\SOAP\StructType\DecimalValue $percentageOfCompletion
     * @param \App\API\SOAP\StructType\DecimalValue $performance
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @param \App\API\SOAP\StructType\IntValue $revenueTask
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedQty
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedQty
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\DecimalValue $unitRate
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @param \App\API\SOAP\StructType\DecimalValue $varianceAmount
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountGroup = null, \App\API\SOAP\StructType\DecimalValue $actualAmount = null, \App\API\SOAP\StructType\DecimalValue $actualPlusOpenCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $actualQty = null, \App\API\SOAP\StructType\BooleanValue $autoCompleted = null, \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount = null, \App\API\SOAP\StructType\DecimalValue $budgetedCOQty = null, \App\API\SOAP\StructType\DecimalValue $committedCOAmount = null, \App\API\SOAP\StructType\DecimalValue $committedCOQty = null, \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount = null, \App\API\SOAP\StructType\DecimalValue $committedInvoicedQty = null, \App\API\SOAP\StructType\DecimalValue $committedOpenAmount = null, \App\API\SOAP\StructType\DecimalValue $committedOpenQty = null, \App\API\SOAP\StructType\DecimalValue $committedReceivedQty = null, \App\API\SOAP\StructType\DecimalValue $completed = null, \App\API\SOAP\StructType\DecimalValue $costAtCompletion = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\DecimalValue $costToComplete = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\DecimalValue $lastCostAtCompletion = null, \App\API\SOAP\StructType\DecimalValue $lastCostToComplete = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\DecimalValue $lastPercentageOfCompletion = null, \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount = null, \App\API\SOAP\StructType\DecimalValue $originalBudgetedQty = null, \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $originalCommittedQty = null, \App\API\SOAP\StructType\DecimalValue $pendingInvoiceAmount = null, \App\API\SOAP\StructType\DecimalValue $percentageOfCompletion = null, \App\API\SOAP\StructType\DecimalValue $performance = null, \App\API\SOAP\StructType\StringValue $projectID = null, \App\API\SOAP\StructType\StringValue $projectTaskID = null, \App\API\SOAP\StructType\DecimalValue $retainage = null, \App\API\SOAP\StructType\IntValue $revenueTask = null, \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null, \App\API\SOAP\StructType\DecimalValue $revisedBudgetedQty = null, \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $revisedCommittedQty = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\DecimalValue $unitRate = null, \App\API\SOAP\StructType\StringValue $uOM = null, \App\API\SOAP\StructType\DecimalValue $varianceAmount = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setActualAmount($actualAmount)
            ->setActualPlusOpenCommittedAmount($actualPlusOpenCommittedAmount)
            ->setActualQty($actualQty)
            ->setAutoCompleted($autoCompleted)
            ->setBudgetedCOAmount($budgetedCOAmount)
            ->setBudgetedCOQty($budgetedCOQty)
            ->setCommittedCOAmount($committedCOAmount)
            ->setCommittedCOQty($committedCOQty)
            ->setCommittedInvoicedAmount($committedInvoicedAmount)
            ->setCommittedInvoicedQty($committedInvoicedQty)
            ->setCommittedOpenAmount($committedOpenAmount)
            ->setCommittedOpenQty($committedOpenQty)
            ->setCommittedReceivedQty($committedReceivedQty)
            ->setCompleted($completed)
            ->setCostAtCompletion($costAtCompletion)
            ->setCostCode($costCode)
            ->setCostToComplete($costToComplete)
            ->setDescription($description)
            ->setDraftInvoicesAmount($draftInvoicesAmount)
            ->setInventoryID($inventoryID)
            ->setLastCostAtCompletion($lastCostAtCompletion)
            ->setLastCostToComplete($lastCostToComplete)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLastPercentageOfCompletion($lastPercentageOfCompletion)
            ->setOriginalBudgetedAmount($originalBudgetedAmount)
            ->setOriginalBudgetedQty($originalBudgetedQty)
            ->setOriginalCommittedAmount($originalCommittedAmount)
            ->setOriginalCommittedQty($originalCommittedQty)
            ->setPendingInvoiceAmount($pendingInvoiceAmount)
            ->setPercentageOfCompletion($percentageOfCompletion)
            ->setPerformance($performance)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setRetainage($retainage)
            ->setRevenueTask($revenueTask)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setRevisedBudgetedQty($revisedBudgetedQty)
            ->setRevisedCommittedAmount($revisedCommittedAmount)
            ->setRevisedCommittedQty($revisedCommittedQty)
            ->setTaxCategory($taxCategory)
            ->setType($type)
            ->setUnitRate($unitRate)
            ->setUOM($uOM)
            ->setVarianceAmount($varianceAmount);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setAccountGroup(\App\API\SOAP\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setActualAmount(\App\API\SOAP\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get ActualPlusOpenCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualPlusOpenCommittedAmount()
    {
        return isset($this->ActualPlusOpenCommittedAmount) ? $this->ActualPlusOpenCommittedAmount : null;
    }
    /**
     * Set ActualPlusOpenCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualPlusOpenCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setActualPlusOpenCommittedAmount(\App\API\SOAP\StructType\DecimalValue $actualPlusOpenCommittedAmount = null)
    {
        if (is_null($actualPlusOpenCommittedAmount) || (is_array($actualPlusOpenCommittedAmount) && empty($actualPlusOpenCommittedAmount))) {
            unset($this->ActualPlusOpenCommittedAmount);
        } else {
            $this->ActualPlusOpenCommittedAmount = $actualPlusOpenCommittedAmount;
        }
        return $this;
    }
    /**
     * Get ActualQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualQty()
    {
        return isset($this->ActualQty) ? $this->ActualQty : null;
    }
    /**
     * Set ActualQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setActualQty(\App\API\SOAP\StructType\DecimalValue $actualQty = null)
    {
        if (is_null($actualQty) || (is_array($actualQty) && empty($actualQty))) {
            unset($this->ActualQty);
        } else {
            $this->ActualQty = $actualQty;
        }
        return $this;
    }
    /**
     * Get AutoCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getAutoCompleted()
    {
        return isset($this->AutoCompleted) ? $this->AutoCompleted : null;
    }
    /**
     * Set AutoCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $autoCompleted
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setAutoCompleted(\App\API\SOAP\StructType\BooleanValue $autoCompleted = null)
    {
        if (is_null($autoCompleted) || (is_array($autoCompleted) && empty($autoCompleted))) {
            unset($this->AutoCompleted);
        } else {
            $this->AutoCompleted = $autoCompleted;
        }
        return $this;
    }
    /**
     * Get BudgetedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBudgetedCOAmount()
    {
        return isset($this->BudgetedCOAmount) ? $this->BudgetedCOAmount : null;
    }
    /**
     * Set BudgetedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setBudgetedCOAmount(\App\API\SOAP\StructType\DecimalValue $budgetedCOAmount = null)
    {
        if (is_null($budgetedCOAmount) || (is_array($budgetedCOAmount) && empty($budgetedCOAmount))) {
            unset($this->BudgetedCOAmount);
        } else {
            $this->BudgetedCOAmount = $budgetedCOAmount;
        }
        return $this;
    }
    /**
     * Get BudgetedCOQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBudgetedCOQty()
    {
        return isset($this->BudgetedCOQty) ? $this->BudgetedCOQty : null;
    }
    /**
     * Set BudgetedCOQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setBudgetedCOQty(\App\API\SOAP\StructType\DecimalValue $budgetedCOQty = null)
    {
        if (is_null($budgetedCOQty) || (is_array($budgetedCOQty) && empty($budgetedCOQty))) {
            unset($this->BudgetedCOQty);
        } else {
            $this->BudgetedCOQty = $budgetedCOQty;
        }
        return $this;
    }
    /**
     * Get CommittedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedCOAmount()
    {
        return isset($this->CommittedCOAmount) ? $this->CommittedCOAmount : null;
    }
    /**
     * Set CommittedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedCOAmount(\App\API\SOAP\StructType\DecimalValue $committedCOAmount = null)
    {
        if (is_null($committedCOAmount) || (is_array($committedCOAmount) && empty($committedCOAmount))) {
            unset($this->CommittedCOAmount);
        } else {
            $this->CommittedCOAmount = $committedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedCOQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedCOQty()
    {
        return isset($this->CommittedCOQty) ? $this->CommittedCOQty : null;
    }
    /**
     * Set CommittedCOQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedCOQty(\App\API\SOAP\StructType\DecimalValue $committedCOQty = null)
    {
        if (is_null($committedCOQty) || (is_array($committedCOQty) && empty($committedCOQty))) {
            unset($this->CommittedCOQty);
        } else {
            $this->CommittedCOQty = $committedCOQty;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedInvoicedAmount()
    {
        return isset($this->CommittedInvoicedAmount) ? $this->CommittedInvoicedAmount : null;
    }
    /**
     * Set CommittedInvoicedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedInvoicedAmount(\App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount = null)
    {
        if (is_null($committedInvoicedAmount) || (is_array($committedInvoicedAmount) && empty($committedInvoicedAmount))) {
            unset($this->CommittedInvoicedAmount);
        } else {
            $this->CommittedInvoicedAmount = $committedInvoicedAmount;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedInvoicedQty()
    {
        return isset($this->CommittedInvoicedQty) ? $this->CommittedInvoicedQty : null;
    }
    /**
     * Set CommittedInvoicedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedInvoicedQty(\App\API\SOAP\StructType\DecimalValue $committedInvoicedQty = null)
    {
        if (is_null($committedInvoicedQty) || (is_array($committedInvoicedQty) && empty($committedInvoicedQty))) {
            unset($this->CommittedInvoicedQty);
        } else {
            $this->CommittedInvoicedQty = $committedInvoicedQty;
        }
        return $this;
    }
    /**
     * Get CommittedOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedOpenAmount()
    {
        return isset($this->CommittedOpenAmount) ? $this->CommittedOpenAmount : null;
    }
    /**
     * Set CommittedOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedOpenAmount(\App\API\SOAP\StructType\DecimalValue $committedOpenAmount = null)
    {
        if (is_null($committedOpenAmount) || (is_array($committedOpenAmount) && empty($committedOpenAmount))) {
            unset($this->CommittedOpenAmount);
        } else {
            $this->CommittedOpenAmount = $committedOpenAmount;
        }
        return $this;
    }
    /**
     * Get CommittedOpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedOpenQty()
    {
        return isset($this->CommittedOpenQty) ? $this->CommittedOpenQty : null;
    }
    /**
     * Set CommittedOpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedOpenQty(\App\API\SOAP\StructType\DecimalValue $committedOpenQty = null)
    {
        if (is_null($committedOpenQty) || (is_array($committedOpenQty) && empty($committedOpenQty))) {
            unset($this->CommittedOpenQty);
        } else {
            $this->CommittedOpenQty = $committedOpenQty;
        }
        return $this;
    }
    /**
     * Get CommittedReceivedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedReceivedQty()
    {
        return isset($this->CommittedReceivedQty) ? $this->CommittedReceivedQty : null;
    }
    /**
     * Set CommittedReceivedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedReceivedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCommittedReceivedQty(\App\API\SOAP\StructType\DecimalValue $committedReceivedQty = null)
    {
        if (is_null($committedReceivedQty) || (is_array($committedReceivedQty) && empty($committedReceivedQty))) {
            unset($this->CommittedReceivedQty);
        } else {
            $this->CommittedReceivedQty = $committedReceivedQty;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $completed
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCompleted(\App\API\SOAP\StructType\DecimalValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get CostAtCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCostAtCompletion()
    {
        return isset($this->CostAtCompletion) ? $this->CostAtCompletion : null;
    }
    /**
     * Set CostAtCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $costAtCompletion
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCostAtCompletion(\App\API\SOAP\StructType\DecimalValue $costAtCompletion = null)
    {
        if (is_null($costAtCompletion) || (is_array($costAtCompletion) && empty($costAtCompletion))) {
            unset($this->CostAtCompletion);
        } else {
            $this->CostAtCompletion = $costAtCompletion;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CostToComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCostToComplete()
    {
        return isset($this->CostToComplete) ? $this->CostToComplete : null;
    }
    /**
     * Set CostToComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $costToComplete
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setCostToComplete(\App\API\SOAP\StructType\DecimalValue $costToComplete = null)
    {
        if (is_null($costToComplete) || (is_array($costToComplete) && empty($costToComplete))) {
            unset($this->CostToComplete);
        } else {
            $this->CostToComplete = $costToComplete;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DraftInvoicesAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDraftInvoicesAmount()
    {
        return isset($this->DraftInvoicesAmount) ? $this->DraftInvoicesAmount : null;
    }
    /**
     * Set DraftInvoicesAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setDraftInvoicesAmount(\App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount = null)
    {
        if (is_null($draftInvoicesAmount) || (is_array($draftInvoicesAmount) && empty($draftInvoicesAmount))) {
            unset($this->DraftInvoicesAmount);
        } else {
            $this->DraftInvoicesAmount = $draftInvoicesAmount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LastCostAtCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getLastCostAtCompletion()
    {
        return isset($this->LastCostAtCompletion) ? $this->LastCostAtCompletion : null;
    }
    /**
     * Set LastCostAtCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $lastCostAtCompletion
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setLastCostAtCompletion(\App\API\SOAP\StructType\DecimalValue $lastCostAtCompletion = null)
    {
        if (is_null($lastCostAtCompletion) || (is_array($lastCostAtCompletion) && empty($lastCostAtCompletion))) {
            unset($this->LastCostAtCompletion);
        } else {
            $this->LastCostAtCompletion = $lastCostAtCompletion;
        }
        return $this;
    }
    /**
     * Get LastCostToComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getLastCostToComplete()
    {
        return isset($this->LastCostToComplete) ? $this->LastCostToComplete : null;
    }
    /**
     * Set LastCostToComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $lastCostToComplete
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setLastCostToComplete(\App\API\SOAP\StructType\DecimalValue $lastCostToComplete = null)
    {
        if (is_null($lastCostToComplete) || (is_array($lastCostToComplete) && empty($lastCostToComplete))) {
            unset($this->LastCostToComplete);
        } else {
            $this->LastCostToComplete = $lastCostToComplete;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LastPercentageOfCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getLastPercentageOfCompletion()
    {
        return isset($this->LastPercentageOfCompletion) ? $this->LastPercentageOfCompletion : null;
    }
    /**
     * Set LastPercentageOfCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $lastPercentageOfCompletion
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setLastPercentageOfCompletion(\App\API\SOAP\StructType\DecimalValue $lastPercentageOfCompletion = null)
    {
        if (is_null($lastPercentageOfCompletion) || (is_array($lastPercentageOfCompletion) && empty($lastPercentageOfCompletion))) {
            unset($this->LastPercentageOfCompletion);
        } else {
            $this->LastPercentageOfCompletion = $lastPercentageOfCompletion;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalBudgetedAmount()
    {
        return isset($this->OriginalBudgetedAmount) ? $this->OriginalBudgetedAmount : null;
    }
    /**
     * Set OriginalBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setOriginalBudgetedAmount(\App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount = null)
    {
        if (is_null($originalBudgetedAmount) || (is_array($originalBudgetedAmount) && empty($originalBudgetedAmount))) {
            unset($this->OriginalBudgetedAmount);
        } else {
            $this->OriginalBudgetedAmount = $originalBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalBudgetedQty()
    {
        return isset($this->OriginalBudgetedQty) ? $this->OriginalBudgetedQty : null;
    }
    /**
     * Set OriginalBudgetedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setOriginalBudgetedQty(\App\API\SOAP\StructType\DecimalValue $originalBudgetedQty = null)
    {
        if (is_null($originalBudgetedQty) || (is_array($originalBudgetedQty) && empty($originalBudgetedQty))) {
            unset($this->OriginalBudgetedQty);
        } else {
            $this->OriginalBudgetedQty = $originalBudgetedQty;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalCommittedAmount()
    {
        return isset($this->OriginalCommittedAmount) ? $this->OriginalCommittedAmount : null;
    }
    /**
     * Set OriginalCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setOriginalCommittedAmount(\App\API\SOAP\StructType\DecimalValue $originalCommittedAmount = null)
    {
        if (is_null($originalCommittedAmount) || (is_array($originalCommittedAmount) && empty($originalCommittedAmount))) {
            unset($this->OriginalCommittedAmount);
        } else {
            $this->OriginalCommittedAmount = $originalCommittedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalCommittedQty()
    {
        return isset($this->OriginalCommittedQty) ? $this->OriginalCommittedQty : null;
    }
    /**
     * Set OriginalCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setOriginalCommittedQty(\App\API\SOAP\StructType\DecimalValue $originalCommittedQty = null)
    {
        if (is_null($originalCommittedQty) || (is_array($originalCommittedQty) && empty($originalCommittedQty))) {
            unset($this->OriginalCommittedQty);
        } else {
            $this->OriginalCommittedQty = $originalCommittedQty;
        }
        return $this;
    }
    /**
     * Get PendingInvoiceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPendingInvoiceAmount()
    {
        return isset($this->PendingInvoiceAmount) ? $this->PendingInvoiceAmount : null;
    }
    /**
     * Set PendingInvoiceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $pendingInvoiceAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setPendingInvoiceAmount(\App\API\SOAP\StructType\DecimalValue $pendingInvoiceAmount = null)
    {
        if (is_null($pendingInvoiceAmount) || (is_array($pendingInvoiceAmount) && empty($pendingInvoiceAmount))) {
            unset($this->PendingInvoiceAmount);
        } else {
            $this->PendingInvoiceAmount = $pendingInvoiceAmount;
        }
        return $this;
    }
    /**
     * Get PercentageOfCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPercentageOfCompletion()
    {
        return isset($this->PercentageOfCompletion) ? $this->PercentageOfCompletion : null;
    }
    /**
     * Set PercentageOfCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $percentageOfCompletion
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setPercentageOfCompletion(\App\API\SOAP\StructType\DecimalValue $percentageOfCompletion = null)
    {
        if (is_null($percentageOfCompletion) || (is_array($percentageOfCompletion) && empty($percentageOfCompletion))) {
            unset($this->PercentageOfCompletion);
        } else {
            $this->PercentageOfCompletion = $percentageOfCompletion;
        }
        return $this;
    }
    /**
     * Get Performance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPerformance()
    {
        return isset($this->Performance) ? $this->Performance : null;
    }
    /**
     * Set Performance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $performance
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setPerformance(\App\API\SOAP\StructType\DecimalValue $performance = null)
    {
        if (is_null($performance) || (is_array($performance) && empty($performance))) {
            unset($this->Performance);
        } else {
            $this->Performance = $performance;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setProjectID(\App\API\SOAP\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setProjectTaskID(\App\API\SOAP\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRetainage(\App\API\SOAP\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RevenueTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getRevenueTask()
    {
        return isset($this->RevenueTask) ? $this->RevenueTask : null;
    }
    /**
     * Set RevenueTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $revenueTask
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRevenueTask(\App\API\SOAP\StructType\IntValue $revenueTask = null)
    {
        if (is_null($revenueTask) || (is_array($revenueTask) && empty($revenueTask))) {
            unset($this->RevenueTask);
        } else {
            $this->RevenueTask = $revenueTask;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRevisedBudgetedAmount(\App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedBudgetedQty()
    {
        return isset($this->RevisedBudgetedQty) ? $this->RevisedBudgetedQty : null;
    }
    /**
     * Set RevisedBudgetedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRevisedBudgetedQty(\App\API\SOAP\StructType\DecimalValue $revisedBudgetedQty = null)
    {
        if (is_null($revisedBudgetedQty) || (is_array($revisedBudgetedQty) && empty($revisedBudgetedQty))) {
            unset($this->RevisedBudgetedQty);
        } else {
            $this->RevisedBudgetedQty = $revisedBudgetedQty;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedCommittedAmount()
    {
        return isset($this->RevisedCommittedAmount) ? $this->RevisedCommittedAmount : null;
    }
    /**
     * Set RevisedCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRevisedCommittedAmount(\App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount = null)
    {
        if (is_null($revisedCommittedAmount) || (is_array($revisedCommittedAmount) && empty($revisedCommittedAmount))) {
            unset($this->RevisedCommittedAmount);
        } else {
            $this->RevisedCommittedAmount = $revisedCommittedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedCommittedQty()
    {
        return isset($this->RevisedCommittedQty) ? $this->RevisedCommittedQty : null;
    }
    /**
     * Set RevisedCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedQty
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setRevisedCommittedQty(\App\API\SOAP\StructType\DecimalValue $revisedCommittedQty = null)
    {
        if (is_null($revisedCommittedQty) || (is_array($revisedCommittedQty) && empty($revisedCommittedQty))) {
            unset($this->RevisedCommittedQty);
        } else {
            $this->RevisedCommittedQty = $revisedCommittedQty;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitRate()
    {
        return isset($this->UnitRate) ? $this->UnitRate : null;
    }
    /**
     * Set UnitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitRate
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setUnitRate(\App\API\SOAP\StructType\DecimalValue $unitRate = null)
    {
        if (is_null($unitRate) || (is_array($unitRate) && empty($unitRate))) {
            unset($this->UnitRate);
        } else {
            $this->UnitRate = $unitRate;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get VarianceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVarianceAmount()
    {
        return isset($this->VarianceAmount) ? $this->VarianceAmount : null;
    }
    /**
     * Set VarianceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $varianceAmount
     * @return \App\API\SOAP\StructType\ProjectBudget
     */
    public function setVarianceAmount(\App\API\SOAP\StructType\DecimalValue $varianceAmount = null)
    {
        if (is_null($varianceAmount) || (is_array($varianceAmount) && empty($varianceAmount))) {
            unset($this->VarianceAmount);
        } else {
            $this->VarianceAmount = $varianceAmount;
        }
        return $this;
    }
}
