<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBillingRules StructType
 * @subpackage Structs
 */
class ProjectBillingRules extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Active;
    /**
     * The BillingRuleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BillingRuleID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * Constructor method for ProjectBillingRules
     * @uses ProjectBillingRules::setActive()
     * @uses ProjectBillingRules::setBillingRuleID()
     * @uses ProjectBillingRules::setDescription()
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @param \App\API\SOAP\StructType\StringValue $billingRuleID
     * @param \App\API\SOAP\StructType\StringValue $description
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $active = null, \App\API\SOAP\StructType\StringValue $billingRuleID = null, \App\API\SOAP\StructType\StringValue $description = null)
    {
        $this
            ->setActive($active)
            ->setBillingRuleID($billingRuleID)
            ->setDescription($description);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @return \App\API\SOAP\StructType\ProjectBillingRules
     */
    public function setActive(\App\API\SOAP\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get BillingRuleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBillingRuleID()
    {
        return isset($this->BillingRuleID) ? $this->BillingRuleID : null;
    }
    /**
     * Set BillingRuleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $billingRuleID
     * @return \App\API\SOAP\StructType\ProjectBillingRules
     */
    public function setBillingRuleID(\App\API\SOAP\StructType\StringValue $billingRuleID = null)
    {
        if (is_null($billingRuleID) || (is_array($billingRuleID) && empty($billingRuleID))) {
            unset($this->BillingRuleID);
        } else {
            $this->BillingRuleID = $billingRuleID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectBillingRules
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
