<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBillingDetails StructType
 * @subpackage Structs
 */
class ProjectBillingDetails extends Entity
{
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $From;
    /**
     * The LastBillingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastBillingDate;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectID;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Selected;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $To;
    /**
     * Constructor method for ProjectBillingDetails
     * @uses ProjectBillingDetails::setCustomerID()
     * @uses ProjectBillingDetails::setCustomerName()
     * @uses ProjectBillingDetails::setDescription()
     * @uses ProjectBillingDetails::setFrom()
     * @uses ProjectBillingDetails::setLastBillingDate()
     * @uses ProjectBillingDetails::setProjectID()
     * @uses ProjectBillingDetails::setSelected()
     * @uses ProjectBillingDetails::setTo()
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\StringValue $customerName
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DateTimeValue $from
     * @param \App\API\SOAP\StructType\DateTimeValue $lastBillingDate
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @param \App\API\SOAP\StructType\DateTimeValue $to
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\StringValue $customerName = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DateTimeValue $from = null, \App\API\SOAP\StructType\DateTimeValue $lastBillingDate = null, \App\API\SOAP\StructType\StringValue $projectID = null, \App\API\SOAP\StructType\BooleanValue $selected = null, \App\API\SOAP\StructType\DateTimeValue $to = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerName($customerName)
            ->setDescription($description)
            ->setFrom($from)
            ->setLastBillingDate($lastBillingDate)
            ->setProjectID($projectID)
            ->setSelected($selected)
            ->setTo($to);
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerName
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setCustomerName(\App\API\SOAP\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $from
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setFrom(\App\API\SOAP\StructType\DateTimeValue $from = null)
    {
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get LastBillingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastBillingDate()
    {
        return isset($this->LastBillingDate) ? $this->LastBillingDate : null;
    }
    /**
     * Set LastBillingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastBillingDate
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setLastBillingDate(\App\API\SOAP\StructType\DateTimeValue $lastBillingDate = null)
    {
        if (is_null($lastBillingDate) || (is_array($lastBillingDate) && empty($lastBillingDate))) {
            unset($this->LastBillingDate);
        } else {
            $this->LastBillingDate = $lastBillingDate;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setProjectID(\App\API\SOAP\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setSelected(\App\API\SOAP\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get To value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getTo()
    {
        return isset($this->To) ? $this->To : null;
    }
    /**
     * Set To value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $to
     * @return \App\API\SOAP\StructType\ProjectBillingDetails
     */
    public function setTo(\App\API\SOAP\StructType\DateTimeValue $to = null)
    {
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->To);
        } else {
            $this->To = $to;
        }
        return $this;
    }
}
