<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBilling StructType
 * @subpackage Structs
 */
class ProjectBilling extends Entity
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Customer;
    /**
     * The CustomerClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerClass;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $InvoiceDate;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The ProjectTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTemplate;
    /**
     * The StatementCycle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StatementCycle;
    /**
     * Constructor method for ProjectBilling
     * @uses ProjectBilling::setCustomer()
     * @uses ProjectBilling::setCustomerClass()
     * @uses ProjectBilling::setDetails()
     * @uses ProjectBilling::setInvoiceDate()
     * @uses ProjectBilling::setPostPeriod()
     * @uses ProjectBilling::setProjectTemplate()
     * @uses ProjectBilling::setStatementCycle()
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @param \App\API\SOAP\StructType\StringValue $customerClass
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\DateTimeValue $invoiceDate
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @param \App\API\SOAP\StructType\StringValue $projectTemplate
     * @param \App\API\SOAP\StructType\StringValue $statementCycle
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $customer = null, \App\API\SOAP\StructType\StringValue $customerClass = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\DateTimeValue $invoiceDate = null, \App\API\SOAP\StructType\StringValue $postPeriod = null, \App\API\SOAP\StructType\StringValue $projectTemplate = null, \App\API\SOAP\StructType\StringValue $statementCycle = null)
    {
        $this
            ->setCustomer($customer)
            ->setCustomerClass($customerClass)
            ->setDetails($details)
            ->setInvoiceDate($invoiceDate)
            ->setPostPeriod($postPeriod)
            ->setProjectTemplate($projectTemplate)
            ->setStatementCycle($statementCycle);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setCustomer(\App\API\SOAP\StructType\StringValue $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get CustomerClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerClass()
    {
        return isset($this->CustomerClass) ? $this->CustomerClass : null;
    }
    /**
     * Set CustomerClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerClass
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setCustomerClass(\App\API\SOAP\StructType\StringValue $customerClass = null)
    {
        if (is_null($customerClass) || (is_array($customerClass) && empty($customerClass))) {
            unset($this->CustomerClass);
        } else {
            $this->CustomerClass = $customerClass;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get InvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getInvoiceDate()
    {
        return isset($this->InvoiceDate) ? $this->InvoiceDate : null;
    }
    /**
     * Set InvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $invoiceDate
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setInvoiceDate(\App\API\SOAP\StructType\DateTimeValue $invoiceDate = null)
    {
        if (is_null($invoiceDate) || (is_array($invoiceDate) && empty($invoiceDate))) {
            unset($this->InvoiceDate);
        } else {
            $this->InvoiceDate = $invoiceDate;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setPostPeriod(\App\API\SOAP\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get ProjectTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTemplate()
    {
        return isset($this->ProjectTemplate) ? $this->ProjectTemplate : null;
    }
    /**
     * Set ProjectTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTemplate
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setProjectTemplate(\App\API\SOAP\StructType\StringValue $projectTemplate = null)
    {
        if (is_null($projectTemplate) || (is_array($projectTemplate) && empty($projectTemplate))) {
            unset($this->ProjectTemplate);
        } else {
            $this->ProjectTemplate = $projectTemplate;
        }
        return $this;
    }
    /**
     * Get StatementCycle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatementCycle()
    {
        return isset($this->StatementCycle) ? $this->StatementCycle : null;
    }
    /**
     * Set StatementCycle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $statementCycle
     * @return \App\API\SOAP\StructType\ProjectBilling
     */
    public function setStatementCycle(\App\API\SOAP\StructType\StringValue $statementCycle = null)
    {
        if (is_null($statementCycle) || (is_array($statementCycle) && empty($statementCycle))) {
            unset($this->StatementCycle);
        } else {
            $this->StatementCycle = $statementCycle;
        }
        return $this;
    }
}
