<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBalance StructType
 * @subpackage Structs
 */
class ProjectBalance extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The ActualOpenCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualOpenCommittedAmount;
    /**
     * The BudgetedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $BudgetedCOAmount;
    /**
     * The CommittedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedCOAmount;
    /**
     * The CommittedInvoicedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedInvoicedAmount;
    /**
     * The CommittedOpenAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CommittedOpenAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The OriginalBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalBudgetedAmount;
    /**
     * The OriginalCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OriginalCommittedAmount;
    /**
     * The Performance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Performance;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The RevisedCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedCommittedAmount;
    /**
     * The VarianceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $VarianceAmount;
    /**
     * Constructor method for ProjectBalance
     * @uses ProjectBalance::setAccountGroup()
     * @uses ProjectBalance::setActualAmount()
     * @uses ProjectBalance::setActualOpenCommittedAmount()
     * @uses ProjectBalance::setBudgetedCOAmount()
     * @uses ProjectBalance::setCommittedCOAmount()
     * @uses ProjectBalance::setCommittedInvoicedAmount()
     * @uses ProjectBalance::setCommittedOpenAmount()
     * @uses ProjectBalance::setDescription()
     * @uses ProjectBalance::setOriginalBudgetedAmount()
     * @uses ProjectBalance::setOriginalCommittedAmount()
     * @uses ProjectBalance::setPerformance()
     * @uses ProjectBalance::setRevisedBudgetedAmount()
     * @uses ProjectBalance::setRevisedCommittedAmount()
     * @uses ProjectBalance::setVarianceAmount()
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @param \App\API\SOAP\StructType\DecimalValue $actualOpenCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenAmount
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $performance
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount
     * @param \App\API\SOAP\StructType\DecimalValue $varianceAmount
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountGroup = null, \App\API\SOAP\StructType\DecimalValue $actualAmount = null, \App\API\SOAP\StructType\DecimalValue $actualOpenCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount = null, \App\API\SOAP\StructType\DecimalValue $committedCOAmount = null, \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount = null, \App\API\SOAP\StructType\DecimalValue $committedOpenAmount = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount = null, \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $performance = null, \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null, \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount = null, \App\API\SOAP\StructType\DecimalValue $varianceAmount = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setActualAmount($actualAmount)
            ->setActualOpenCommittedAmount($actualOpenCommittedAmount)
            ->setBudgetedCOAmount($budgetedCOAmount)
            ->setCommittedCOAmount($committedCOAmount)
            ->setCommittedInvoicedAmount($committedInvoicedAmount)
            ->setCommittedOpenAmount($committedOpenAmount)
            ->setDescription($description)
            ->setOriginalBudgetedAmount($originalBudgetedAmount)
            ->setOriginalCommittedAmount($originalCommittedAmount)
            ->setPerformance($performance)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setRevisedCommittedAmount($revisedCommittedAmount)
            ->setVarianceAmount($varianceAmount);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountGroup
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setAccountGroup(\App\API\SOAP\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setActualAmount(\App\API\SOAP\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get ActualOpenCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualOpenCommittedAmount()
    {
        return isset($this->ActualOpenCommittedAmount) ? $this->ActualOpenCommittedAmount : null;
    }
    /**
     * Set ActualOpenCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualOpenCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setActualOpenCommittedAmount(\App\API\SOAP\StructType\DecimalValue $actualOpenCommittedAmount = null)
    {
        if (is_null($actualOpenCommittedAmount) || (is_array($actualOpenCommittedAmount) && empty($actualOpenCommittedAmount))) {
            unset($this->ActualOpenCommittedAmount);
        } else {
            $this->ActualOpenCommittedAmount = $actualOpenCommittedAmount;
        }
        return $this;
    }
    /**
     * Get BudgetedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBudgetedCOAmount()
    {
        return isset($this->BudgetedCOAmount) ? $this->BudgetedCOAmount : null;
    }
    /**
     * Set BudgetedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $budgetedCOAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setBudgetedCOAmount(\App\API\SOAP\StructType\DecimalValue $budgetedCOAmount = null)
    {
        if (is_null($budgetedCOAmount) || (is_array($budgetedCOAmount) && empty($budgetedCOAmount))) {
            unset($this->BudgetedCOAmount);
        } else {
            $this->BudgetedCOAmount = $budgetedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedCOAmount()
    {
        return isset($this->CommittedCOAmount) ? $this->CommittedCOAmount : null;
    }
    /**
     * Set CommittedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedCOAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setCommittedCOAmount(\App\API\SOAP\StructType\DecimalValue $committedCOAmount = null)
    {
        if (is_null($committedCOAmount) || (is_array($committedCOAmount) && empty($committedCOAmount))) {
            unset($this->CommittedCOAmount);
        } else {
            $this->CommittedCOAmount = $committedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedInvoicedAmount()
    {
        return isset($this->CommittedInvoicedAmount) ? $this->CommittedInvoicedAmount : null;
    }
    /**
     * Set CommittedInvoicedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setCommittedInvoicedAmount(\App\API\SOAP\StructType\DecimalValue $committedInvoicedAmount = null)
    {
        if (is_null($committedInvoicedAmount) || (is_array($committedInvoicedAmount) && empty($committedInvoicedAmount))) {
            unset($this->CommittedInvoicedAmount);
        } else {
            $this->CommittedInvoicedAmount = $committedInvoicedAmount;
        }
        return $this;
    }
    /**
     * Get CommittedOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCommittedOpenAmount()
    {
        return isset($this->CommittedOpenAmount) ? $this->CommittedOpenAmount : null;
    }
    /**
     * Set CommittedOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $committedOpenAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setCommittedOpenAmount(\App\API\SOAP\StructType\DecimalValue $committedOpenAmount = null)
    {
        if (is_null($committedOpenAmount) || (is_array($committedOpenAmount) && empty($committedOpenAmount))) {
            unset($this->CommittedOpenAmount);
        } else {
            $this->CommittedOpenAmount = $committedOpenAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalBudgetedAmount()
    {
        return isset($this->OriginalBudgetedAmount) ? $this->OriginalBudgetedAmount : null;
    }
    /**
     * Set OriginalBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setOriginalBudgetedAmount(\App\API\SOAP\StructType\DecimalValue $originalBudgetedAmount = null)
    {
        if (is_null($originalBudgetedAmount) || (is_array($originalBudgetedAmount) && empty($originalBudgetedAmount))) {
            unset($this->OriginalBudgetedAmount);
        } else {
            $this->OriginalBudgetedAmount = $originalBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOriginalCommittedAmount()
    {
        return isset($this->OriginalCommittedAmount) ? $this->OriginalCommittedAmount : null;
    }
    /**
     * Set OriginalCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $originalCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setOriginalCommittedAmount(\App\API\SOAP\StructType\DecimalValue $originalCommittedAmount = null)
    {
        if (is_null($originalCommittedAmount) || (is_array($originalCommittedAmount) && empty($originalCommittedAmount))) {
            unset($this->OriginalCommittedAmount);
        } else {
            $this->OriginalCommittedAmount = $originalCommittedAmount;
        }
        return $this;
    }
    /**
     * Get Performance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPerformance()
    {
        return isset($this->Performance) ? $this->Performance : null;
    }
    /**
     * Set Performance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $performance
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setPerformance(\App\API\SOAP\StructType\DecimalValue $performance = null)
    {
        if (is_null($performance) || (is_array($performance) && empty($performance))) {
            unset($this->Performance);
        } else {
            $this->Performance = $performance;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setRevisedBudgetedAmount(\App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedCommittedAmount()
    {
        return isset($this->RevisedCommittedAmount) ? $this->RevisedCommittedAmount : null;
    }
    /**
     * Set RevisedCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setRevisedCommittedAmount(\App\API\SOAP\StructType\DecimalValue $revisedCommittedAmount = null)
    {
        if (is_null($revisedCommittedAmount) || (is_array($revisedCommittedAmount) && empty($revisedCommittedAmount))) {
            unset($this->RevisedCommittedAmount);
        } else {
            $this->RevisedCommittedAmount = $revisedCommittedAmount;
        }
        return $this;
    }
    /**
     * Get VarianceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getVarianceAmount()
    {
        return isset($this->VarianceAmount) ? $this->VarianceAmount : null;
    }
    /**
     * Set VarianceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $varianceAmount
     * @return \App\API\SOAP\StructType\ProjectBalance
     */
    public function setVarianceAmount(\App\API\SOAP\StructType\DecimalValue $varianceAmount = null)
    {
        if (is_null($varianceAmount) || (is_array($varianceAmount) && empty($varianceAmount))) {
            unset($this->VarianceAmount);
        } else {
            $this->VarianceAmount = $varianceAmount;
        }
        return $this;
    }
}
