<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgressBilling StructType
 * @subpackage Structs
 */
class ProgressBilling extends Entity
{
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The AmountToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AmountToInvoice;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The CurrentInvoiced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $CurrentInvoiced;
    /**
     * The DeferralCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DeferralCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DraftInvoicesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DraftInvoicesAmount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The PreviouslyInvoiced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PreviouslyInvoiced;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RetainageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RetainageAmount;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The StoredMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $StoredMaterial;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TotalCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TotalCompleted;
    /**
     * The ProgressBilling
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProgressBilling[]
     */
    public $ProgressBilling;
    /**
     * Constructor method for ProgressBilling
     * @uses ProgressBilling::setActualAmount()
     * @uses ProgressBilling::setAmount()
     * @uses ProgressBilling::setAmountToInvoice()
     * @uses ProgressBilling::setBranch()
     * @uses ProgressBilling::setCostCode()
     * @uses ProgressBilling::setCurrentInvoiced()
     * @uses ProgressBilling::setDeferralCode()
     * @uses ProgressBilling::setDescription()
     * @uses ProgressBilling::setDraftInvoicesAmount()
     * @uses ProgressBilling::setInventoryID()
     * @uses ProgressBilling::setPreviouslyInvoiced()
     * @uses ProgressBilling::setProjectTaskID()
     * @uses ProgressBilling::setRetainage()
     * @uses ProgressBilling::setRetainageAmount()
     * @uses ProgressBilling::setRevisedBudgetedAmount()
     * @uses ProgressBilling::setSalesAccount()
     * @uses ProgressBilling::setSalesSubaccount()
     * @uses ProgressBilling::setStoredMaterial()
     * @uses ProgressBilling::setTaxCategory()
     * @uses ProgressBilling::setTotalCompleted()
     * @uses ProgressBilling::setProgressBilling()
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\DecimalValue $amountToInvoice
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\DecimalValue $currentInvoiced
     * @param \App\API\SOAP\StructType\StringValue $deferralCode
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\DecimalValue $previouslyInvoiced
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @param \App\API\SOAP\StructType\DecimalValue $retainageAmount
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @param \App\API\SOAP\StructType\DecimalValue $storedMaterial
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\DecimalValue $totalCompleted
     * @param \App\API\SOAP\StructType\ProgressBilling[] $progressBilling
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $actualAmount = null, \App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\DecimalValue $amountToInvoice = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\DecimalValue $currentInvoiced = null, \App\API\SOAP\StructType\StringValue $deferralCode = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\DecimalValue $previouslyInvoiced = null, \App\API\SOAP\StructType\StringValue $projectTaskID = null, \App\API\SOAP\StructType\DecimalValue $retainage = null, \App\API\SOAP\StructType\DecimalValue $retainageAmount = null, \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null, \App\API\SOAP\StructType\StringValue $salesAccount = null, \App\API\SOAP\StructType\StringValue $salesSubaccount = null, \App\API\SOAP\StructType\DecimalValue $storedMaterial = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\DecimalValue $totalCompleted = null, array $progressBilling = array())
    {
        $this
            ->setActualAmount($actualAmount)
            ->setAmount($amount)
            ->setAmountToInvoice($amountToInvoice)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setCurrentInvoiced($currentInvoiced)
            ->setDeferralCode($deferralCode)
            ->setDescription($description)
            ->setDraftInvoicesAmount($draftInvoicesAmount)
            ->setInventoryID($inventoryID)
            ->setPreviouslyInvoiced($previouslyInvoiced)
            ->setProjectTaskID($projectTaskID)
            ->setRetainage($retainage)
            ->setRetainageAmount($retainageAmount)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStoredMaterial($storedMaterial)
            ->setTaxCategory($taxCategory)
            ->setTotalCompleted($totalCompleted)
            ->setProgressBilling($progressBilling);
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $actualAmount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setActualAmount(\App\API\SOAP\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmountToInvoice()
    {
        return isset($this->AmountToInvoice) ? $this->AmountToInvoice : null;
    }
    /**
     * Set AmountToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amountToInvoice
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setAmountToInvoice(\App\API\SOAP\StructType\DecimalValue $amountToInvoice = null)
    {
        if (is_null($amountToInvoice) || (is_array($amountToInvoice) && empty($amountToInvoice))) {
            unset($this->AmountToInvoice);
        } else {
            $this->AmountToInvoice = $amountToInvoice;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CurrentInvoiced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getCurrentInvoiced()
    {
        return isset($this->CurrentInvoiced) ? $this->CurrentInvoiced : null;
    }
    /**
     * Set CurrentInvoiced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $currentInvoiced
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setCurrentInvoiced(\App\API\SOAP\StructType\DecimalValue $currentInvoiced = null)
    {
        if (is_null($currentInvoiced) || (is_array($currentInvoiced) && empty($currentInvoiced))) {
            unset($this->CurrentInvoiced);
        } else {
            $this->CurrentInvoiced = $currentInvoiced;
        }
        return $this;
    }
    /**
     * Get DeferralCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDeferralCode()
    {
        return isset($this->DeferralCode) ? $this->DeferralCode : null;
    }
    /**
     * Set DeferralCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $deferralCode
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setDeferralCode(\App\API\SOAP\StructType\StringValue $deferralCode = null)
    {
        if (is_null($deferralCode) || (is_array($deferralCode) && empty($deferralCode))) {
            unset($this->DeferralCode);
        } else {
            $this->DeferralCode = $deferralCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DraftInvoicesAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDraftInvoicesAmount()
    {
        return isset($this->DraftInvoicesAmount) ? $this->DraftInvoicesAmount : null;
    }
    /**
     * Set DraftInvoicesAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setDraftInvoicesAmount(\App\API\SOAP\StructType\DecimalValue $draftInvoicesAmount = null)
    {
        if (is_null($draftInvoicesAmount) || (is_array($draftInvoicesAmount) && empty($draftInvoicesAmount))) {
            unset($this->DraftInvoicesAmount);
        } else {
            $this->DraftInvoicesAmount = $draftInvoicesAmount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get PreviouslyInvoiced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPreviouslyInvoiced()
    {
        return isset($this->PreviouslyInvoiced) ? $this->PreviouslyInvoiced : null;
    }
    /**
     * Set PreviouslyInvoiced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $previouslyInvoiced
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setPreviouslyInvoiced(\App\API\SOAP\StructType\DecimalValue $previouslyInvoiced = null)
    {
        if (is_null($previouslyInvoiced) || (is_array($previouslyInvoiced) && empty($previouslyInvoiced))) {
            unset($this->PreviouslyInvoiced);
        } else {
            $this->PreviouslyInvoiced = $previouslyInvoiced;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setProjectTaskID(\App\API\SOAP\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $retainage
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setRetainage(\App\API\SOAP\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RetainageAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRetainageAmount()
    {
        return isset($this->RetainageAmount) ? $this->RetainageAmount : null;
    }
    /**
     * Set RetainageAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $retainageAmount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setRetainageAmount(\App\API\SOAP\StructType\DecimalValue $retainageAmount = null)
    {
        if (is_null($retainageAmount) || (is_array($retainageAmount) && empty($retainageAmount))) {
            unset($this->RetainageAmount);
        } else {
            $this->RetainageAmount = $retainageAmount;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setRevisedBudgetedAmount(\App\API\SOAP\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setSalesAccount(\App\API\SOAP\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setSalesSubaccount(\App\API\SOAP\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get StoredMaterial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getStoredMaterial()
    {
        return isset($this->StoredMaterial) ? $this->StoredMaterial : null;
    }
    /**
     * Set StoredMaterial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $storedMaterial
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setStoredMaterial(\App\API\SOAP\StructType\DecimalValue $storedMaterial = null)
    {
        if (is_null($storedMaterial) || (is_array($storedMaterial) && empty($storedMaterial))) {
            unset($this->StoredMaterial);
        } else {
            $this->StoredMaterial = $storedMaterial;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TotalCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotalCompleted()
    {
        return isset($this->TotalCompleted) ? $this->TotalCompleted : null;
    }
    /**
     * Set TotalCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $totalCompleted
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setTotalCompleted(\App\API\SOAP\StructType\DecimalValue $totalCompleted = null)
    {
        if (is_null($totalCompleted) || (is_array($totalCompleted) && empty($totalCompleted))) {
            unset($this->TotalCompleted);
        } else {
            $this->TotalCompleted = $totalCompleted;
        }
        return $this;
    }
    /**
     * Get ProgressBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProgressBilling[]|null
     */
    public function getProgressBilling()
    {
        return isset($this->ProgressBilling) ? $this->ProgressBilling : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProgressBilling method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgressBilling method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgressBillingForArrayConstraintsFromSetProgressBilling(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $progressBillingProgressBillingItem) {
            // validation for constraint: itemType
            if (!$progressBillingProgressBillingItem instanceof \App\API\SOAP\StructType\ProgressBilling) {
                $invalidValues[] = is_object($progressBillingProgressBillingItem) ? get_class($progressBillingProgressBillingItem) : sprintf('%s(%s)', gettype($progressBillingProgressBillingItem), var_export($progressBillingProgressBillingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgressBilling property can only contain items of type \App\API\SOAP\StructType\ProgressBilling, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgressBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProgressBilling[] $progressBilling
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function setProgressBilling(array $progressBilling = array())
    {
        // validation for constraint: array
        if ('' !== ($progressBillingArrayErrorMessage = self::validateProgressBillingForArrayConstraintsFromSetProgressBilling($progressBilling))) {
            throw new \InvalidArgumentException($progressBillingArrayErrorMessage, __LINE__);
        }
        if (is_null($progressBilling) || (is_array($progressBilling) && empty($progressBilling))) {
            unset($this->ProgressBilling);
        } else {
            $this->ProgressBilling = $progressBilling;
        }
        return $this;
    }
    /**
     * Add item to ProgressBilling value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProgressBilling $item
     * @return \App\API\SOAP\StructType\ProgressBilling
     */
    public function addToProgressBilling(\App\API\SOAP\StructType\ProgressBilling $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProgressBilling) {
            throw new \InvalidArgumentException(sprintf('The ProgressBilling property can only contain items of type \App\API\SOAP\StructType\ProgressBilling, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgressBilling[] = $item;
        return $this;
    }
}
