<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Products StructType
 * @subpackage Structs
 */
class Products extends AbstractStructBase
{
    /**
     * The OpportunityProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\OpportunityProduct[]
     */
    public $OpportunityProduct;
    /**
     * Constructor method for Products
     * @uses Products::setOpportunityProduct()
     * @param \App\API\SOAP\StructType\OpportunityProduct[] $opportunityProduct
     */
    public function __construct(array $opportunityProduct = array())
    {
        $this
            ->setOpportunityProduct($opportunityProduct);
    }
    /**
     * Get OpportunityProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\OpportunityProduct[]|null
     */
    public function getOpportunityProduct()
    {
        return isset($this->OpportunityProduct) ? $this->OpportunityProduct : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpportunityProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpportunityProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpportunityProductForArrayConstraintsFromSetOpportunityProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsOpportunityProductItem) {
            // validation for constraint: itemType
            if (!$productsOpportunityProductItem instanceof \App\API\SOAP\StructType\OpportunityProduct) {
                $invalidValues[] = is_object($productsOpportunityProductItem) ? get_class($productsOpportunityProductItem) : sprintf('%s(%s)', gettype($productsOpportunityProductItem), var_export($productsOpportunityProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpportunityProduct property can only contain items of type \App\API\SOAP\StructType\OpportunityProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpportunityProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\OpportunityProduct[] $opportunityProduct
     * @return \App\API\SOAP\StructType\Products
     */
    public function setOpportunityProduct(array $opportunityProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($opportunityProductArrayErrorMessage = self::validateOpportunityProductForArrayConstraintsFromSetOpportunityProduct($opportunityProduct))) {
            throw new \InvalidArgumentException($opportunityProductArrayErrorMessage, __LINE__);
        }
        if (is_null($opportunityProduct) || (is_array($opportunityProduct) && empty($opportunityProduct))) {
            unset($this->OpportunityProduct);
        } else {
            $this->OpportunityProduct = $opportunityProduct;
        }
        return $this;
    }
    /**
     * Add item to OpportunityProduct value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\OpportunityProduct $item
     * @return \App\API\SOAP\StructType\Products
     */
    public function addToOpportunityProduct(\App\API\SOAP\StructType\OpportunityProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\OpportunityProduct) {
            throw new \InvalidArgumentException(sprintf('The OpportunityProduct property can only contain items of type \App\API\SOAP\StructType\OpportunityProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OpportunityProduct[] = $item;
        return $this;
    }
}
