<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingCenters StructType
 * @subpackage Structs
 */
class ProcessingCenters extends AbstractStructBase
{
    /**
     * The PaymentMethodProcessingCenterDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail[]
     */
    public $PaymentMethodProcessingCenterDetail;
    /**
     * Constructor method for ProcessingCenters
     * @uses ProcessingCenters::setPaymentMethodProcessingCenterDetail()
     * @param \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail[] $paymentMethodProcessingCenterDetail
     */
    public function __construct(array $paymentMethodProcessingCenterDetail = array())
    {
        $this
            ->setPaymentMethodProcessingCenterDetail($paymentMethodProcessingCenterDetail);
    }
    /**
     * Get PaymentMethodProcessingCenterDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail[]|null
     */
    public function getPaymentMethodProcessingCenterDetail()
    {
        return isset($this->PaymentMethodProcessingCenterDetail) ? $this->PaymentMethodProcessingCenterDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethodProcessingCenterDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethodProcessingCenterDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodProcessingCenterDetailForArrayConstraintsFromSetPaymentMethodProcessingCenterDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $processingCentersPaymentMethodProcessingCenterDetailItem) {
            // validation for constraint: itemType
            if (!$processingCentersPaymentMethodProcessingCenterDetailItem instanceof \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail) {
                $invalidValues[] = is_object($processingCentersPaymentMethodProcessingCenterDetailItem) ? get_class($processingCentersPaymentMethodProcessingCenterDetailItem) : sprintf('%s(%s)', gettype($processingCentersPaymentMethodProcessingCenterDetailItem), var_export($processingCentersPaymentMethodProcessingCenterDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMethodProcessingCenterDetail property can only contain items of type \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethodProcessingCenterDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail[] $paymentMethodProcessingCenterDetail
     * @return \App\API\SOAP\StructType\ProcessingCenters
     */
    public function setPaymentMethodProcessingCenterDetail(array $paymentMethodProcessingCenterDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodProcessingCenterDetailArrayErrorMessage = self::validatePaymentMethodProcessingCenterDetailForArrayConstraintsFromSetPaymentMethodProcessingCenterDetail($paymentMethodProcessingCenterDetail))) {
            throw new \InvalidArgumentException($paymentMethodProcessingCenterDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentMethodProcessingCenterDetail) || (is_array($paymentMethodProcessingCenterDetail) && empty($paymentMethodProcessingCenterDetail))) {
            unset($this->PaymentMethodProcessingCenterDetail);
        } else {
            $this->PaymentMethodProcessingCenterDetail = $paymentMethodProcessingCenterDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentMethodProcessingCenterDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail $item
     * @return \App\API\SOAP\StructType\ProcessingCenters
     */
    public function addToPaymentMethodProcessingCenterDetail(\App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethodProcessingCenterDetail property can only contain items of type \App\API\SOAP\StructType\PaymentMethodProcessingCenterDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMethodProcessingCenterDetail[] = $item;
        return $this;
    }
}
