<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlugInParameters StructType
 * @subpackage Structs
 */
class PlugInParameters extends AbstractStructBase
{
    /**
     * The CarrierPluginParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CarrierPluginParameter[]
     */
    public $CarrierPluginParameter;
    /**
     * Constructor method for PlugInParameters
     * @uses PlugInParameters::setCarrierPluginParameter()
     * @param \App\API\SOAP\StructType\CarrierPluginParameter[] $carrierPluginParameter
     */
    public function __construct(array $carrierPluginParameter = array())
    {
        $this
            ->setCarrierPluginParameter($carrierPluginParameter);
    }
    /**
     * Get CarrierPluginParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CarrierPluginParameter[]|null
     */
    public function getCarrierPluginParameter()
    {
        return isset($this->CarrierPluginParameter) ? $this->CarrierPluginParameter : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierPluginParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierPluginParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierPluginParameterForArrayConstraintsFromSetCarrierPluginParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $plugInParametersCarrierPluginParameterItem) {
            // validation for constraint: itemType
            if (!$plugInParametersCarrierPluginParameterItem instanceof \App\API\SOAP\StructType\CarrierPluginParameter) {
                $invalidValues[] = is_object($plugInParametersCarrierPluginParameterItem) ? get_class($plugInParametersCarrierPluginParameterItem) : sprintf('%s(%s)', gettype($plugInParametersCarrierPluginParameterItem), var_export($plugInParametersCarrierPluginParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierPluginParameter property can only contain items of type \App\API\SOAP\StructType\CarrierPluginParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierPluginParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CarrierPluginParameter[] $carrierPluginParameter
     * @return \App\API\SOAP\StructType\PlugInParameters
     */
    public function setCarrierPluginParameter(array $carrierPluginParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierPluginParameterArrayErrorMessage = self::validateCarrierPluginParameterForArrayConstraintsFromSetCarrierPluginParameter($carrierPluginParameter))) {
            throw new \InvalidArgumentException($carrierPluginParameterArrayErrorMessage, __LINE__);
        }
        if (is_null($carrierPluginParameter) || (is_array($carrierPluginParameter) && empty($carrierPluginParameter))) {
            unset($this->CarrierPluginParameter);
        } else {
            $this->CarrierPluginParameter = $carrierPluginParameter;
        }
        return $this;
    }
    /**
     * Add item to CarrierPluginParameter value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CarrierPluginParameter $item
     * @return \App\API\SOAP\StructType\PlugInParameters
     */
    public function addToCarrierPluginParameter(\App\API\SOAP\StructType\CarrierPluginParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CarrierPluginParameter) {
            throw new \InvalidArgumentException(sprintf('The CarrierPluginParameter property can only contain items of type \App\API\SOAP\StructType\CarrierPluginParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierPluginParameter[] = $item;
        return $this;
    }
}
