<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOrderDetail StructType
 * @subpackage Structs
 */
class PaymentOrderDetail extends Entity
{
    /**
     * The AppliedToOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AppliedToOrder;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OrderType;
    /**
     * Constructor method for PaymentOrderDetail
     * @uses PaymentOrderDetail::setAppliedToOrder()
     * @uses PaymentOrderDetail::setOrderNbr()
     * @uses PaymentOrderDetail::setOrderType()
     * @param \App\API\SOAP\StructType\DecimalValue $appliedToOrder
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @param \App\API\SOAP\StructType\StringValue $orderType
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $appliedToOrder = null, \App\API\SOAP\StructType\StringValue $orderNbr = null, \App\API\SOAP\StructType\StringValue $orderType = null)
    {
        $this
            ->setAppliedToOrder($appliedToOrder)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType);
    }
    /**
     * Get AppliedToOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAppliedToOrder()
    {
        return isset($this->AppliedToOrder) ? $this->AppliedToOrder : null;
    }
    /**
     * Set AppliedToOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $appliedToOrder
     * @return \App\API\SOAP\StructType\PaymentOrderDetail
     */
    public function setAppliedToOrder(\App\API\SOAP\StructType\DecimalValue $appliedToOrder = null)
    {
        if (is_null($appliedToOrder) || (is_array($appliedToOrder) && empty($appliedToOrder))) {
            unset($this->AppliedToOrder);
        } else {
            $this->AppliedToOrder = $appliedToOrder;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderNbr
     * @return \App\API\SOAP\StructType\PaymentOrderDetail
     */
    public function setOrderNbr(\App\API\SOAP\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $orderType
     * @return \App\API\SOAP\StructType\PaymentOrderDetail
     */
    public function setOrderType(\App\API\SOAP\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
}
