<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod StructType
 * @subpackage Structs
 */
class PaymentMethod extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Active;
    /**
     * The AllowedCashAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AllowedCashAccounts
     */
    public $AllowedCashAccounts;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The IntegratedProcessing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IntegratedProcessing;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MeansOfPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $MeansOfPayment;
    /**
     * The PaymentMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentMethodID;
    /**
     * The ProcessingCenters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProcessingCenters
     */
    public $ProcessingCenters;
    /**
     * The RequireRemittanceInformationforCashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $RequireRemittanceInformationforCashAccount;
    /**
     * The UseInAP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $UseInAP;
    /**
     * The UseInAR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $UseInAR;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setActive()
     * @uses PaymentMethod::setAllowedCashAccounts()
     * @uses PaymentMethod::setCreatedDateTime()
     * @uses PaymentMethod::setDescription()
     * @uses PaymentMethod::setIntegratedProcessing()
     * @uses PaymentMethod::setLastModifiedDateTime()
     * @uses PaymentMethod::setMeansOfPayment()
     * @uses PaymentMethod::setPaymentMethodID()
     * @uses PaymentMethod::setProcessingCenters()
     * @uses PaymentMethod::setRequireRemittanceInformationforCashAccount()
     * @uses PaymentMethod::setUseInAP()
     * @uses PaymentMethod::setUseInAR()
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @param \App\API\SOAP\StructType\AllowedCashAccounts $allowedCashAccounts
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\BooleanValue $integratedProcessing
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\StringValue $meansOfPayment
     * @param \App\API\SOAP\StructType\StringValue $paymentMethodID
     * @param \App\API\SOAP\StructType\ProcessingCenters $processingCenters
     * @param \App\API\SOAP\StructType\BooleanValue $requireRemittanceInformationforCashAccount
     * @param \App\API\SOAP\StructType\BooleanValue $useInAP
     * @param \App\API\SOAP\StructType\BooleanValue $useInAR
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $active = null, \App\API\SOAP\StructType\AllowedCashAccounts $allowedCashAccounts = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\BooleanValue $integratedProcessing = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\StringValue $meansOfPayment = null, \App\API\SOAP\StructType\StringValue $paymentMethodID = null, \App\API\SOAP\StructType\ProcessingCenters $processingCenters = null, \App\API\SOAP\StructType\BooleanValue $requireRemittanceInformationforCashAccount = null, \App\API\SOAP\StructType\BooleanValue $useInAP = null, \App\API\SOAP\StructType\BooleanValue $useInAR = null)
    {
        $this
            ->setActive($active)
            ->setAllowedCashAccounts($allowedCashAccounts)
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setIntegratedProcessing($integratedProcessing)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMeansOfPayment($meansOfPayment)
            ->setPaymentMethodID($paymentMethodID)
            ->setProcessingCenters($processingCenters)
            ->setRequireRemittanceInformationforCashAccount($requireRemittanceInformationforCashAccount)
            ->setUseInAP($useInAP)
            ->setUseInAR($useInAR);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setActive(\App\API\SOAP\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AllowedCashAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AllowedCashAccounts|null
     */
    public function getAllowedCashAccounts()
    {
        return isset($this->AllowedCashAccounts) ? $this->AllowedCashAccounts : null;
    }
    /**
     * Set AllowedCashAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\AllowedCashAccounts $allowedCashAccounts
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setAllowedCashAccounts(\App\API\SOAP\StructType\AllowedCashAccounts $allowedCashAccounts = null)
    {
        if (is_null($allowedCashAccounts) || (is_array($allowedCashAccounts) && empty($allowedCashAccounts))) {
            unset($this->AllowedCashAccounts);
        } else {
            $this->AllowedCashAccounts = $allowedCashAccounts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IntegratedProcessing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIntegratedProcessing()
    {
        return isset($this->IntegratedProcessing) ? $this->IntegratedProcessing : null;
    }
    /**
     * Set IntegratedProcessing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $integratedProcessing
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setIntegratedProcessing(\App\API\SOAP\StructType\BooleanValue $integratedProcessing = null)
    {
        if (is_null($integratedProcessing) || (is_array($integratedProcessing) && empty($integratedProcessing))) {
            unset($this->IntegratedProcessing);
        } else {
            $this->IntegratedProcessing = $integratedProcessing;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MeansOfPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getMeansOfPayment()
    {
        return isset($this->MeansOfPayment) ? $this->MeansOfPayment : null;
    }
    /**
     * Set MeansOfPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $meansOfPayment
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setMeansOfPayment(\App\API\SOAP\StructType\StringValue $meansOfPayment = null)
    {
        if (is_null($meansOfPayment) || (is_array($meansOfPayment) && empty($meansOfPayment))) {
            unset($this->MeansOfPayment);
        } else {
            $this->MeansOfPayment = $meansOfPayment;
        }
        return $this;
    }
    /**
     * Get PaymentMethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentMethodID()
    {
        return isset($this->PaymentMethodID) ? $this->PaymentMethodID : null;
    }
    /**
     * Set PaymentMethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentMethodID
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setPaymentMethodID(\App\API\SOAP\StructType\StringValue $paymentMethodID = null)
    {
        if (is_null($paymentMethodID) || (is_array($paymentMethodID) && empty($paymentMethodID))) {
            unset($this->PaymentMethodID);
        } else {
            $this->PaymentMethodID = $paymentMethodID;
        }
        return $this;
    }
    /**
     * Get ProcessingCenters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProcessingCenters|null
     */
    public function getProcessingCenters()
    {
        return isset($this->ProcessingCenters) ? $this->ProcessingCenters : null;
    }
    /**
     * Set ProcessingCenters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ProcessingCenters $processingCenters
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setProcessingCenters(\App\API\SOAP\StructType\ProcessingCenters $processingCenters = null)
    {
        if (is_null($processingCenters) || (is_array($processingCenters) && empty($processingCenters))) {
            unset($this->ProcessingCenters);
        } else {
            $this->ProcessingCenters = $processingCenters;
        }
        return $this;
    }
    /**
     * Get RequireRemittanceInformationforCashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getRequireRemittanceInformationforCashAccount()
    {
        return isset($this->RequireRemittanceInformationforCashAccount) ? $this->RequireRemittanceInformationforCashAccount : null;
    }
    /**
     * Set RequireRemittanceInformationforCashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $requireRemittanceInformationforCashAccount
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setRequireRemittanceInformationforCashAccount(\App\API\SOAP\StructType\BooleanValue $requireRemittanceInformationforCashAccount = null)
    {
        if (is_null($requireRemittanceInformationforCashAccount) || (is_array($requireRemittanceInformationforCashAccount) && empty($requireRemittanceInformationforCashAccount))) {
            unset($this->RequireRemittanceInformationforCashAccount);
        } else {
            $this->RequireRemittanceInformationforCashAccount = $requireRemittanceInformationforCashAccount;
        }
        return $this;
    }
    /**
     * Get UseInAP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getUseInAP()
    {
        return isset($this->UseInAP) ? $this->UseInAP : null;
    }
    /**
     * Set UseInAP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $useInAP
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setUseInAP(\App\API\SOAP\StructType\BooleanValue $useInAP = null)
    {
        if (is_null($useInAP) || (is_array($useInAP) && empty($useInAP))) {
            unset($this->UseInAP);
        } else {
            $this->UseInAP = $useInAP;
        }
        return $this;
    }
    /**
     * Get UseInAR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getUseInAR()
    {
        return isset($this->UseInAR) ? $this->UseInAR : null;
    }
    /**
     * Set UseInAR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $useInAR
     * @return \App\API\SOAP\StructType\PaymentMethod
     */
    public function setUseInAR(\App\API\SOAP\StructType\BooleanValue $useInAR = null)
    {
        if (is_null($useInAR) || (is_array($useInAR) && empty($useInAR))) {
            unset($this->UseInAR);
        } else {
            $this->UseInAR = $useInAR;
        }
        return $this;
    }
}
