<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentLoadOrders StructType
 * @subpackage Structs
 */
class PaymentLoadOrders extends Action
{
    /**
     * The EndOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EndOrderNbr;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The MaxDocs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $MaxDocs;
    /**
     * The SOOrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SOOrderBy;
    /**
     * The StartOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StartOrderNbr;
    /**
     * The TillDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $TillDate;
    /**
     * Constructor method for PaymentLoadOrders
     * @uses PaymentLoadOrders::setEndOrderNbr()
     * @uses PaymentLoadOrders::setFromDate()
     * @uses PaymentLoadOrders::setMaxDocs()
     * @uses PaymentLoadOrders::setSOOrderBy()
     * @uses PaymentLoadOrders::setStartOrderNbr()
     * @uses PaymentLoadOrders::setTillDate()
     * @param \App\API\SOAP\StructType\StringValue $endOrderNbr
     * @param \App\API\SOAP\StructType\DateTimeValue $fromDate
     * @param \App\API\SOAP\StructType\IntValue $maxDocs
     * @param \App\API\SOAP\StructType\StringValue $sOOrderBy
     * @param \App\API\SOAP\StructType\StringValue $startOrderNbr
     * @param \App\API\SOAP\StructType\DateTimeValue $tillDate
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $endOrderNbr = null, \App\API\SOAP\StructType\DateTimeValue $fromDate = null, \App\API\SOAP\StructType\IntValue $maxDocs = null, \App\API\SOAP\StructType\StringValue $sOOrderBy = null, \App\API\SOAP\StructType\StringValue $startOrderNbr = null, \App\API\SOAP\StructType\DateTimeValue $tillDate = null)
    {
        $this
            ->setEndOrderNbr($endOrderNbr)
            ->setFromDate($fromDate)
            ->setMaxDocs($maxDocs)
            ->setSOOrderBy($sOOrderBy)
            ->setStartOrderNbr($startOrderNbr)
            ->setTillDate($tillDate);
    }
    /**
     * Get EndOrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEndOrderNbr()
    {
        return isset($this->EndOrderNbr) ? $this->EndOrderNbr : null;
    }
    /**
     * Set EndOrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $endOrderNbr
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setEndOrderNbr(\App\API\SOAP\StructType\StringValue $endOrderNbr = null)
    {
        if (is_null($endOrderNbr) || (is_array($endOrderNbr) && empty($endOrderNbr))) {
            unset($this->EndOrderNbr);
        } else {
            $this->EndOrderNbr = $endOrderNbr;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $fromDate
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setFromDate(\App\API\SOAP\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get MaxDocs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getMaxDocs()
    {
        return isset($this->MaxDocs) ? $this->MaxDocs : null;
    }
    /**
     * Set MaxDocs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $maxDocs
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setMaxDocs(\App\API\SOAP\StructType\IntValue $maxDocs = null)
    {
        if (is_null($maxDocs) || (is_array($maxDocs) && empty($maxDocs))) {
            unset($this->MaxDocs);
        } else {
            $this->MaxDocs = $maxDocs;
        }
        return $this;
    }
    /**
     * Get SOOrderBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSOOrderBy()
    {
        return isset($this->SOOrderBy) ? $this->SOOrderBy : null;
    }
    /**
     * Set SOOrderBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $sOOrderBy
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setSOOrderBy(\App\API\SOAP\StructType\StringValue $sOOrderBy = null)
    {
        if (is_null($sOOrderBy) || (is_array($sOOrderBy) && empty($sOOrderBy))) {
            unset($this->SOOrderBy);
        } else {
            $this->SOOrderBy = $sOOrderBy;
        }
        return $this;
    }
    /**
     * Get StartOrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStartOrderNbr()
    {
        return isset($this->StartOrderNbr) ? $this->StartOrderNbr : null;
    }
    /**
     * Set StartOrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $startOrderNbr
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setStartOrderNbr(\App\API\SOAP\StructType\StringValue $startOrderNbr = null)
    {
        if (is_null($startOrderNbr) || (is_array($startOrderNbr) && empty($startOrderNbr))) {
            unset($this->StartOrderNbr);
        } else {
            $this->StartOrderNbr = $startOrderNbr;
        }
        return $this;
    }
    /**
     * Get TillDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getTillDate()
    {
        return isset($this->TillDate) ? $this->TillDate : null;
    }
    /**
     * Set TillDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $tillDate
     * @return \App\API\SOAP\StructType\PaymentLoadOrders
     */
    public function setTillDate(\App\API\SOAP\StructType\DateTimeValue $tillDate = null)
    {
        if (is_null($tillDate) || (is_array($tillDate) && empty($tillDate))) {
            unset($this->TillDate);
        } else {
            $this->TillDate = $tillDate;
        }
        return $this;
    }
}
