<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInstructions StructType
 * @subpackage Structs
 */
class PaymentInstructions extends AbstractStructBase
{
    /**
     * The BusinessAccountPaymentInstructionDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail[]
     */
    public $BusinessAccountPaymentInstructionDetail;
    /**
     * Constructor method for PaymentInstructions
     * @uses PaymentInstructions::setBusinessAccountPaymentInstructionDetail()
     * @param \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail[] $businessAccountPaymentInstructionDetail
     */
    public function __construct(array $businessAccountPaymentInstructionDetail = array())
    {
        $this
            ->setBusinessAccountPaymentInstructionDetail($businessAccountPaymentInstructionDetail);
    }
    /**
     * Get BusinessAccountPaymentInstructionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail[]|null
     */
    public function getBusinessAccountPaymentInstructionDetail()
    {
        return isset($this->BusinessAccountPaymentInstructionDetail) ? $this->BusinessAccountPaymentInstructionDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountPaymentInstructionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountPaymentInstructionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountPaymentInstructionDetailForArrayConstraintsFromSetBusinessAccountPaymentInstructionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInstructionsBusinessAccountPaymentInstructionDetailItem) {
            // validation for constraint: itemType
            if (!$paymentInstructionsBusinessAccountPaymentInstructionDetailItem instanceof \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail) {
                $invalidValues[] = is_object($paymentInstructionsBusinessAccountPaymentInstructionDetailItem) ? get_class($paymentInstructionsBusinessAccountPaymentInstructionDetailItem) : sprintf('%s(%s)', gettype($paymentInstructionsBusinessAccountPaymentInstructionDetailItem), var_export($paymentInstructionsBusinessAccountPaymentInstructionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountPaymentInstructionDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountPaymentInstructionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail[] $businessAccountPaymentInstructionDetail
     * @return \App\API\SOAP\StructType\PaymentInstructions
     */
    public function setBusinessAccountPaymentInstructionDetail(array $businessAccountPaymentInstructionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountPaymentInstructionDetailArrayErrorMessage = self::validateBusinessAccountPaymentInstructionDetailForArrayConstraintsFromSetBusinessAccountPaymentInstructionDetail($businessAccountPaymentInstructionDetail))) {
            throw new \InvalidArgumentException($businessAccountPaymentInstructionDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountPaymentInstructionDetail) || (is_array($businessAccountPaymentInstructionDetail) && empty($businessAccountPaymentInstructionDetail))) {
            unset($this->BusinessAccountPaymentInstructionDetail);
        } else {
            $this->BusinessAccountPaymentInstructionDetail = $businessAccountPaymentInstructionDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountPaymentInstructionDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail $item
     * @return \App\API\SOAP\StructType\PaymentInstructions
     */
    public function addToBusinessAccountPaymentInstructionDetail(\App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountPaymentInstructionDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountPaymentInstructionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountPaymentInstructionDetail[] = $item;
        return $this;
    }
}
