<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends Entity
{
    /**
     * The ApplicationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ApplicationDate;
    /**
     * The ApplicationHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ApplicationHistory
     */
    public $ApplicationHistory;
    /**
     * The AppliedToDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AppliedToDocuments;
    /**
     * The CardAccountNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $CardAccountNbr;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CreditCardProcessingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CreditCardProcessingInfo
     */
    public $CreditCardProcessingInfo;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DocumentsToApply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DocumentsToApply
     */
    public $DocumentsToApply;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The OrdersToApply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\OrdersToApply
     */
    public $OrdersToApply;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for Payment
     * @uses Payment::setApplicationDate()
     * @uses Payment::setApplicationHistory()
     * @uses Payment::setAppliedToDocuments()
     * @uses Payment::setCardAccountNbr()
     * @uses Payment::setCashAccount()
     * @uses Payment::setCreditCardProcessingInfo()
     * @uses Payment::setCurrencyID()
     * @uses Payment::setCustomerID()
     * @uses Payment::setDescription()
     * @uses Payment::setDocumentsToApply()
     * @uses Payment::setHold()
     * @uses Payment::setOrdersToApply()
     * @uses Payment::setPaymentAmount()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setPaymentRef()
     * @uses Payment::setReferenceNbr()
     * @uses Payment::setStatus()
     * @uses Payment::setType()
     * @param \App\API\SOAP\StructType\DateTimeValue $applicationDate
     * @param \App\API\SOAP\StructType\ApplicationHistory $applicationHistory
     * @param \App\API\SOAP\StructType\DecimalValue $appliedToDocuments
     * @param \App\API\SOAP\StructType\IntValue $cardAccountNbr
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @param \App\API\SOAP\StructType\CreditCardProcessingInfo $creditCardProcessingInfo
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DocumentsToApply $documentsToApply
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\OrdersToApply $ordersToApply
     * @param \App\API\SOAP\StructType\DecimalValue $paymentAmount
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $type
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $applicationDate = null, \App\API\SOAP\StructType\ApplicationHistory $applicationHistory = null, \App\API\SOAP\StructType\DecimalValue $appliedToDocuments = null, \App\API\SOAP\StructType\IntValue $cardAccountNbr = null, \App\API\SOAP\StructType\StringValue $cashAccount = null, \App\API\SOAP\StructType\CreditCardProcessingInfo $creditCardProcessingInfo = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DocumentsToApply $documentsToApply = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\OrdersToApply $ordersToApply = null, \App\API\SOAP\StructType\DecimalValue $paymentAmount = null, \App\API\SOAP\StructType\StringValue $paymentMethod = null, \App\API\SOAP\StructType\StringValue $paymentRef = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $type = null)
    {
        $this
            ->setApplicationDate($applicationDate)
            ->setApplicationHistory($applicationHistory)
            ->setAppliedToDocuments($appliedToDocuments)
            ->setCardAccountNbr($cardAccountNbr)
            ->setCashAccount($cashAccount)
            ->setCreditCardProcessingInfo($creditCardProcessingInfo)
            ->setCurrencyID($currencyID)
            ->setCustomerID($customerID)
            ->setDescription($description)
            ->setDocumentsToApply($documentsToApply)
            ->setHold($hold)
            ->setOrdersToApply($ordersToApply)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setType($type);
    }
    /**
     * Get ApplicationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getApplicationDate()
    {
        return isset($this->ApplicationDate) ? $this->ApplicationDate : null;
    }
    /**
     * Set ApplicationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $applicationDate
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setApplicationDate(\App\API\SOAP\StructType\DateTimeValue $applicationDate = null)
    {
        if (is_null($applicationDate) || (is_array($applicationDate) && empty($applicationDate))) {
            unset($this->ApplicationDate);
        } else {
            $this->ApplicationDate = $applicationDate;
        }
        return $this;
    }
    /**
     * Get ApplicationHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ApplicationHistory|null
     */
    public function getApplicationHistory()
    {
        return isset($this->ApplicationHistory) ? $this->ApplicationHistory : null;
    }
    /**
     * Set ApplicationHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ApplicationHistory $applicationHistory
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setApplicationHistory(\App\API\SOAP\StructType\ApplicationHistory $applicationHistory = null)
    {
        if (is_null($applicationHistory) || (is_array($applicationHistory) && empty($applicationHistory))) {
            unset($this->ApplicationHistory);
        } else {
            $this->ApplicationHistory = $applicationHistory;
        }
        return $this;
    }
    /**
     * Get AppliedToDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAppliedToDocuments()
    {
        return isset($this->AppliedToDocuments) ? $this->AppliedToDocuments : null;
    }
    /**
     * Set AppliedToDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $appliedToDocuments
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setAppliedToDocuments(\App\API\SOAP\StructType\DecimalValue $appliedToDocuments = null)
    {
        if (is_null($appliedToDocuments) || (is_array($appliedToDocuments) && empty($appliedToDocuments))) {
            unset($this->AppliedToDocuments);
        } else {
            $this->AppliedToDocuments = $appliedToDocuments;
        }
        return $this;
    }
    /**
     * Get CardAccountNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getCardAccountNbr()
    {
        return isset($this->CardAccountNbr) ? $this->CardAccountNbr : null;
    }
    /**
     * Set CardAccountNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $cardAccountNbr
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setCardAccountNbr(\App\API\SOAP\StructType\IntValue $cardAccountNbr = null)
    {
        if (is_null($cardAccountNbr) || (is_array($cardAccountNbr) && empty($cardAccountNbr))) {
            unset($this->CardAccountNbr);
        } else {
            $this->CardAccountNbr = $cardAccountNbr;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setCashAccount(\App\API\SOAP\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CreditCardProcessingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CreditCardProcessingInfo|null
     */
    public function getCreditCardProcessingInfo()
    {
        return isset($this->CreditCardProcessingInfo) ? $this->CreditCardProcessingInfo : null;
    }
    /**
     * Set CreditCardProcessingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\CreditCardProcessingInfo $creditCardProcessingInfo
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setCreditCardProcessingInfo(\App\API\SOAP\StructType\CreditCardProcessingInfo $creditCardProcessingInfo = null)
    {
        if (is_null($creditCardProcessingInfo) || (is_array($creditCardProcessingInfo) && empty($creditCardProcessingInfo))) {
            unset($this->CreditCardProcessingInfo);
        } else {
            $this->CreditCardProcessingInfo = $creditCardProcessingInfo;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DocumentsToApply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DocumentsToApply|null
     */
    public function getDocumentsToApply()
    {
        return isset($this->DocumentsToApply) ? $this->DocumentsToApply : null;
    }
    /**
     * Set DocumentsToApply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DocumentsToApply $documentsToApply
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setDocumentsToApply(\App\API\SOAP\StructType\DocumentsToApply $documentsToApply = null)
    {
        if (is_null($documentsToApply) || (is_array($documentsToApply) && empty($documentsToApply))) {
            unset($this->DocumentsToApply);
        } else {
            $this->DocumentsToApply = $documentsToApply;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get OrdersToApply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\OrdersToApply|null
     */
    public function getOrdersToApply()
    {
        return isset($this->OrdersToApply) ? $this->OrdersToApply : null;
    }
    /**
     * Set OrdersToApply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\OrdersToApply $ordersToApply
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setOrdersToApply(\App\API\SOAP\StructType\OrdersToApply $ordersToApply = null)
    {
        if (is_null($ordersToApply) || (is_array($ordersToApply) && empty($ordersToApply))) {
            unset($this->OrdersToApply);
        } else {
            $this->OrdersToApply = $ordersToApply;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $paymentAmount
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setPaymentAmount(\App\API\SOAP\StructType\DecimalValue $paymentAmount = null)
    {
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setPaymentMethod(\App\API\SOAP\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setPaymentRef(\App\API\SOAP\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\Payment
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
