<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Packages StructType
 * @subpackage Structs
 */
class Packages extends AbstractStructBase
{
    /**
     * The ShippingBox
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShippingBox[]
     */
    public $ShippingBox;
    /**
     * The ShipmentPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShipmentPackage[]
     */
    public $ShipmentPackage;
    /**
     * Constructor method for Packages
     * @uses Packages::setShippingBox()
     * @uses Packages::setShipmentPackage()
     * @param \App\API\SOAP\StructType\ShippingBox[] $shippingBox
     * @param \App\API\SOAP\StructType\ShipmentPackage[] $shipmentPackage
     */
    public function __construct(array $shippingBox = array(), array $shipmentPackage = array())
    {
        $this
            ->setShippingBox($shippingBox)
            ->setShipmentPackage($shipmentPackage);
    }
    /**
     * Get ShippingBox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShippingBox[]|null
     */
    public function getShippingBox()
    {
        return isset($this->ShippingBox) ? $this->ShippingBox : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingBox method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingBox method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingBoxForArrayConstraintsFromSetShippingBox(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagesShippingBoxItem) {
            // validation for constraint: itemType
            if (!$packagesShippingBoxItem instanceof \App\API\SOAP\StructType\ShippingBox) {
                $invalidValues[] = is_object($packagesShippingBoxItem) ? get_class($packagesShippingBoxItem) : sprintf('%s(%s)', gettype($packagesShippingBoxItem), var_export($packagesShippingBoxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingBox property can only contain items of type \App\API\SOAP\StructType\ShippingBox, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingBox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShippingBox[] $shippingBox
     * @return \App\API\SOAP\StructType\Packages
     */
    public function setShippingBox(array $shippingBox = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingBoxArrayErrorMessage = self::validateShippingBoxForArrayConstraintsFromSetShippingBox($shippingBox))) {
            throw new \InvalidArgumentException($shippingBoxArrayErrorMessage, __LINE__);
        }
        if (is_null($shippingBox) || (is_array($shippingBox) && empty($shippingBox))) {
            unset($this->ShippingBox);
        } else {
            $this->ShippingBox = $shippingBox;
        }
        return $this;
    }
    /**
     * Add item to ShippingBox value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShippingBox $item
     * @return \App\API\SOAP\StructType\Packages
     */
    public function addToShippingBox(\App\API\SOAP\StructType\ShippingBox $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShippingBox) {
            throw new \InvalidArgumentException(sprintf('The ShippingBox property can only contain items of type \App\API\SOAP\StructType\ShippingBox, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingBox[] = $item;
        return $this;
    }
    /**
     * Get ShipmentPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShipmentPackage[]|null
     */
    public function getShipmentPackage()
    {
        return isset($this->ShipmentPackage) ? $this->ShipmentPackage : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentPackageForArrayConstraintsFromSetShipmentPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagesShipmentPackageItem) {
            // validation for constraint: itemType
            if (!$packagesShipmentPackageItem instanceof \App\API\SOAP\StructType\ShipmentPackage) {
                $invalidValues[] = is_object($packagesShipmentPackageItem) ? get_class($packagesShipmentPackageItem) : sprintf('%s(%s)', gettype($packagesShipmentPackageItem), var_export($packagesShipmentPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentPackage property can only contain items of type \App\API\SOAP\StructType\ShipmentPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentPackage[] $shipmentPackage
     * @return \App\API\SOAP\StructType\Packages
     */
    public function setShipmentPackage(array $shipmentPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentPackageArrayErrorMessage = self::validateShipmentPackageForArrayConstraintsFromSetShipmentPackage($shipmentPackage))) {
            throw new \InvalidArgumentException($shipmentPackageArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentPackage) || (is_array($shipmentPackage) && empty($shipmentPackage))) {
            unset($this->ShipmentPackage);
        } else {
            $this->ShipmentPackage = $shipmentPackage;
        }
        return $this;
    }
    /**
     * Add item to ShipmentPackage value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentPackage $item
     * @return \App\API\SOAP\StructType\Packages
     */
    public function addToShipmentPackage(\App\API\SOAP\StructType\ShipmentPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShipmentPackage) {
            throw new \InvalidArgumentException(sprintf('The ShipmentPackage property can only contain items of type \App\API\SOAP\StructType\ShipmentPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentPackage[] = $item;
        return $this;
    }
}
