<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersToApply StructType
 * @subpackage Structs
 */
class OrdersToApply extends AbstractStructBase
{
    /**
     * The PaymentOrderDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PaymentOrderDetail[]
     */
    public $PaymentOrderDetail;
    /**
     * Constructor method for OrdersToApply
     * @uses OrdersToApply::setPaymentOrderDetail()
     * @param \App\API\SOAP\StructType\PaymentOrderDetail[] $paymentOrderDetail
     */
    public function __construct(array $paymentOrderDetail = array())
    {
        $this
            ->setPaymentOrderDetail($paymentOrderDetail);
    }
    /**
     * Get PaymentOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PaymentOrderDetail[]|null
     */
    public function getPaymentOrderDetail()
    {
        return isset($this->PaymentOrderDetail) ? $this->PaymentOrderDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentOrderDetailForArrayConstraintsFromSetPaymentOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ordersToApplyPaymentOrderDetailItem) {
            // validation for constraint: itemType
            if (!$ordersToApplyPaymentOrderDetailItem instanceof \App\API\SOAP\StructType\PaymentOrderDetail) {
                $invalidValues[] = is_object($ordersToApplyPaymentOrderDetailItem) ? get_class($ordersToApplyPaymentOrderDetailItem) : sprintf('%s(%s)', gettype($ordersToApplyPaymentOrderDetailItem), var_export($ordersToApplyPaymentOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentOrderDetail property can only contain items of type \App\API\SOAP\StructType\PaymentOrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PaymentOrderDetail[] $paymentOrderDetail
     * @return \App\API\SOAP\StructType\OrdersToApply
     */
    public function setPaymentOrderDetail(array $paymentOrderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentOrderDetailArrayErrorMessage = self::validatePaymentOrderDetailForArrayConstraintsFromSetPaymentOrderDetail($paymentOrderDetail))) {
            throw new \InvalidArgumentException($paymentOrderDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentOrderDetail) || (is_array($paymentOrderDetail) && empty($paymentOrderDetail))) {
            unset($this->PaymentOrderDetail);
        } else {
            $this->PaymentOrderDetail = $paymentOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentOrderDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PaymentOrderDetail $item
     * @return \App\API\SOAP\StructType\OrdersToApply
     */
    public function addToPaymentOrderDetail(\App\API\SOAP\StructType\PaymentOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PaymentOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentOrderDetail property can only contain items of type \App\API\SOAP\StructType\PaymentOrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentOrderDetail[] = $item;
        return $this;
    }
}
