<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opportunity StructType
 * @subpackage Structs
 */
class Opportunity extends Entity
{
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Activities
     */
    public $Activities;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $Address;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Attributes
     */
    public $Attributes;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The BusinessAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BusinessAccount;
    /**
     * The ClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ClassID;
    /**
     * The ContactDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ContactDisplayName;
    /**
     * The ContactID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $ContactID;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\OpportunityContact
     */
    public $ContactInformation;
    /**
     * The ConvertedLeadDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ConvertedLeadDisplayName;
    /**
     * The ConvertedLeadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $ConvertedLeadID;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyViewState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CurrencyViewState;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Details;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Discount;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Discounts
     */
    public $Discounts;
    /**
     * The Estimation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Estimation;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Location;
    /**
     * The ManualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ManualAmount;
    /**
     * The OpportunityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OpportunityID;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Override;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Owner;
    /**
     * The OwnerEmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OwnerEmployeeName;
    /**
     * The ParentAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ParentAccount;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Products
     */
    public $Products;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Reason;
    /**
     * The Relations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Relations
     */
    public $Relations;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Source;
    /**
     * The SourceCampaign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SourceCampaign;
    /**
     * The Stage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Stage;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subject;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Total;
    /**
     * The WeightTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $WeightTotal;
    /**
     * The WorkgroupDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WorkgroupDescription;
    /**
     * The WorkgroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WorkgroupID;
    /**
     * Constructor method for Opportunity
     * @uses Opportunity::setActivities()
     * @uses Opportunity::setAddress()
     * @uses Opportunity::setAmount()
     * @uses Opportunity::setAttributes()
     * @uses Opportunity::setBranch()
     * @uses Opportunity::setBusinessAccount()
     * @uses Opportunity::setClassID()
     * @uses Opportunity::setContactDisplayName()
     * @uses Opportunity::setContactID()
     * @uses Opportunity::setContactInformation()
     * @uses Opportunity::setConvertedLeadDisplayName()
     * @uses Opportunity::setConvertedLeadID()
     * @uses Opportunity::setCurrencyID()
     * @uses Opportunity::setCurrencyViewState()
     * @uses Opportunity::setDetails()
     * @uses Opportunity::setDiscount()
     * @uses Opportunity::setDiscounts()
     * @uses Opportunity::setEstimation()
     * @uses Opportunity::setLocation()
     * @uses Opportunity::setManualAmount()
     * @uses Opportunity::setOpportunityID()
     * @uses Opportunity::setOverride()
     * @uses Opportunity::setOwner()
     * @uses Opportunity::setOwnerEmployeeName()
     * @uses Opportunity::setParentAccount()
     * @uses Opportunity::setProducts()
     * @uses Opportunity::setProject()
     * @uses Opportunity::setReason()
     * @uses Opportunity::setRelations()
     * @uses Opportunity::setSource()
     * @uses Opportunity::setSourceCampaign()
     * @uses Opportunity::setStage()
     * @uses Opportunity::setStatus()
     * @uses Opportunity::setSubject()
     * @uses Opportunity::setTaxDetails()
     * @uses Opportunity::setTaxZone()
     * @uses Opportunity::setTotal()
     * @uses Opportunity::setWeightTotal()
     * @uses Opportunity::setWorkgroupDescription()
     * @uses Opportunity::setWorkgroupID()
     * @param \App\API\SOAP\StructType\Activities $activities
     * @param \App\API\SOAP\StructType\Address $address
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\StringValue $businessAccount
     * @param \App\API\SOAP\StructType\StringValue $classID
     * @param \App\API\SOAP\StructType\StringValue $contactDisplayName
     * @param \App\API\SOAP\StructType\IntValue $contactID
     * @param \App\API\SOAP\StructType\OpportunityContact $contactInformation
     * @param \App\API\SOAP\StructType\StringValue $convertedLeadDisplayName
     * @param \App\API\SOAP\StructType\IntValue $convertedLeadID
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\BooleanValue $currencyViewState
     * @param \App\API\SOAP\StructType\StringValue $details
     * @param \App\API\SOAP\StructType\DecimalValue $discount
     * @param \App\API\SOAP\StructType\Discounts $discounts
     * @param \App\API\SOAP\StructType\DateTimeValue $estimation
     * @param \App\API\SOAP\StructType\StringValue $location
     * @param \App\API\SOAP\StructType\BooleanValue $manualAmount
     * @param \App\API\SOAP\StructType\StringValue $opportunityID
     * @param \App\API\SOAP\StructType\BooleanValue $override
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @param \App\API\SOAP\StructType\StringValue $ownerEmployeeName
     * @param \App\API\SOAP\StructType\StringValue $parentAccount
     * @param \App\API\SOAP\StructType\Products $products
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $reason
     * @param \App\API\SOAP\StructType\Relations $relations
     * @param \App\API\SOAP\StructType\StringValue $source
     * @param \App\API\SOAP\StructType\StringValue $sourceCampaign
     * @param \App\API\SOAP\StructType\StringValue $stage
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $subject
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @param \App\API\SOAP\StructType\DecimalValue $total
     * @param \App\API\SOAP\StructType\DecimalValue $weightTotal
     * @param \App\API\SOAP\StructType\StringValue $workgroupDescription
     * @param \App\API\SOAP\StructType\StringValue $workgroupID
     */
    public function __construct(\App\API\SOAP\StructType\Activities $activities = null, \App\API\SOAP\StructType\Address $address = null, \App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\Attributes $attributes = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\StringValue $businessAccount = null, \App\API\SOAP\StructType\StringValue $classID = null, \App\API\SOAP\StructType\StringValue $contactDisplayName = null, \App\API\SOAP\StructType\IntValue $contactID = null, \App\API\SOAP\StructType\OpportunityContact $contactInformation = null, \App\API\SOAP\StructType\StringValue $convertedLeadDisplayName = null, \App\API\SOAP\StructType\IntValue $convertedLeadID = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\BooleanValue $currencyViewState = null, \App\API\SOAP\StructType\StringValue $details = null, \App\API\SOAP\StructType\DecimalValue $discount = null, \App\API\SOAP\StructType\Discounts $discounts = null, \App\API\SOAP\StructType\DateTimeValue $estimation = null, \App\API\SOAP\StructType\StringValue $location = null, \App\API\SOAP\StructType\BooleanValue $manualAmount = null, \App\API\SOAP\StructType\StringValue $opportunityID = null, \App\API\SOAP\StructType\BooleanValue $override = null, \App\API\SOAP\StructType\StringValue $owner = null, \App\API\SOAP\StructType\StringValue $ownerEmployeeName = null, \App\API\SOAP\StructType\StringValue $parentAccount = null, \App\API\SOAP\StructType\Products $products = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $reason = null, \App\API\SOAP\StructType\Relations $relations = null, \App\API\SOAP\StructType\StringValue $source = null, \App\API\SOAP\StructType\StringValue $sourceCampaign = null, \App\API\SOAP\StructType\StringValue $stage = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $subject = null, \App\API\SOAP\StructType\TaxDetails $taxDetails = null, \App\API\SOAP\StructType\StringValue $taxZone = null, \App\API\SOAP\StructType\DecimalValue $total = null, \App\API\SOAP\StructType\DecimalValue $weightTotal = null, \App\API\SOAP\StructType\StringValue $workgroupDescription = null, \App\API\SOAP\StructType\StringValue $workgroupID = null)
    {
        $this
            ->setActivities($activities)
            ->setAddress($address)
            ->setAmount($amount)
            ->setAttributes($attributes)
            ->setBranch($branch)
            ->setBusinessAccount($businessAccount)
            ->setClassID($classID)
            ->setContactDisplayName($contactDisplayName)
            ->setContactID($contactID)
            ->setContactInformation($contactInformation)
            ->setConvertedLeadDisplayName($convertedLeadDisplayName)
            ->setConvertedLeadID($convertedLeadID)
            ->setCurrencyID($currencyID)
            ->setCurrencyViewState($currencyViewState)
            ->setDetails($details)
            ->setDiscount($discount)
            ->setDiscounts($discounts)
            ->setEstimation($estimation)
            ->setLocation($location)
            ->setManualAmount($manualAmount)
            ->setOpportunityID($opportunityID)
            ->setOverride($override)
            ->setOwner($owner)
            ->setOwnerEmployeeName($ownerEmployeeName)
            ->setParentAccount($parentAccount)
            ->setProducts($products)
            ->setProject($project)
            ->setReason($reason)
            ->setRelations($relations)
            ->setSource($source)
            ->setSourceCampaign($sourceCampaign)
            ->setStage($stage)
            ->setStatus($status)
            ->setSubject($subject)
            ->setTaxDetails($taxDetails)
            ->setTaxZone($taxZone)
            ->setTotal($total)
            ->setWeightTotal($weightTotal)
            ->setWorkgroupDescription($workgroupDescription)
            ->setWorkgroupID($workgroupID);
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Activities|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Activities $activities
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setActivities(\App\API\SOAP\StructType\Activities $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $address
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setAddress(\App\API\SOAP\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setAttributes(\App\API\SOAP\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get BusinessAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBusinessAccount()
    {
        return isset($this->BusinessAccount) ? $this->BusinessAccount : null;
    }
    /**
     * Set BusinessAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $businessAccount
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setBusinessAccount(\App\API\SOAP\StructType\StringValue $businessAccount = null)
    {
        if (is_null($businessAccount) || (is_array($businessAccount) && empty($businessAccount))) {
            unset($this->BusinessAccount);
        } else {
            $this->BusinessAccount = $businessAccount;
        }
        return $this;
    }
    /**
     * Get ClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getClassID()
    {
        return isset($this->ClassID) ? $this->ClassID : null;
    }
    /**
     * Set ClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $classID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setClassID(\App\API\SOAP\StructType\StringValue $classID = null)
    {
        if (is_null($classID) || (is_array($classID) && empty($classID))) {
            unset($this->ClassID);
        } else {
            $this->ClassID = $classID;
        }
        return $this;
    }
    /**
     * Get ContactDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getContactDisplayName()
    {
        return isset($this->ContactDisplayName) ? $this->ContactDisplayName : null;
    }
    /**
     * Set ContactDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $contactDisplayName
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setContactDisplayName(\App\API\SOAP\StructType\StringValue $contactDisplayName = null)
    {
        if (is_null($contactDisplayName) || (is_array($contactDisplayName) && empty($contactDisplayName))) {
            unset($this->ContactDisplayName);
        } else {
            $this->ContactDisplayName = $contactDisplayName;
        }
        return $this;
    }
    /**
     * Get ContactID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getContactID()
    {
        return isset($this->ContactID) ? $this->ContactID : null;
    }
    /**
     * Set ContactID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $contactID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setContactID(\App\API\SOAP\StructType\IntValue $contactID = null)
    {
        if (is_null($contactID) || (is_array($contactID) && empty($contactID))) {
            unset($this->ContactID);
        } else {
            $this->ContactID = $contactID;
        }
        return $this;
    }
    /**
     * Get ContactInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\OpportunityContact|null
     */
    public function getContactInformation()
    {
        return isset($this->ContactInformation) ? $this->ContactInformation : null;
    }
    /**
     * Set ContactInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\OpportunityContact $contactInformation
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setContactInformation(\App\API\SOAP\StructType\OpportunityContact $contactInformation = null)
    {
        if (is_null($contactInformation) || (is_array($contactInformation) && empty($contactInformation))) {
            unset($this->ContactInformation);
        } else {
            $this->ContactInformation = $contactInformation;
        }
        return $this;
    }
    /**
     * Get ConvertedLeadDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getConvertedLeadDisplayName()
    {
        return isset($this->ConvertedLeadDisplayName) ? $this->ConvertedLeadDisplayName : null;
    }
    /**
     * Set ConvertedLeadDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $convertedLeadDisplayName
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setConvertedLeadDisplayName(\App\API\SOAP\StructType\StringValue $convertedLeadDisplayName = null)
    {
        if (is_null($convertedLeadDisplayName) || (is_array($convertedLeadDisplayName) && empty($convertedLeadDisplayName))) {
            unset($this->ConvertedLeadDisplayName);
        } else {
            $this->ConvertedLeadDisplayName = $convertedLeadDisplayName;
        }
        return $this;
    }
    /**
     * Get ConvertedLeadID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getConvertedLeadID()
    {
        return isset($this->ConvertedLeadID) ? $this->ConvertedLeadID : null;
    }
    /**
     * Set ConvertedLeadID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $convertedLeadID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setConvertedLeadID(\App\API\SOAP\StructType\IntValue $convertedLeadID = null)
    {
        if (is_null($convertedLeadID) || (is_array($convertedLeadID) && empty($convertedLeadID))) {
            unset($this->ConvertedLeadID);
        } else {
            $this->ConvertedLeadID = $convertedLeadID;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyViewState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCurrencyViewState()
    {
        return isset($this->CurrencyViewState) ? $this->CurrencyViewState : null;
    }
    /**
     * Set CurrencyViewState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $currencyViewState
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setCurrencyViewState(\App\API\SOAP\StructType\BooleanValue $currencyViewState = null)
    {
        if (is_null($currencyViewState) || (is_array($currencyViewState) && empty($currencyViewState))) {
            unset($this->CurrencyViewState);
        } else {
            $this->CurrencyViewState = $currencyViewState;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $details
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setDetails(\App\API\SOAP\StructType\StringValue $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $discount
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setDiscount(\App\API\SOAP\StructType\DecimalValue $discount = null)
    {
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Get Discounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Discounts|null
     */
    public function getDiscounts()
    {
        return isset($this->Discounts) ? $this->Discounts : null;
    }
    /**
     * Set Discounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Discounts $discounts
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setDiscounts(\App\API\SOAP\StructType\Discounts $discounts = null)
    {
        if (is_null($discounts) || (is_array($discounts) && empty($discounts))) {
            unset($this->Discounts);
        } else {
            $this->Discounts = $discounts;
        }
        return $this;
    }
    /**
     * Get Estimation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getEstimation()
    {
        return isset($this->Estimation) ? $this->Estimation : null;
    }
    /**
     * Set Estimation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $estimation
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setEstimation(\App\API\SOAP\StructType\DateTimeValue $estimation = null)
    {
        if (is_null($estimation) || (is_array($estimation) && empty($estimation))) {
            unset($this->Estimation);
        } else {
            $this->Estimation = $estimation;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $location
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setLocation(\App\API\SOAP\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get ManualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getManualAmount()
    {
        return isset($this->ManualAmount) ? $this->ManualAmount : null;
    }
    /**
     * Set ManualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $manualAmount
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setManualAmount(\App\API\SOAP\StructType\BooleanValue $manualAmount = null)
    {
        if (is_null($manualAmount) || (is_array($manualAmount) && empty($manualAmount))) {
            unset($this->ManualAmount);
        } else {
            $this->ManualAmount = $manualAmount;
        }
        return $this;
    }
    /**
     * Get OpportunityID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOpportunityID()
    {
        return isset($this->OpportunityID) ? $this->OpportunityID : null;
    }
    /**
     * Set OpportunityID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $opportunityID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setOpportunityID(\App\API\SOAP\StructType\StringValue $opportunityID = null)
    {
        if (is_null($opportunityID) || (is_array($opportunityID) && empty($opportunityID))) {
            unset($this->OpportunityID);
        } else {
            $this->OpportunityID = $opportunityID;
        }
        return $this;
    }
    /**
     * Get Override value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverride()
    {
        return isset($this->Override) ? $this->Override : null;
    }
    /**
     * Set Override value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $override
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setOverride(\App\API\SOAP\StructType\BooleanValue $override = null)
    {
        if (is_null($override) || (is_array($override) && empty($override))) {
            unset($this->Override);
        } else {
            $this->Override = $override;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setOwner(\App\API\SOAP\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerEmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwnerEmployeeName()
    {
        return isset($this->OwnerEmployeeName) ? $this->OwnerEmployeeName : null;
    }
    /**
     * Set OwnerEmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $ownerEmployeeName
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setOwnerEmployeeName(\App\API\SOAP\StructType\StringValue $ownerEmployeeName = null)
    {
        if (is_null($ownerEmployeeName) || (is_array($ownerEmployeeName) && empty($ownerEmployeeName))) {
            unset($this->OwnerEmployeeName);
        } else {
            $this->OwnerEmployeeName = $ownerEmployeeName;
        }
        return $this;
    }
    /**
     * Get ParentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getParentAccount()
    {
        return isset($this->ParentAccount) ? $this->ParentAccount : null;
    }
    /**
     * Set ParentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $parentAccount
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setParentAccount(\App\API\SOAP\StructType\StringValue $parentAccount = null)
    {
        if (is_null($parentAccount) || (is_array($parentAccount) && empty($parentAccount))) {
            unset($this->ParentAccount);
        } else {
            $this->ParentAccount = $parentAccount;
        }
        return $this;
    }
    /**
     * Get Products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Products|null
     */
    public function getProducts()
    {
        return isset($this->Products) ? $this->Products : null;
    }
    /**
     * Set Products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Products $products
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setProducts(\App\API\SOAP\StructType\Products $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->Products);
        } else {
            $this->Products = $products;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $reason
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setReason(\App\API\SOAP\StructType\StringValue $reason = null)
    {
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Get Relations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Relations|null
     */
    public function getRelations()
    {
        return isset($this->Relations) ? $this->Relations : null;
    }
    /**
     * Set Relations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Relations $relations
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setRelations(\App\API\SOAP\StructType\Relations $relations = null)
    {
        if (is_null($relations) || (is_array($relations) && empty($relations))) {
            unset($this->Relations);
        } else {
            $this->Relations = $relations;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $source
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setSource(\App\API\SOAP\StructType\StringValue $source = null)
    {
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get SourceCampaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSourceCampaign()
    {
        return isset($this->SourceCampaign) ? $this->SourceCampaign : null;
    }
    /**
     * Set SourceCampaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $sourceCampaign
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setSourceCampaign(\App\API\SOAP\StructType\StringValue $sourceCampaign = null)
    {
        if (is_null($sourceCampaign) || (is_array($sourceCampaign) && empty($sourceCampaign))) {
            unset($this->SourceCampaign);
        } else {
            $this->SourceCampaign = $sourceCampaign;
        }
        return $this;
    }
    /**
     * Get Stage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStage()
    {
        return isset($this->Stage) ? $this->Stage : null;
    }
    /**
     * Set Stage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $stage
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setStage(\App\API\SOAP\StructType\StringValue $stage = null)
    {
        if (is_null($stage) || (is_array($stage) && empty($stage))) {
            unset($this->Stage);
        } else {
            $this->Stage = $stage;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subject
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setSubject(\App\API\SOAP\StructType\StringValue $subject = null)
    {
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setTaxDetails(\App\API\SOAP\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setTaxZone(\App\API\SOAP\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotal()
    {
        return isset($this->Total) ? $this->Total : null;
    }
    /**
     * Set Total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $total
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setTotal(\App\API\SOAP\StructType\DecimalValue $total = null)
    {
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->Total);
        } else {
            $this->Total = $total;
        }
        return $this;
    }
    /**
     * Get WeightTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getWeightTotal()
    {
        return isset($this->WeightTotal) ? $this->WeightTotal : null;
    }
    /**
     * Set WeightTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $weightTotal
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setWeightTotal(\App\API\SOAP\StructType\DecimalValue $weightTotal = null)
    {
        if (is_null($weightTotal) || (is_array($weightTotal) && empty($weightTotal))) {
            unset($this->WeightTotal);
        } else {
            $this->WeightTotal = $weightTotal;
        }
        return $this;
    }
    /**
     * Get WorkgroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroupDescription()
    {
        return isset($this->WorkgroupDescription) ? $this->WorkgroupDescription : null;
    }
    /**
     * Set WorkgroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroupDescription
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setWorkgroupDescription(\App\API\SOAP\StructType\StringValue $workgroupDescription = null)
    {
        if (is_null($workgroupDescription) || (is_array($workgroupDescription) && empty($workgroupDescription))) {
            unset($this->WorkgroupDescription);
        } else {
            $this->WorkgroupDescription = $workgroupDescription;
        }
        return $this;
    }
    /**
     * Get WorkgroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroupID()
    {
        return isset($this->WorkgroupID) ? $this->WorkgroupID : null;
    }
    /**
     * Set WorkgroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroupID
     * @return \App\API\SOAP\StructType\Opportunity
     */
    public function setWorkgroupID(\App\API\SOAP\StructType\StringValue $workgroupID = null)
    {
        if (is_null($workgroupID) || (is_array($workgroupID) && empty($workgroupID))) {
            unset($this->WorkgroupID);
        } else {
            $this->WorkgroupID = $workgroupID;
        }
        return $this;
    }
}
