<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opportunities StructType
 * @subpackage Structs
 */
class Opportunities extends AbstractStructBase
{
    /**
     * The OpportunityDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\OpportunityDetail[]
     */
    public $OpportunityDetail;
    /**
     * The BusinessAccountOpportunityDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountOpportunityDetail[]
     */
    public $BusinessAccountOpportunityDetail;
    /**
     * Constructor method for Opportunities
     * @uses Opportunities::setOpportunityDetail()
     * @uses Opportunities::setBusinessAccountOpportunityDetail()
     * @param \App\API\SOAP\StructType\OpportunityDetail[] $opportunityDetail
     * @param \App\API\SOAP\StructType\BusinessAccountOpportunityDetail[] $businessAccountOpportunityDetail
     */
    public function __construct(array $opportunityDetail = array(), array $businessAccountOpportunityDetail = array())
    {
        $this
            ->setOpportunityDetail($opportunityDetail)
            ->setBusinessAccountOpportunityDetail($businessAccountOpportunityDetail);
    }
    /**
     * Get OpportunityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\OpportunityDetail[]|null
     */
    public function getOpportunityDetail()
    {
        return isset($this->OpportunityDetail) ? $this->OpportunityDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpportunityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpportunityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpportunityDetailForArrayConstraintsFromSetOpportunityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opportunitiesOpportunityDetailItem) {
            // validation for constraint: itemType
            if (!$opportunitiesOpportunityDetailItem instanceof \App\API\SOAP\StructType\OpportunityDetail) {
                $invalidValues[] = is_object($opportunitiesOpportunityDetailItem) ? get_class($opportunitiesOpportunityDetailItem) : sprintf('%s(%s)', gettype($opportunitiesOpportunityDetailItem), var_export($opportunitiesOpportunityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpportunityDetail property can only contain items of type \App\API\SOAP\StructType\OpportunityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpportunityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\OpportunityDetail[] $opportunityDetail
     * @return \App\API\SOAP\StructType\Opportunities
     */
    public function setOpportunityDetail(array $opportunityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($opportunityDetailArrayErrorMessage = self::validateOpportunityDetailForArrayConstraintsFromSetOpportunityDetail($opportunityDetail))) {
            throw new \InvalidArgumentException($opportunityDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($opportunityDetail) || (is_array($opportunityDetail) && empty($opportunityDetail))) {
            unset($this->OpportunityDetail);
        } else {
            $this->OpportunityDetail = $opportunityDetail;
        }
        return $this;
    }
    /**
     * Add item to OpportunityDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\OpportunityDetail $item
     * @return \App\API\SOAP\StructType\Opportunities
     */
    public function addToOpportunityDetail(\App\API\SOAP\StructType\OpportunityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\OpportunityDetail) {
            throw new \InvalidArgumentException(sprintf('The OpportunityDetail property can only contain items of type \App\API\SOAP\StructType\OpportunityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OpportunityDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountOpportunityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountOpportunityDetail[]|null
     */
    public function getBusinessAccountOpportunityDetail()
    {
        return isset($this->BusinessAccountOpportunityDetail) ? $this->BusinessAccountOpportunityDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountOpportunityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountOpportunityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountOpportunityDetailForArrayConstraintsFromSetBusinessAccountOpportunityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opportunitiesBusinessAccountOpportunityDetailItem) {
            // validation for constraint: itemType
            if (!$opportunitiesBusinessAccountOpportunityDetailItem instanceof \App\API\SOAP\StructType\BusinessAccountOpportunityDetail) {
                $invalidValues[] = is_object($opportunitiesBusinessAccountOpportunityDetailItem) ? get_class($opportunitiesBusinessAccountOpportunityDetailItem) : sprintf('%s(%s)', gettype($opportunitiesBusinessAccountOpportunityDetailItem), var_export($opportunitiesBusinessAccountOpportunityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountOpportunityDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountOpportunityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountOpportunityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountOpportunityDetail[] $businessAccountOpportunityDetail
     * @return \App\API\SOAP\StructType\Opportunities
     */
    public function setBusinessAccountOpportunityDetail(array $businessAccountOpportunityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountOpportunityDetailArrayErrorMessage = self::validateBusinessAccountOpportunityDetailForArrayConstraintsFromSetBusinessAccountOpportunityDetail($businessAccountOpportunityDetail))) {
            throw new \InvalidArgumentException($businessAccountOpportunityDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountOpportunityDetail) || (is_array($businessAccountOpportunityDetail) && empty($businessAccountOpportunityDetail))) {
            unset($this->BusinessAccountOpportunityDetail);
        } else {
            $this->BusinessAccountOpportunityDetail = $businessAccountOpportunityDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountOpportunityDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountOpportunityDetail $item
     * @return \App\API\SOAP\StructType\Opportunities
     */
    public function addToBusinessAccountOpportunityDetail(\App\API\SOAP\StructType\BusinessAccountOpportunityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\BusinessAccountOpportunityDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountOpportunityDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountOpportunityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountOpportunityDetail[] = $item;
        return $this;
    }
}
