<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingListDetail StructType
 * @subpackage Structs
 */
class MarketingListDetail extends Entity
{
    /**
     * The ContactID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $ContactID;
    /**
     * The DynamicList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $DynamicList;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Format;
    /**
     * The ListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ListName;
    /**
     * The MarketingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $MarketingListID;
    /**
     * The Subscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Subscribed;
    /**
     * Constructor method for MarketingListDetail
     * @uses MarketingListDetail::setContactID()
     * @uses MarketingListDetail::setDynamicList()
     * @uses MarketingListDetail::setFormat()
     * @uses MarketingListDetail::setListName()
     * @uses MarketingListDetail::setMarketingListID()
     * @uses MarketingListDetail::setSubscribed()
     * @param \App\API\SOAP\StructType\IntValue $contactID
     * @param \App\API\SOAP\StructType\BooleanValue $dynamicList
     * @param \App\API\SOAP\StructType\StringValue $format
     * @param \App\API\SOAP\StructType\StringValue $listName
     * @param \App\API\SOAP\StructType\IntValue $marketingListID
     * @param \App\API\SOAP\StructType\BooleanValue $subscribed
     */
    public function __construct(\App\API\SOAP\StructType\IntValue $contactID = null, \App\API\SOAP\StructType\BooleanValue $dynamicList = null, \App\API\SOAP\StructType\StringValue $format = null, \App\API\SOAP\StructType\StringValue $listName = null, \App\API\SOAP\StructType\IntValue $marketingListID = null, \App\API\SOAP\StructType\BooleanValue $subscribed = null)
    {
        $this
            ->setContactID($contactID)
            ->setDynamicList($dynamicList)
            ->setFormat($format)
            ->setListName($listName)
            ->setMarketingListID($marketingListID)
            ->setSubscribed($subscribed);
    }
    /**
     * Get ContactID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getContactID()
    {
        return isset($this->ContactID) ? $this->ContactID : null;
    }
    /**
     * Set ContactID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $contactID
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setContactID(\App\API\SOAP\StructType\IntValue $contactID = null)
    {
        if (is_null($contactID) || (is_array($contactID) && empty($contactID))) {
            unset($this->ContactID);
        } else {
            $this->ContactID = $contactID;
        }
        return $this;
    }
    /**
     * Get DynamicList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getDynamicList()
    {
        return isset($this->DynamicList) ? $this->DynamicList : null;
    }
    /**
     * Set DynamicList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $dynamicList
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setDynamicList(\App\API\SOAP\StructType\BooleanValue $dynamicList = null)
    {
        if (is_null($dynamicList) || (is_array($dynamicList) && empty($dynamicList))) {
            unset($this->DynamicList);
        } else {
            $this->DynamicList = $dynamicList;
        }
        return $this;
    }
    /**
     * Get Format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFormat()
    {
        return isset($this->Format) ? $this->Format : null;
    }
    /**
     * Set Format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $format
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setFormat(\App\API\SOAP\StructType\StringValue $format = null)
    {
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->Format);
        } else {
            $this->Format = $format;
        }
        return $this;
    }
    /**
     * Get ListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getListName()
    {
        return isset($this->ListName) ? $this->ListName : null;
    }
    /**
     * Set ListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $listName
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setListName(\App\API\SOAP\StructType\StringValue $listName = null)
    {
        if (is_null($listName) || (is_array($listName) && empty($listName))) {
            unset($this->ListName);
        } else {
            $this->ListName = $listName;
        }
        return $this;
    }
    /**
     * Get MarketingListID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getMarketingListID()
    {
        return isset($this->MarketingListID) ? $this->MarketingListID : null;
    }
    /**
     * Set MarketingListID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $marketingListID
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setMarketingListID(\App\API\SOAP\StructType\IntValue $marketingListID = null)
    {
        if (is_null($marketingListID) || (is_array($marketingListID) && empty($marketingListID))) {
            unset($this->MarketingListID);
        } else {
            $this->MarketingListID = $marketingListID;
        }
        return $this;
    }
    /**
     * Get Subscribed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSubscribed()
    {
        return isset($this->Subscribed) ? $this->Subscribed : null;
    }
    /**
     * Set Subscribed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $subscribed
     * @return \App\API\SOAP\StructType\MarketingListDetail
     */
    public function setSubscribed(\App\API\SOAP\StructType\BooleanValue $subscribed = null)
    {
        if (is_null($subscribed) || (is_array($subscribed) && empty($subscribed))) {
            unset($this->Subscribed);
        } else {
            $this->Subscribed = $subscribed;
        }
        return $this;
    }
}
